/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.DPoint;
import edu.mines.jtk.util.Check;

public class DRectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public DRectangle(double x, double y, double width, double height) {
        Check.argument(width >= 0.0, "width is non-negative");
        Check.argument(height >= 0.0, "height is non-negative");
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public DRectangle(DRectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public DRectangle union(DRectangle rect) {
        double xn = Math.min(this.x, rect.x);
        double yn = Math.min(this.y, rect.y);
        double wn = Math.max(this.x + this.width, rect.x + rect.width) - xn;
        double hn = Math.max(this.y + this.height, rect.y + rect.height) - yn;
        return new DRectangle(xn, yn, wn, hn);
    }

    public DRectangle intersection(DRectangle rect) {
        double xn = Math.max(this.x, rect.x);
        double yn = Math.max(this.y, rect.y);
        double wn = Math.max(Math.min(this.x + this.width, rect.x + rect.width) - xn, 0.0);
        double hn = Math.max(Math.min(this.y + this.height, rect.y + rect.height) - yn, 0.0);
        return new DRectangle(xn, yn, wn, hn);
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean contains(DPoint point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double x, double y) {
        return this.x <= x && this.y <= y && x - this.x <= this.width && y - this.y <= this.height;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DRectangle that = (DRectangle)obj;
        return this.x == that.x && this.y == that.y && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        long xbits = Double.doubleToLongBits(this.x);
        long ybits = Double.doubleToLongBits(this.y);
        long wbits = Double.doubleToLongBits(this.width);
        long hbits = Double.doubleToLongBits(this.height);
        return (int)(xbits ^ xbits >>> 32 ^ ybits ^ ybits >>> 32 ^ wbits ^ wbits >>> 32 ^ hbits ^ hbits >>> 32);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.width + "," + this.height + ")";
    }
}

