/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import edu.mines.jtk.util.ArrayMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class TensorsView
extends TiledView {
    private Sampling _s1;
    private Sampling _s2;
    private EigenTensors2 _et;
    private Sampling _e1;
    private Sampling _e2;
    private int _ne = 20;
    private int _np = 50;
    private float[][] _x1;
    private float[][] _x2;
    private Orientation _orientation = Orientation.X1RIGHT_X2UP;
    private float _lineWidth = 0.0f;
    private Color _lineColor = null;
    private double _scale = 1.0;

    public TensorsView(EigenTensors2 et) {
        this(new Sampling(et.getN1(), 1.0, 0.0), new Sampling(et.getN2(), 1.0, 0.0), et);
    }

    public TensorsView(Sampling s1, Sampling s2, EigenTensors2 et) {
        this._s1 = s1;
        this._s2 = s2;
        this.updateBestProjectors();
        this.set(et);
    }

    public void set(EigenTensors2 et) {
        this._et = et;
        this.updateTensorEllipses();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setEllipsesDisplayed(int ne) {
        this._ne = ne;
        this.updateTensorEllipses();
    }

    public void setEllipsesDisplayed(Sampling e1, Sampling e2) {
        this._e1 = e1;
        this._e2 = e2;
        this.updateTensorEllipses();
    }

    public void setScale(double scale) {
        this._scale = scale;
        this.updateTensorEllipses();
    }

    public void setLineWidth(float width) {
        if (this._lineWidth != width) {
            this._lineWidth = width;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        if (!this.equalColors(this._lineColor, color)) {
            this._lineColor = color;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Projector hp = this.getHorizontalProjector();
        Projector vp = this.getVerticalProjector();
        Transcaler ts = this.getTranscaler();
        ts = ts.combineWith(hp, vp);
        float lineWidth = 1.0f;
        Stroke stroke = g2d.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            lineWidth = bs.getLineWidth();
        }
        Graphics2D gpoly = (Graphics2D)g2d.create();
        float width = lineWidth;
        if (this._lineWidth != 0.0f) {
            width *= this._lineWidth;
        }
        BasicStroke bs = new BasicStroke(width);
        gpoly.setStroke(bs);
        if (this._lineColor != null) {
            gpoly.setColor(this._lineColor);
        }
        int ne = this._x1.length;
        int np = this._x1[0].length;
        int[] xp = new int[np];
        int[] yp = new int[np];
        float[][] xv = null;
        float[][] yv = null;
        if (this._orientation == Orientation.X1RIGHT_X2UP) {
            xv = this._x1;
            yv = this._x2;
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            xv = this._x2;
            yv = this._x1;
        }
        for (int ie = 0; ie < ne; ++ie) {
            float[] xe = xv[ie];
            float[] ye = yv[ie];
            for (int ip = 0; ip < np; ++ip) {
                xp[ip] = ts.x(xe[ip]);
                yp[ip] = ts.y(ye[ip]);
            }
            gpoly.drawPolygon(xp, yp, np);
        }
    }

    private void updateTensorEllipses() {
        int n1 = this._s1.getCount();
        int n2 = this._s2.getCount();
        double d1 = this._s1.getDelta();
        double d2 = this._s2.getDelta();
        double f1 = this._s1.getFirst();
        double f2 = this._s2.getFirst();
        Sampling e1 = this._e1;
        Sampling e2 = this._e2;
        if (e1 == null || e2 == null) {
            int ne = ArrayMath.min(this._ne, n1, n2);
            int ns = ArrayMath.max(n1 / ne, n2 / ne);
            int m1 = (n1 - 1) / ns;
            int m2 = (n2 - 1) / ns;
            int j1 = (n1 - 1 - (m1 - 1) * ns) / 2;
            int j2 = (n2 - 1 - (m2 - 1) * ns) / 2;
            e1 = new Sampling(m1, (double)ns * d1, f1 + (double)j1 * d1);
            e2 = new Sampling(m2, (double)ns * d2, f2 + (double)j2 * d2);
        }
        int m1 = e1.getCount();
        int m2 = e2.getCount();
        int nm = m1 * m2;
        int np = this._np;
        double dp = Math.PI * 2 / (double)np;
        double fp = 0.0;
        float emax = 0.0f;
        float[] a = new float[2];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                this._et.getEigenvalues(i1, i2, a);
                emax = ArrayMath.max(emax, a[0], a[1]);
            }
        }
        double ratio = ArrayMath.min(e1.getDelta() / d1, e2.getDelta() / d2);
        double r = (double)emax > 0.0 ? 0.48 * ratio / (double)ArrayMath.sqrt(emax) : 0.0;
        r *= this._scale;
        this._x1 = new float[nm][np];
        this._x2 = new float[nm][np];
        float[] u = new float[2];
        int im = 0;
        for (int i2 = 0; i2 < m2; ++i2) {
            double x2 = e2.getValue(i2);
            int j2 = this._s2.indexOfNearest(x2);
            int i1 = 0;
            while (i1 < m1) {
                double x1 = e1.getValue(i1);
                int j1 = this._s1.indexOfNearest(x1);
                this._et.getEigenvalues(j1, j2, a);
                this._et.getEigenvectorU(j1, j2, u);
                double u1 = u[0];
                double u2 = u[1];
                double du = a[0];
                double dv = a[1];
                double ru = r * ArrayMath.sqrt(du);
                double rv = r * ArrayMath.sqrt(dv);
                for (int ip = 0; ip < np; ++ip) {
                    double p = fp + (double)ip * dp;
                    double cosp = ArrayMath.cos(p);
                    double sinp = ArrayMath.sin(p);
                    this._x1[im][ip] = (float)(x1 + d1 * (ru * cosp * u1 - rv * sinp * u2));
                    this._x2[im][ip] = (float)(x2 + d2 * (rv * sinp * u1 + ru * cosp * u2));
                }
                ++i1;
                ++im;
            }
        }
    }

    private void updateBestProjectors() {
        double uy1;
        double uy0;
        double ux1;
        double ux0;
        double y1;
        double y0;
        double x1;
        double x0;
        int n1 = this._s1.getCount();
        int n2 = this._s2.getCount();
        double d1 = this._s1.getDelta();
        double d2 = this._s2.getDelta();
        double f1 = this._s1.getFirst();
        double f2 = this._s2.getFirst();
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            x0 = f2;
            x1 = f2 + d2 * (double)(n2 - 1);
            y0 = f1;
            y1 = f1 + d1 * (double)(n1 - 1);
            ux0 = 0.5 / (double)n2;
            ux1 = 1.0 - 0.5 / (double)n2;
            uy0 = 0.5 / (double)n1;
            uy1 = 1.0 - 0.5 / (double)n1;
        } else {
            x0 = f1;
            x1 = f1 + d1 * (double)(n1 - 1);
            y0 = f2 + d2 * (double)(n2 - 1);
            y1 = f2;
            ux0 = 0.5 / (double)n1;
            ux1 = 1.0 - 0.5 / (double)n1;
            uy0 = 0.5 / (double)n2;
            uy1 = 1.0 - 0.5 / (double)n2;
        }
        Projector bhp = new Projector(x0, x1, ux0, ux1);
        Projector bvp = new Projector(y0, y1, uy0, uy1);
        this.setBestProjectors(bhp, bvp);
    }

    private boolean equalColors(Color ca, Color cb) {
        return ca == null ? cb == null : ca.equals(cb);
    }

    public static enum Orientation {
        X1RIGHT_X2UP,
        X1DOWN_X2RIGHT;

    }
}

