/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1f;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayVect1fTest
extends TestCase {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt.test");

    public void testAll() throws Exception {
        float[] a = new float[31];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        ArrayVect1f v = new ArrayVect1f(a, 0, 3.0);
        VectUtil.test(v);
        v = new ArrayVect1f(a, 10, 3.0);
        VectUtil.test(v);
        for (int i = 0; i < a.length; ++i) {
            a[i] = 1.0f;
        }
        v = new ArrayVect1f(a, 0, 3.0);
        Vect w = v.clone();
        w.multiplyInverseCovariance();
        assert (Almost.FLOAT.equal(0.3333333333333333, v.dot(w)));
        assert (Almost.FLOAT.equal(0.3333333333333333, v.magnitude()));
        float[] data = new float[501];
        Arrays.fill(data, 1.0f);
        int minimumSize = data.length * 4;
        int externalSize = 10 * minimumSize;
        int writeObjectSize = 10 * minimumSize;
        LOG.fine("minimum size = " + minimumSize);
        ArrayVect1f v2 = new ArrayVect1f(data, 0, 1.0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(v2);
        oos.close();
        byte[] result = baos.toByteArray();
        externalSize = result.length;
        LOG.fine("externalizable size = " + externalSize);
        baos = new ByteArrayOutputStream(0);
        oos = new ObjectOutputStream(baos);
        oos.writeObject(v2);
        oos.close();
        result = baos.toByteArray();
        writeObjectSize = result.length;
        LOG.fine("writeObject size = " + writeObjectSize);
        assert (externalSize <= minimumSize + 308) : externalSize + " <= " + (minimumSize + 308);
        assert (writeObjectSize <= minimumSize + 308) : writeObjectSize + "<=" + (minimumSize + 308);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ArrayVect1fTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(ArrayVect1fTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ArrayVect1fTest.suite());
    }
}

