/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.util.MathPlus;

public class BrentMinFinder {
    private static final double GSI = 0.5 * (3.0 - MathPlus.sqrt(5.0));
    private static final double EPS = MathPlus.sqrt(2.220446049250313E-16);
    private Function _f;

    public BrentMinFinder(Function f) {
        this._f = f;
    }

    public double f(double x) {
        return this._f.evaluate(x);
    }

    public double findMin(double a, double b, double tol) {
        double fx;
        double x;
        double v = x = a + GSI * (b - a);
        double w = x;
        double fv = fx = this.f(x);
        double fw = fx;
        double d = 0.0;
        double e = 0.0;
        double xm = 0.5 * (a + b);
        double tol1 = EPS * MathPlus.abs(x) + tol / 3.0;
        double tol2 = 2.0 * tol1;
        while (MathPlus.abs(x - xm) > tol2 - 0.5 * (b - a)) {
            double u;
            double fu;
            boolean gsstep;
            boolean bl = gsstep = MathPlus.abs(e) <= tol1;
            if (!gsstep) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = MathPlus.abs(q);
                r = e;
                e = d;
                if (MathPlus.abs(p) < MathPlus.abs(0.5 * q * r) && p > q * (a - x) && p < q * (b - x)) {
                    d = p / q;
                    double u2 = x + d;
                    if (u2 - a < tol2 || b - u2 < tol2) {
                        d = xm >= x ? tol1 : -tol1;
                    }
                } else {
                    gsstep = true;
                }
            }
            if (gsstep) {
                e = x >= xm ? a - x : b - x;
                d = GSI * e;
            }
            if ((fu = this.f(u = x + (MathPlus.abs(d) >= tol1 ? d : (d >= 0.0 ? tol1 : -tol1)))) <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    w = u;
                    fv = fw;
                    fw = fu;
                } else if (fu <= fv || v == x || v == w) {
                    v = u;
                    fv = fu;
                }
            }
            xm = 0.5 * (a + b);
            tol1 = EPS * MathPlus.abs(x) + tol / 3.0;
            tol2 = 2.0 * tol1;
        }
        return x;
    }

    public static interface Function {
        public double evaluate(double var1);
    }
}

