/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1;
import edu.mines.jtk.opt.VectArray;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VectArrayTest
extends TestCase {
    public void testAll() {
        int index;
        Random random = new Random(32525L);
        VectArray vm = new VectArray(5);
        for (int index2 = 0; index2 < 5; ++index2) {
            double[] a = new double[7 * index2];
            for (int i = 0; i < a.length; ++i) {
                a[i] = random.nextDouble();
            }
            ArrayVect1 v = new ArrayVect1(a, 2.0);
            vm.put(index2, v);
            assert (vm.containsKey(index2));
        }
        assert (!vm.containsKey(99));
        VectUtil.test(vm);
        int[] keys = vm.getKeys();
        assert (keys.length == 5) : "keys.length = " + keys.length;
        for (int i = 0; i < 5; ++i) {
            assert (keys[i] == i);
        }
        for (index = 0; index < 5; ++index) {
            ArrayVect1 value = (ArrayVect1)vm.get(index);
            assert (value != null) : "index=" + index;
            assert (value.getData() != null) : "index=" + index;
            assert (value.getSize() == 7 * index) : "index=" + index;
            assert (value.getData().length == 7 * index) : "index=" + index;
        }
        vm = new VectArray(5);
        for (index = 0; index < 5; ++index) {
            double[] a = new double[7 * index + 1];
            for (int i = 0; i < a.length; ++i) {
                a[i] = 1.0;
            }
            ArrayVect1 v = new ArrayVect1(a, 1.0);
            vm.put(index, v);
        }
        VectArray wm = vm.clone();
        wm.multiplyInverseCovariance();
        assert (Almost.FLOAT.equal(1.0, wm.dot(vm))) : wm.dot(vm);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public VectArrayTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(VectArrayTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VectArrayTest.suite());
    }
}

