/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class BoundingBoxTree {
    private int _n;
    private int[] _i;
    private float[] _x;
    private float[] _y;
    private float[] _z;
    private Node _root;

    public BoundingBoxTree(int minSize, float[] xyz) {
        Check.argument(minSize > 0, "minSize>0");
        this._n = xyz.length / 3;
        this._i = ArrayMath.rampint(0, 1, this._n);
        this._x = ArrayMath.copy(this._n, 0, 3, xyz);
        this._y = ArrayMath.copy(this._n, 1, 3, xyz);
        this._z = ArrayMath.copy(this._n, 2, 3, xyz);
        this._root = new Node();
        this._root._bb = new BoundingBox(this._x, this._y, this._z);
        this._root._kmin = 0;
        this._root._kmax = this._n - 1;
        this.split(minSize, this._root);
        this._z = null;
        this._y = null;
        this._x = null;
    }

    public BoundingBoxTree(int minSize, float[] x, float[] y, float[] z) {
        Check.argument(minSize > 0, "minSize>0");
        Check.argument(x.length == y.length, "x.length==y.length");
        Check.argument(x.length == z.length, "x.length==z.length");
        this._n = x.length;
        this._i = ArrayMath.rampint(0, 1, this._n);
        this._x = ArrayMath.copy(x);
        this._y = ArrayMath.copy(y);
        this._z = ArrayMath.copy(z);
        this._root = new Node();
        this._root._bb = new BoundingBox(this._x, this._y, this._z);
        this._root._kmin = 0;
        this._root._kmax = this._n - 1;
        this.split(minSize, this._root);
        this._z = null;
        this._y = null;
        this._x = null;
    }

    public Node getRoot() {
        return this._root;
    }

    private void split(int minSize, Node node) {
        int kmin = node._kmin;
        int kmax = node._kmax;
        int n = 1 + kmax - kmin;
        if (n / 2 < minSize) {
            return;
        }
        BoundingBox bb = node._bb;
        Point3 min = bb.getMin();
        Point3 max = bb.getMax();
        double xdif = max.x - min.x;
        double ydif = max.y - min.y;
        double zdif = max.z - min.z;
        double adif = MathPlus.max(xdif, ydif, zdif);
        float[] a = adif == xdif ? this._x : (adif == ydif ? this._y : this._z);
        int[] i = new int[n];
        for (int k = kmin; k <= kmax; ++k) {
            i[k - kmin] = this._i[k];
        }
        int kmid = kmin + n / 2;
        ArrayMath.quickPartialIndexSort(kmid - kmin, a, i);
        for (int k = kmin; k <= kmax; ++k) {
            this._i[k] = i[k - kmin];
        }
        Node left = new Node();
        Node right = new Node();
        if (adif == xdif) {
            float spltx = this._x[this._i[kmid]];
            left._bb = new BoundingBox(min.x, min.y, min.z, spltx, max.y, max.z);
            right._bb = new BoundingBox(spltx, min.y, min.z, max.x, max.y, max.z);
        } else if (adif == ydif) {
            float splty = this._y[this._i[kmid]];
            left._bb = new BoundingBox(min.x, min.y, min.z, max.x, splty, max.z);
            right._bb = new BoundingBox(min.x, splty, min.z, max.x, max.y, max.z);
        } else {
            float spltz = this._z[this._i[kmid]];
            left._bb = new BoundingBox(min.x, min.y, min.z, max.x, max.y, spltz);
            right._bb = new BoundingBox(min.x, min.y, spltz, max.x, max.y, max.z);
        }
        left._kmin = kmin;
        left._kmax = kmid - 1;
        right._kmin = kmid;
        right._kmax = kmax;
        node._left = left;
        node._right = right;
        this.split(minSize, left);
        this.split(minSize, right);
    }

    public class Node {
        private BoundingBox _bb;
        private int _kmin;
        private int _kmax;
        private Node _left;
        private Node _right;

        public BoundingBox getBoundingBox() {
            return new BoundingBox(this._bb);
        }

        public int getSize() {
            return 1 + this._kmax - this._kmin;
        }

        public int[] getIndices() {
            return ArrayMath.copy(1 + this._kmax - this._kmin, this._kmin, BoundingBoxTree.this._i);
        }

        public Node getLeft() {
            return this._left;
        }

        public Node getRight() {
            return this._right;
        }

        public boolean isLeaf() {
            return this._left == null;
        }
    }
}

