/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.Check;

public class BoundingSphere {
    private double _x = 0.0;
    private double _y = 0.0;
    private double _z = 0.0;
    private double _r = -1.0;

    public BoundingSphere() {
        this.setEmpty();
    }

    public BoundingSphere(double x, double y, double z, double r) {
        Check.argument(r >= 0.0, "r>=0.0");
        this._x = x;
        this._y = y;
        this._z = z;
        this._r = r;
    }

    public BoundingSphere(Point3 c, double r) {
        this(c.x, c.y, c.z, r);
    }

    public BoundingSphere(BoundingBox bb) {
        this();
        this.expandBy(bb);
    }

    public BoundingSphere(BoundingSphere bs) {
        this._x = bs._x;
        this._y = bs._y;
        this._z = bs._z;
        this._r = bs._r;
    }

    public boolean isEmpty() {
        return this._r < 0.0;
    }

    public boolean isInfinite() {
        return this._r == Double.POSITIVE_INFINITY;
    }

    public Point3 getCenter() {
        Check.state(!this.isEmpty(), "bounding sphere is not empty");
        Check.state(!this.isInfinite(), "bounding sphere is not infinite");
        return new Point3(this._x, this._y, this._z);
    }

    public double getRadius() {
        Check.state(!this.isEmpty(), "bounding sphere is not empty");
        return this._r;
    }

    public double getRadiusSquared() {
        Check.state(!this.isEmpty(), "bounding sphere is not empty");
        return this._r * this._r;
    }

    public void expandBy(double x, double y, double z) {
        if (!this.isInfinite()) {
            if (!this.isEmpty()) {
                double dx = x - this._x;
                double dy = y - this._y;
                double dz = z - this._z;
                double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (d > this._r) {
                    double dr = 0.5 * (d - this._r);
                    double ds = dr / d;
                    this._x += dx * ds;
                    this._y += dy * ds;
                    this._z += dz * ds;
                    this._r += dr;
                }
            } else {
                this._x = x;
                this._y = y;
                this._z = z;
                this._r = 0.0;
            }
        }
    }

    public void expandRadiusBy(double x, double y, double z) {
        if (!this.isInfinite()) {
            if (!this.isEmpty()) {
                double dx = x - this._x;
                double dy = y - this._y;
                double dz = z - this._z;
                double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                if (d > this._r) {
                    this._r = d;
                }
            } else {
                this._x = x;
                this._y = y;
                this._z = z;
                this._r = 0.0;
            }
        }
    }

    public void expandBy(Point3 p) {
        this.expandBy(p.x, p.y, p.z);
    }

    public void expandRadiusBy(Point3 p) {
        this.expandRadiusBy(p.x, p.y, p.z);
    }

    public void expandBy(BoundingSphere bs) {
        if (!this.isInfinite()) {
            if (!bs.isInfinite()) {
                if (!bs.isEmpty()) {
                    if (!this.isEmpty()) {
                        double dx = bs._x - this._x;
                        double dy = bs._y - this._y;
                        double dz = bs._z - this._z;
                        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (d == 0.0 && bs._r > this._r) {
                            this._r = bs._r;
                        } else if (d + bs._r > this._r) {
                            double da = this._r / d;
                            double xa = this._x - dx * da;
                            double ya = this._y - dy * da;
                            double za = this._z - dz * da;
                            double db = bs._r / d;
                            double xb = bs._x + dx * db;
                            double yb = bs._y + dy * db;
                            double zb = bs._z + dz * db;
                            dx = xb - this._x;
                            dy = yb - this._y;
                            dz = zb - this._z;
                            this._r = Math.sqrt(dx * dx + dy * dy + dz * dz);
                            this._x = 0.5 * (xa + xb);
                            this._y = 0.5 * (ya + yb);
                            this._z = 0.5 * (za + zb);
                        }
                    } else {
                        this._r = bs._r;
                        this._x = bs._x;
                        this._y = bs._y;
                        this._z = bs._z;
                    }
                }
            } else {
                this.setInfinite();
            }
        }
    }

    public void expandRadiusBy(BoundingSphere bs) {
        if (!this.isInfinite()) {
            if (!bs.isInfinite()) {
                if (!bs.isEmpty()) {
                    if (!this.isEmpty()) {
                        double dx = bs._x - this._x;
                        double dy = bs._y - this._y;
                        double dz = bs._z - this._z;
                        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        double r = d + bs._r;
                        if (r > this._r) {
                            this._r = r;
                        }
                    } else {
                        this._r = bs._r;
                        this._x = bs._x;
                        this._y = bs._y;
                        this._z = bs._z;
                    }
                }
            } else {
                this.setInfinite();
            }
        }
    }

    public void expandBy(BoundingBox bb) {
        if (!this.isInfinite()) {
            if (!bb.isInfinite()) {
                if (!bb.isEmpty()) {
                    Point3 pmin = bb.getMin();
                    Point3 pmax = bb.getMax();
                    double xmin = pmin.x;
                    double ymin = pmin.y;
                    double zmin = pmin.z;
                    double xmax = pmax.x;
                    double ymax = pmax.y;
                    double zmax = pmax.z;
                    if (!this.isEmpty()) {
                        for (int i = 0; i < 8; ++i) {
                            double x = (i & 1) == 0 ? xmin : xmax;
                            double y = (i & 2) == 0 ? ymin : ymax;
                            double z = (i & 4) == 0 ? zmin : zmax;
                            double dx = x - this._x;
                            double dy = y - this._y;
                            double dz = z - this._z;
                            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                            double ds = d > 0.0 ? this._r / d : this._r;
                            x = this._x - dx * ds;
                            y = this._y - dy * ds;
                            z = this._z - dz * ds;
                            if (x < xmin) {
                                xmin = x;
                            }
                            if (y < ymin) {
                                ymin = y;
                            }
                            if (z < zmin) {
                                zmin = z;
                            }
                            if (x > xmax) {
                                xmax = x;
                            }
                            if (y > ymax) {
                                ymax = y;
                            }
                            if (!(z > zmax)) continue;
                            zmax = z;
                        }
                    }
                    double dx = xmax - xmin;
                    double dy = ymax - ymin;
                    double dz = zmax - zmin;
                    this._r = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
                    this._x = 0.5 * (xmin + xmax);
                    this._y = 0.5 * (ymin + ymax);
                    this._z = 0.5 * (zmin + zmax);
                }
            } else {
                this.setInfinite();
            }
        }
    }

    public void expandRadiusBy(BoundingBox bb) {
        if (!this.isInfinite()) {
            if (!bb.isInfinite()) {
                if (!bb.isEmpty()) {
                    Point3 pmin = bb.getMin();
                    Point3 pmax = bb.getMax();
                    double xmin = pmin.x;
                    double ymin = pmin.y;
                    double zmin = pmin.z;
                    double xmax = pmax.x;
                    double ymax = pmax.y;
                    double zmax = pmax.z;
                    if (!this.isEmpty()) {
                        for (int i = 0; i < 8; ++i) {
                            double x = (i & 1) == 0 ? xmin : xmax;
                            double y = (i & 2) == 0 ? ymin : ymax;
                            double z = (i & 4) == 0 ? zmin : zmax;
                            this.expandRadiusBy(x, y, z);
                        }
                    } else {
                        double dx = xmax - xmin;
                        double dy = ymax - ymin;
                        double dz = zmax - zmin;
                        this._r = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
                        this._x = 0.5 * (xmin + xmax);
                        this._y = 0.5 * (ymin + ymax);
                        this._z = 0.5 * (zmin + zmax);
                    }
                }
            } else {
                this.setInfinite();
            }
        }
    }

    public boolean contains(double x, double y, double z) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.isInfinite()) {
            return true;
        }
        double dx = this._x - x;
        double dy = this._y - y;
        double dz = this._z - z;
        double rs = this._r * this._r;
        return dx * dx + dy * dy + dz * dz <= rs;
    }

    public boolean contains(Point3 p) {
        return this.contains(p.x, p.y, p.z);
    }

    public static BoundingSphere empty() {
        return new BoundingSphere();
    }

    public static BoundingSphere infinite() {
        BoundingSphere bs = new BoundingSphere();
        bs.setInfinite();
        return bs;
    }

    public String toString() {
        return "{" + this.getCenter() + ":" + this.getRadius() + "}";
    }

    private void setEmpty() {
        this._x = 0.0;
        this._y = 0.0;
        this._z = 0.0;
        this._r = -1.0;
    }

    private void setInfinite() {
        this._x = 0.0;
        this._y = 0.0;
        this._z = 0.0;
        this._r = Double.POSITIVE_INFINITY;
    }
}

