/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.AxisAlignedQuad;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.ImagePanel;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Float3;
import edu.mines.jtk.util.SimpleFloat3;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Iterator;

public class ImagePanelGroup
extends Group {
    private Sampling _s1;
    private Sampling _s2;
    private Sampling _s3;
    private ArrayList<ImagePanel> _ipList;
    private Clips _clips;
    private ColorMap _colorMap = new ColorMap(0.0, 1.0, ColorMap.GRAY);

    public ImagePanelGroup(float[][][] f) {
        this(new Sampling(f[0][0].length), new Sampling(f[0].length), new Sampling(f.length), f);
    }

    public ImagePanelGroup(Sampling s1, Sampling s2, Sampling s3, float[][][] f) {
        this(s1, s2, s3, new SimpleFloat3(f));
    }

    public ImagePanelGroup(Sampling s1, Sampling s2, Sampling s3, Float3 f) {
        this(s1, s2, s3, f, new Axis[]{Axis.X, Axis.Y, Axis.Z});
    }

    public ImagePanelGroup(Sampling s1, Sampling s2, Sampling s3, float[][][] f, Axis[] axes) {
        this(s1, s2, s3, new SimpleFloat3(f), axes);
    }

    public ImagePanelGroup(Sampling s1, Sampling s2, Sampling s3, Float3 f, Axis[] axes) {
        this._clips = new Clips(f);
        this.addPanels(s1, s2, s3, f, axes);
        this.addChild(new Wires(this._ipList));
    }

    public ImagePanel getImagePanel(Axis axis) {
        for (ImagePanel ip : this._ipList) {
            if (axis != ip.getFrame().getAxis()) continue;
            return ip;
        }
        return null;
    }

    public Iterator<ImagePanel> getImagePanels() {
        return this._ipList.iterator();
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorMap.setColorModel(colorModel);
        for (ImagePanel ip : this._ipList) {
            ip.setColorModel(colorModel);
        }
    }

    public IndexColorModel getColorModel() {
        return this._colorMap.getColorModel();
    }

    public void setClips(double clipMin, double clipMax) {
        this._clips.setClips(clipMin, clipMax);
        clipMin = this._clips.getClipMin();
        clipMax = this._clips.getClipMax();
        for (ImagePanel ip : this._ipList) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap.setValueRange(clipMin, clipMax);
    }

    public float getClipMin() {
        return this._clips.getClipMin();
    }

    public float getClipMax() {
        return this._clips.getClipMax();
    }

    public void setPercentiles(double percMin, double percMax) {
        this._clips.setPercentiles(percMin, percMax);
        double clipMin = this._clips.getClipMin();
        double clipMax = this._clips.getClipMax();
        for (ImagePanel ip : this._ipList) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap.setValueRange(clipMin, clipMax);
    }

    public float getPercentileMin() {
        return this._clips.getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips.getPercentileMax();
    }

    public void addColorMapListener(ColorMapListener cml) {
        this._colorMap.addListener(cml);
    }

    public void removeColorMapListener(ColorMapListener cml) {
        this._colorMap.removeListener(cml);
    }

    public void setSlices(int k1, int k2, int k3) {
        int nx = this._s3.getCount();
        int ny = this._s2.getCount();
        int nz = this._s1.getCount();
        double dx = this._s3.getDelta();
        double dy = this._s2.getDelta();
        double dz = this._s1.getDelta();
        double fx = this._s3.getFirst();
        double fy = this._s2.getFirst();
        double fz = this._s1.getFirst();
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        int kx = Math.max(0, Math.min(nx - 1, k3));
        int ky = Math.max(0, Math.min(ny - 1, k2));
        int kz = Math.max(0, Math.min(nz - 1, k1));
        double xk = fx + (double)kx * dx;
        double yk = fy + (double)ky * dy;
        double zk = fz + (double)kz * dz;
        for (ImagePanel ip : this._ipList) {
            AxisAlignedFrame frame = ip.getFrame();
            Axis axis = frame.getAxis();
            if (axis == Axis.X) {
                frame.setCorners(new Point3(xk, fy, fz), new Point3(xk, ly, lz));
                continue;
            }
            if (axis == Axis.Y) {
                frame.setCorners(new Point3(fx, yk, fz), new Point3(lx, yk, lz));
                continue;
            }
            frame.setCorners(new Point3(fx, fy, zk), new Point3(lx, ly, zk));
        }
    }

    private void addPanels(Sampling s1, Sampling s2, Sampling s3, Float3 f3, Axis[] axes) {
        this._s1 = s1;
        this._s2 = s2;
        this._s3 = s3;
        int nx = s3.getCount();
        int ny = s2.getCount();
        int nz = s1.getCount();
        double dx = s3.getDelta();
        double dy = s2.getDelta();
        double dz = s1.getDelta();
        double fx = s3.getFirst();
        double fy = s2.getFirst();
        double fz = s1.getFirst();
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        Point3 qmin = new Point3(fx, fy, fz);
        Point3 qmax = new Point3(lx, ly, lz);
        int np = axes.length;
        this._ipList = new ArrayList(np);
        for (int jp = 0; jp < np; ++jp) {
            AxisAlignedQuad aaq = new AxisAlignedQuad(axes[jp], qmin, qmax);
            ImagePanel ip = new ImagePanel(s1, s2, s3, f3);
            ip.setColorModel(this.getColorModel());
            aaq.getFrame().addChild(ip);
            this.addChild(aaq);
            this._ipList.add(ip);
        }
    }

    static class Wires
    extends Node {
        private ArrayList<ImagePanel> _ipList;

        Wires(ArrayList<ImagePanel> ipList) {
            this._ipList = ipList;
        }

        @Override
        protected void draw(DrawContext dc) {
            Gl.glColor3f(1.0f, 1.0f, 1.0f);
            Gl.glLineWidth(1.5f);
            for (ImagePanel ip : this._ipList) {
                AxisAlignedFrame fi = ip.getFrame();
                Axis ai = fi.getAxis();
                for (ImagePanel jp : this._ipList) {
                    AxisAlignedFrame fj = jp.getFrame();
                    Axis aj = fj.getAxis();
                    if (ai == aj) continue;
                    Point3 pmini = fi.getCornerMin();
                    Point3 pmaxi = fi.getCornerMax();
                    Point3 pminj = fj.getCornerMin();
                    Point3 pmaxj = fj.getCornerMax();
                    double xmin = Math.max(pmini.x, pminj.x);
                    double xmax = Math.min(pmaxi.x, pmaxj.x);
                    double ymin = Math.max(pmini.y, pminj.y);
                    double ymax = Math.min(pmaxi.y, pmaxj.y);
                    double zmin = Math.max(pmini.z, pminj.z);
                    double zmax = Math.min(pmaxi.z, pmaxj.z);
                    if (!(xmin <= xmax) || !(ymin <= ymax) || !(zmin <= zmax)) continue;
                    Gl.glBegin(1);
                    Gl.glVertex3d(xmin, ymin, zmin);
                    Gl.glVertex3d(xmax, ymax, zmax);
                    Gl.glEnd();
                }
            }
        }
    }
}

