/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.ImagePanelGroup;
import edu.mines.jtk.sgl.TestFrame;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.util.ArrayMath;
import javax.swing.SwingUtilities;

public class ImagePanelGroupTest {
    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImagePanelGroupTest.go(args);
            }
        });
    }

    private static void go(String[] args) {
        double d1;
        int n1 = 101;
        int n2 = 121;
        int n3 = 141;
        double d2 = d1 = 1.0 / (double)(n1 - 1);
        double d3 = d1;
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        Sampling s1 = new Sampling(n1, d1, f1);
        Sampling s2 = new Sampling(n2, d2, f2);
        Sampling s3 = new Sampling(n3, d3, f3);
        float k1 = (float)Math.PI * 4 * (float)d1;
        float k2 = (float)Math.PI * 4 * (float)d2;
        float k3 = (float)Math.PI * 4 * (float)d3;
        float[][][] f = ArrayMath.sin(ArrayMath.rampfloat(0.0f, k1, k2, k3, n1, n2, n3));
        ImagePanelGroup ipg = new ImagePanelGroup(s1, s2, s3, f);
        ipg.setPercentiles(1.0, 99.0);
        World world = new World();
        world.addChild(ipg);
        TestFrame frame = new TestFrame(world);
        frame.getOrbitView().setScale(2.0);
        frame.setVisible(true);
        if (args.length > 0) {
            frame.getViewCanvas().paintToFile("f0" + args[0]);
            ipg.setSlices(0, 0, 0);
            frame.getViewCanvas().paintToFile("f1" + args[0]);
        }
    }
}

