/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.util.Direct;
import java.nio.FloatBuffer;

public class LineGroup
extends Group {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;

    public LineGroup(float[] xyz) {
        this(xyz, null);
    }

    public LineGroup(float[] xyz, float[] rgb) {
        this.addChild(new LineNode(xyz, rgb));
    }

    public LineGroup(float[][] xyz) {
        this(xyz, (float[][])null);
    }

    public LineGroup(float[][] xyz, float[][] rgb) {
        int ns = xyz.length;
        for (int is = 0; is < ns; ++is) {
            if (rgb == null) {
                this.addChild(new LineNode(xyz[is], null));
                continue;
            }
            this.addChild(new LineNode(xyz[is], rgb[is]));
        }
    }

    private class LineNode
    extends Node {
        private BoundingSphere _bs;
        private int _np;
        private FloatBuffer _vb;
        private FloatBuffer _cb;

        public LineNode(float[] xyz, float[] rgb) {
            int np;
            BoundingBox bb = new BoundingBox(xyz);
            this._bs = new BoundingSphere(bb);
            int nv = np = (this._np = xyz.length / 3);
            int nc = np;
            this._vb = Direct.newFloatBuffer(3 * nv);
            this._cb = rgb != null ? Direct.newFloatBuffer(3 * nc) : null;
            int iv = 0;
            int ic = 0;
            for (int ip = 0; ip < np; ++ip) {
                int i = 3 * ip;
                this._vb.put(iv++, xyz[i + 0]);
                this._vb.put(iv++, xyz[i + 1]);
                this._vb.put(iv++, xyz[i + 2]);
                if (this._cb == null) continue;
                this._cb.put(ic++, rgb[i + 0]);
                this._cb.put(ic++, rgb[i + 1]);
                this._cb.put(ic++, rgb[i + 2]);
            }
        }

        @Override
        protected BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }

        @Override
        protected void draw(DrawContext dc) {
            Gl.glEnableClientState(32884);
            Gl.glVertexPointer(3, 5126, 0, this._vb);
            if (this._cb != null) {
                Gl.glEnableClientState(32886);
                Gl.glColorPointer(3, 5126, 0, this._cb);
            }
            Gl.glDrawArrays(3, 0, this._np);
            if (this._cb != null) {
                Gl.glDisableClientState(32886);
            }
            Gl.glDisableClientState(32884);
        }
    }
}

