/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.CullContext;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.sgl.StateSet;
import edu.mines.jtk.sgl.World;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Node {
    private boolean _selected;
    private BoundingSphere _boundingSphere = null;
    private boolean _boundingSphereFinite = false;
    private ArrayList<Group> _parentList = new ArrayList(2);
    private StateSet _states;

    public final boolean isSelected() {
        return this._selected;
    }

    public final void setSelected(boolean selected) {
        if (this instanceof Selectable && this._selected != selected) {
            this._selected = selected;
            this.selectedChanged();
            World world = this.getWorld();
            if (world != null) {
                world.updateSelectedSet(this);
            }
        }
    }

    public int countParents() {
        return this._parentList.size();
    }

    public Iterator<Group> getParents() {
        return this._parentList.iterator();
    }

    public World getWorld() {
        for (Group parent : this._parentList) {
            World world = parent.getWorld();
            if (world == null) continue;
            return world;
        }
        return null;
    }

    public void dirtyDraw() {
        for (Group parent : this._parentList) {
            parent.dirtyDraw();
        }
    }

    public BoundingSphere getBoundingSphere(boolean finite) {
        if (this._boundingSphere == null || this._boundingSphereFinite != finite) {
            this._boundingSphere = this.computeBoundingSphere(finite);
            this._boundingSphereFinite = finite;
        }
        return this._boundingSphere;
    }

    public void dirtyBoundingSphere() {
        if (this._boundingSphere != null) {
            this._boundingSphere = null;
            for (Group parent : this._parentList) {
                parent.dirtyBoundingSphere();
            }
        }
    }

    public StateSet getStates() {
        return this._states;
    }

    public void setStates(StateSet states) {
        this._states = states;
    }

    public void pick(PickContext pc) {
    }

    protected void selectedChanged() {
    }

    protected BoundingSphere computeBoundingSphere(boolean finite) {
        return finite ? BoundingSphere.empty() : BoundingSphere.infinite();
    }

    protected int getAttributeBits() {
        return 1048575;
    }

    protected void cullApply(CullContext cc) {
        if (cc.frustumIntersectsSphereOf(this)) {
            this.cullBegin(cc);
            this.cull(cc);
            this.cullEnd(cc);
        }
    }

    protected void cullBegin(CullContext cc) {
        cc.pushNode(this);
    }

    protected void cull(CullContext cc) {
        cc.appendNodes();
    }

    protected void cullEnd(CullContext cc) {
        cc.popNode();
    }

    protected void drawApply(DrawContext dc) {
        this.drawBegin(dc);
        this.draw(dc);
        this.drawEnd(dc);
    }

    protected void drawBegin(DrawContext dc) {
        dc.pushNode(this);
        int bits = this.getAttributeBits();
        if (bits != 1048575 && this._states != null) {
            bits |= this._states.getAttributeBits();
        }
        Gl.glPushAttrib(bits);
        if (this._states != null) {
            this._states.apply();
        }
    }

    protected void draw(DrawContext dc) {
    }

    protected void drawEnd(DrawContext dc) {
        Gl.glPopAttrib();
        dc.popNode();
    }

    protected void pickApply(PickContext pc) {
        if (pc.segmentIntersectsSphereOf(this)) {
            this.pickBegin(pc);
            this.pick(pc);
            this.pickEnd(pc);
        }
    }

    protected void pickBegin(PickContext pc) {
        pc.pushNode(this);
    }

    protected void pickEnd(PickContext pc) {
        pc.popNode();
    }

    boolean addParent(Group parent) {
        if (!this._parentList.contains(parent)) {
            this._parentList.add(parent);
            return true;
        }
        return false;
    }

    boolean removeParent(Group parent) {
        return this._parentList.remove(parent);
    }
}

