/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.io.Serializable;
import java.util.Comparator;

public class Almost
implements Serializable,
Comparator<Number> {
    static final long serialVersionUID = 1L;
    private double _epsilon = 1.1920928955078125E-6;
    private double _minValue = 1.4E-43f;
    public static final Almost FLOAT = new Almost();
    public static final Almost DOUBLE = new Almost(true);

    public Almost() {
    }

    public Almost(double epsilon, double minValue) {
        this._epsilon = Math.abs(epsilon);
        this._minValue = Math.abs(minValue);
    }

    public Almost(double epsilon) {
        if (epsilon > 0.1) {
            throw new IllegalArgumentException("Epsilon should be a small number: " + epsilon);
        }
        this._epsilon = Math.abs(epsilon);
    }

    public Almost(int significantDigits) {
        if (significantDigits < 1) {
            throw new IllegalArgumentException("The number of significant digits should be positive.");
        }
        this._epsilon = 1.0;
        for (significantDigits = Math.abs(significantDigits); significantDigits > 0; --significantDigits) {
            this._epsilon *= 0.1;
        }
    }

    public Almost(boolean isDouble) {
        if (isDouble) {
            this._epsilon = 2.220446049250313E-15;
            this._minValue = 4.94E-322;
        }
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    public double getMinValue() {
        return this._minValue;
    }

    public boolean between(double x, double x1, double x2) {
        return this.cmp(x, x1) * this.cmp(x, x2) <= 0;
    }

    public int outside(double x, double x1, double x2) {
        int i = 0;
        if (this.between(x, x1, x2)) {
            i = 0;
        } else if (this.between(x1, x, x2)) {
            i = -1;
        } else if (this.between(x2, x, x1)) {
            i = 1;
        }
        return i;
    }

    public boolean zero(double r) {
        if (r < 0.0) {
            r = -r;
        }
        return r < this._minValue;
    }

    public boolean equal(double r1, double r2) {
        return this.cmp(r1, r2) == 0;
    }

    public boolean lt(double r1, double r2) {
        return this.cmp(r1, r2) < 0;
    }

    public boolean le(double r1, double r2) {
        return this.cmp(r1, r2) <= 0;
    }

    public boolean gt(double r1, double r2) {
        return this.cmp(r1, r2) > 0;
    }

    public boolean ge(double r1, double r2) {
        return this.cmp(r1, r2) >= 0;
    }

    public int cmp(double r1, double r2) {
        double er2;
        if (r1 == r2) {
            return 0;
        }
        double ar1 = r1;
        double ar2 = r2;
        if (ar1 < 0.0) {
            ar1 = -ar1;
        }
        if (ar2 < 0.0) {
            ar2 = -ar2;
        }
        if (ar1 < this._minValue && ar2 < this._minValue) {
            return 0;
        }
        if (0.0 * r1 * r2 != 0.0) {
            throw new IllegalArgumentException("Comparing a NaN");
        }
        double er1 = this._epsilon * ar1;
        if (this._minValue > er1) {
            er1 = this._minValue;
        }
        if (this._minValue > (er2 = this._epsilon * ar2)) {
            er2 = this._minValue;
        }
        if (r1 - er1 > r2 + er2) {
            return 1;
        }
        if (r1 + er1 < r2 - er2) {
            return -1;
        }
        return 0;
    }

    public int hashCodeOf(Number number, int significantDigits) {
        boolean flipSign;
        if (number instanceof Long || number instanceof Integer) {
            return number.intValue();
        }
        double value = number.doubleValue();
        if (this.zero(value)) {
            return 0;
        }
        boolean bl = flipSign = value < 0.0;
        if (flipSign) {
            value = -value;
        }
        int pow = 0;
        while (value < 0.1) {
            value *= 10.0;
            ++pow;
        }
        while (value > 1.0) {
            value *= 0.1;
            --pow;
        }
        if (this.equal(value, 1.0) || this.equal(value, 0.1)) {
            return 1;
        }
        for (int i = 0; i < Math.abs(significantDigits); ++i) {
            value *= 10.0;
        }
        int result = Long.valueOf((long)(value + 0.5)).intValue();
        result = 100 * result + pow;
        if (flipSign) {
            result = -result;
        }
        return result;
    }

    public int hashCodeOf(Number number) {
        double epsilon = this._epsilon;
        int digits = 0;
        while (epsilon < 0.99) {
            epsilon *= 10.0;
            ++digits;
        }
        return this.hashCodeOf(number, digits);
    }

    public double divide(double top, double bottom, boolean limitIsOne) {
        return this.divide(top, bottom, limitIsOne ? 1.0 : 0.0);
    }

    public double reciprocal(double value) {
        return this.divide(1.0, value, 0.0);
    }

    public double divide(double top, double bottom, double limit) {
        double sign = 1.0;
        if (top > 0.0 && bottom < 0.0 || top < 0.0 && bottom > 0.0) {
            sign = -1.0;
        }
        if (top < 0.0) {
            top = -top;
        }
        if (bottom < 0.0) {
            bottom = -bottom;
        }
        if (bottom >= 1.0 || top < bottom * 0.1 * 3.4028234663852886E38) {
            return sign * top / bottom;
        }
        if (this.equal(top, bottom)) {
            if (this.zero(top)) {
                return limit;
            }
            return sign;
        }
        return sign * 0.01 * 3.4028234663852886E38;
    }

    @Override
    public int compare(Number n1, Number n2) {
        return this.cmp(n1.doubleValue(), n2.doubleValue());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass() || this.hashCode() != object.hashCode()) {
            return false;
        }
        Almost other = (Almost)object;
        return this._epsilon == other._epsilon && this._minValue == other._minValue;
    }

    public int hashCode() {
        return Long.valueOf(Double.doubleToLongBits(this._epsilon) ^ Double.doubleToLongBits(this._minValue)).intValue();
    }

    public String toString() {
        return "Almost<eps=" + this._epsilon + ",min=" + this._minValue + ">";
    }
}

