/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.util.Random;

public class UnitSphereSampling {
    private static final double ALMOST_ONE = 1.0 - 5.0 * ArrayMath.ulp(1.0);
    private int _m;
    private int _n;
    private int _mindex;
    private int _nindex;
    private int _npoint;
    private double _d;
    private double _od;
    private float[][] _pu;
    private float[][] _pl;
    private int[][] _ip;
    private static UnitSphereSampling _uss16;
    private static final boolean TRACE = true;
    private static Random _random;

    public UnitSphereSampling() {
        this(16);
    }

    public UnitSphereSampling(int nbits) {
        this.initialize(nbits);
    }

    public int countSamples() {
        return this._npoint;
    }

    public int getMaxIndex() {
        return this._mindex;
    }

    public float[] getPoint(int index) {
        Check.argument(index != 0, "index!=0");
        return index >= 0 ? this._pu[index] : this._pl[index + this._nindex];
    }

    public int getIndex(float x, float y, float z) {
        double ax = x >= 0.0f ? (double)x : (double)(-x);
        double ay = y >= 0.0f ? (double)y : (double)(-y);
        double az = z >= 0.0f ? (double)z : (double)(-z);
        double scale = ALMOST_ONE / (ax + ay + az);
        double r = (double)x * scale;
        double s = (double)y * scale;
        int ir = (int)(0.5 + (r + 1.0) * this._od);
        int is = (int)(0.5 + (s + 1.0) * this._od);
        int index = this._ip[is][ir];
        assert (index > 0) : "index>0";
        return z >= 0.0f ? index : index - this._nindex;
    }

    public int getIndex(float[] xyz) {
        return this.getIndex(xyz[0], xyz[1], xyz[2]);
    }

    public int[] getTriangle(float x, float y, float z) {
        int[] nArray;
        int ic;
        int ib;
        int ia;
        double s;
        double sn;
        int is;
        int js;
        double az;
        double ay;
        double ax = x >= 0.0f ? (double)x : (double)(-x);
        double scale = ALMOST_ONE / (ax + (ay = y >= 0.0f ? (double)y : (double)(-y)) + (az = z >= 0.0f ? (double)z : (double)(-z)));
        double r = (double)x * scale;
        double rn = (r + 1.0) * this._od;
        int ir = (int)rn;
        int jr = ir - this._m;
        if (jr + (js = (is = (int)(sn = ((s = (double)y * scale) + 1.0) * this._od)) - this._m) == this._m) {
            if (jr > 0) {
                --jr;
                --ir;
            } else {
                --js;
                --is;
            }
        }
        double fr = rn - (double)ir;
        double fs = sn - (double)is;
        if (jr >= 0 && js >= 0) {
            if (jr + js + 2 > this._m || fr + fs <= 1.0) {
                ia = this._ip[is][ir];
                ib = this._ip[is][ir + 1];
                ic = this._ip[is + 1][ir];
            } else {
                ia = this._ip[is + 1][ir + 1];
                ib = this._ip[is + 1][ir];
                ic = this._ip[is][ir + 1];
            }
        } else if (jr < 0 && js >= 0) {
            if (-jr + js + 1 > this._m || fr >= fs) {
                ia = this._ip[is][ir + 1];
                ib = this._ip[is + 1][ir + 1];
                ic = this._ip[is][ir];
            } else {
                ia = this._ip[is + 1][ir];
                ib = this._ip[is][ir];
                ic = this._ip[is + 1][ir + 1];
            }
        } else if (jr < 0 && js < 0) {
            if (-jr - js > this._m || fr + fs >= 1.0) {
                ia = this._ip[is + 1][ir + 1];
                ib = this._ip[is + 1][ir];
                ic = this._ip[is][ir + 1];
            } else {
                ia = this._ip[is][ir];
                ib = this._ip[is][ir + 1];
                ic = this._ip[is + 1][ir];
            }
        } else if (jr + 1 - js > this._m || fr <= fs) {
            ia = this._ip[is + 1][ir];
            ib = this._ip[is][ir];
            ic = this._ip[is + 1][ir + 1];
        } else {
            ia = this._ip[is][ir + 1];
            ib = this._ip[is + 1][ir + 1];
            ic = this._ip[is][ir];
        }
        if (ia == 0 || ib == 0 || ic == 0) {
            UnitSphereSampling.trace("ia=" + ia + " ib=" + ib + " ic=" + ic);
            UnitSphereSampling.trace("x=" + x + " y=" + y + " z=" + z);
            UnitSphereSampling.trace("r=" + r + " s=" + s);
            UnitSphereSampling.trace("ir=" + ir + " is=" + is);
            UnitSphereSampling.trace("jr=" + jr + " js=" + js);
            UnitSphereSampling.trace("fr=" + fr + " fs=" + fs);
            UnitSphereSampling.trace("rn=" + rn + " sn=" + sn);
            assert (false) : "valid ia,ib,ic";
        }
        if (z >= 0.0f) {
            int[] nArray2 = new int[3];
            nArray2[0] = ia;
            nArray2[1] = ib;
            nArray = nArray2;
            nArray2[2] = ic;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = ia - this._nindex;
            nArray3[1] = ic - this._nindex;
            nArray = nArray3;
            nArray3[2] = ib - this._nindex;
        }
        return nArray;
    }

    public int[] getTriangle(float[] xyz) {
        return this.getTriangle(xyz[0], xyz[1], xyz[2]);
    }

    public float[] getWeights(float x, float y, float z, int[] iabc) {
        float[] pa = this.getPoint(iabc[0]);
        float[] pb = this.getPoint(iabc[1]);
        float[] pc = this.getPoint(iabc[2]);
        double xa = pa[0];
        double ya = pa[1];
        double za = pa[2];
        double xb = pb[0];
        double yb = pb[1];
        double zb = pb[2];
        double xc = pc[0];
        double yc = pc[1];
        double zc = pc[2];
        double wa = (double)x * (yb * zc - yc * zb) + (double)y * (zb * xc - zc * xb) + (double)z * (xb * yc - xc * yb);
        double wb = (double)x * (yc * za - ya * zc) + (double)y * (zc * xa - za * xc) + (double)z * (xc * ya - xa * yc);
        double wc = (double)x * (ya * zb - yb * za) + (double)y * (za * xb - zb * xa) + (double)z * (xa * yb - xb * ya);
        if (wa < 0.0) {
            wa = 0.0;
        }
        if (wb < 0.0) {
            wb = 0.0;
        }
        if (wc < 0.0) {
            wc = 0.0;
        }
        double ws = 1.0 / (wa + wb + wc);
        float fa = (float)(wa * ws);
        float fb = (float)(wb * ws);
        float fc = (float)(wc * ws);
        return new float[]{fa, fb, fc};
    }

    public float[] getWeights(float[] xyz, int[] iabc) {
        return this.getWeights(xyz[0], xyz[1], xyz[2], iabc);
    }

    public static short[] encode16(float[] x, float[] y, float[] z) {
        UnitSphereSampling uss = UnitSphereSampling.getUnitSphereSampling16();
        int n = x.length;
        short[] s = new short[n];
        for (int j = 0; j < n; ++j) {
            s[j] = (short)uss.getIndex(x[j], y[j], z[j]);
        }
        return s;
    }

    public static short[][] encode16(float[][] x, float[][] y, float[][] z) {
        int n = x.length;
        short[][] s = new short[n][];
        for (int j = 0; j < n; ++j) {
            s[j] = UnitSphereSampling.encode16(x[j], y[j], z[j]);
        }
        return s;
    }

    public static short[][][] encode16(float[][][] x, float[][][] y, float[][][] z) {
        int n = x.length;
        short[][][] s = new short[n][][];
        for (int j = 0; j < n; ++j) {
            s[j] = UnitSphereSampling.encode16(x[j], y[j], z[j]);
        }
        return s;
    }

    private static UnitSphereSampling getUnitSphereSampling16() {
        if (_uss16 == null) {
            _uss16 = new UnitSphereSampling(16);
        }
        return _uss16;
    }

    private void initialize(int nbits) {
        Check.argument(nbits >= 4, "nbits>=4");
        Check.argument(nbits <= 32, "nbits<=32");
        int indexLimit = (1 << nbits - 1) - 1;
        int m = 1;
        while (1 + 2 * m * (1 + m) <= indexLimit) {
            ++m;
        }
        this._m = --m;
        this._n = 2 * this._m + 1;
        this._d = 1.0 / (double)this._m;
        this._od = this._m;
        this._mindex = 1 + 2 * this._m * (1 + this._m);
        this._nindex = this._mindex + 1;
        this._npoint = 2 * this._mindex - 4 * this._m;
        this._pu = new float[this._nindex][];
        this._pl = new float[this._nindex][];
        this._ip = new int[this._n][this._n];
        int is = 0;
        int js = -this._m;
        int index = 0;
        while (is < this._n) {
            double s = (double)js * this._d;
            double as = s >= 0.0 ? s : -s;
            int ir = 0;
            int jr = -this._m;
            while (ir < this._n) {
                int jrs = ArrayMath.abs(jr) + ArrayMath.abs(js);
                if (jrs <= this._m) {
                    this._ip[is][ir] = ++index;
                    double r = (double)jr * this._d;
                    double ar = r >= 0.0 ? r : -r;
                    double t = ArrayMath.max(0.0, 1.0 - ar - as);
                    if (jrs == this._m) {
                        t = 0.0;
                    }
                    double scale = 1.0 / ArrayMath.sqrt(s * s + r * r + t * t);
                    float x = (float)(r * scale);
                    float y = (float)(s * scale);
                    float z = (float)(t * scale);
                    this._pu[index] = new float[3];
                    float[] pu = this._pu[index];
                    float[] fArray = new float[3];
                    this._pl[this._nindex - index] = fArray;
                    float[] pl = fArray;
                    pu[0] = x;
                    pu[1] = y;
                    pu[2] = z;
                    pl[0] = -x;
                    pl[1] = -y;
                    pl[2] = -z;
                }
                ++ir;
                ++jr;
            }
            ++is;
            ++js;
        }
    }

    private static float distanceOnSphere(float[] p, float[] q) {
        double x = p[0] + q[0];
        double y = p[1] + q[1];
        double z = p[2] + q[2];
        double d = x * x + y * y + z * z;
        d = d == 0.0 ? Math.PI : (d == 4.0 ? 0.0 : 2.0 * ArrayMath.atan(ArrayMath.sqrt((4.0 - d) / d)));
        return (float)d;
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        UnitSphereSampling uss = new UnitSphereSampling(8);
        UnitSphereSampling.testSymmetry(uss);
        UnitSphereSampling.testInterpolation(uss);
        UnitSphereSampling.testWeights(uss);
        UnitSphereSampling.testTriangle(uss);
        UnitSphereSampling.testMaxError(uss);
    }

    private static void testSymmetry(UnitSphereSampling uss) {
        float[] q;
        float[] p;
        int mi = uss.getMaxIndex();
        int i = 1;
        int j = -i;
        while (i <= mi) {
            p = uss.getPoint(i);
            q = uss.getPoint(j);
            assert (p[0] == -q[0]);
            assert (p[1] == -q[1]);
            assert (p[2] == -q[2]);
            j = -(++i);
        }
        int npoint = 10000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            p = UnitSphereSampling.randomPoint();
            q = new float[]{-p[0], -p[1], -p[2]};
            int i2 = uss.getIndex(p);
            int j2 = uss.getIndex(q);
            if (p[2] == 0.0f ? !$assertionsDisabled && i2 + j2 != mi + 1 : !$assertionsDisabled && -i2 != j2) {
                throw new AssertionError();
            }
        }
    }

    private static void testInterpolation(UnitSphereSampling uss) {
        int mi = uss.getMaxIndex();
        int nf = 1 + 2 * mi;
        float[] fi = new float[nf];
        for (int i = 1; i <= mi; ++i) {
            float[] p = uss.getPoint(i);
            float[] q = uss.getPoint(-i);
            fi[i] = UnitSphereSampling.func(p[0], p[1], p[2]);
            fi[nf - i] = UnitSphereSampling.func(q[0], q[1], q[2]);
        }
        float emax = 0.0f;
        float[] pmax = null;
        int npoint = 10000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float f;
            float fc;
            float fb;
            float fa;
            float g;
            float e;
            float[] p = UnitSphereSampling.randomPoint();
            int[] iabc = uss.getTriangle(p);
            float[] wabc = uss.getWeights(p, iabc);
            int ia = iabc[0];
            int ib = iabc[1];
            int ic = iabc[2];
            float wa = wabc[0];
            float wb = wabc[1];
            float wc = wabc[2];
            if (ia < 0) {
                ia = nf + ia;
                ib = nf + ib;
                ic = nf + ic;
            }
            if (!((e = ArrayMath.abs((g = wa * (fa = fi[ia]) + wb * (fb = fi[ib]) + wc * (fc = fi[ic])) - (f = UnitSphereSampling.func(p[0], p[1], p[2])))) > emax)) continue;
            emax = e;
            pmax = p;
        }
        UnitSphereSampling.trace("emax=" + emax);
        ArrayMath.dump(pmax);
    }

    private static float func(float x, float y, float z) {
        return 0.1f * (9.0f * x * x * x - 2.0f * x * x * y + 3.0f * x * y * y - 4.0f * y * y * y + 2.0f * z * z * z - x * y * z);
    }

    private static void testTriangle(UnitSphereSampling uss) {
        int npoint = 1000000;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float[] p = UnitSphereSampling.randomPoint();
            int i = uss.getIndex(p);
            int[] abc = uss.getTriangle(p);
            int ia = abc[0];
            int ib = abc[1];
            int ic = abc[2];
            float[] q = uss.getPoint(i);
            float[] qa = uss.getPoint(ia);
            float[] qb = uss.getPoint(ib);
            float[] qc = uss.getPoint(ic);
            float d = UnitSphereSampling.distanceOnSphere(p, q);
            float da = UnitSphereSampling.distanceOnSphere(p, qa);
            float db = UnitSphereSampling.distanceOnSphere(p, qb);
            float dc = UnitSphereSampling.distanceOnSphere(p, qc);
            if (i == ia || i == ib || i == ic) continue;
            UnitSphereSampling.trace("d=" + d + " da=" + da + " db=" + db + " dc=" + dc);
            ArrayMath.dump(p);
            ArrayMath.dump(q);
            ArrayMath.dump(qa);
            ArrayMath.dump(qb);
            ArrayMath.dump(qc);
            assert (false) : "i equals ia or ib or ic";
        }
    }

    private static void testWeights(UnitSphereSampling uss) {
        int npoint = 10;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            float[] p = UnitSphereSampling.randomPoint();
            int[] iabc = uss.getTriangle(p);
            int ia = iabc[0];
            int ib = iabc[1];
            int ic = iabc[2];
            float[] qa = uss.getPoint(ia);
            float[] qb = uss.getPoint(ib);
            float[] qc = uss.getPoint(ic);
            float[] wabc = uss.getWeights(p, iabc);
            float wa = wabc[0];
            float wb = wabc[1];
            float wc = wabc[2];
            UnitSphereSampling.trace("wa=" + wa + " wb=" + wb + " wc=" + wc);
            ArrayMath.dump(p);
            ArrayMath.dump(qa);
            ArrayMath.dump(qb);
            ArrayMath.dump(qc);
        }
    }

    private static void testMaxError(UnitSphereSampling uss) {
        UnitSphereSampling.estimateMaxError(uss);
    }

    private static float estimateMaxError(UnitSphereSampling uss) {
        int npoint = 1000000;
        float dmax = 0.0f;
        float[] pmax = null;
        float[] qmax = null;
        for (int ipoint = 0; ipoint < npoint; ++ipoint) {
            int i;
            float[] q;
            float[] p = UnitSphereSampling.randomPoint();
            float d = UnitSphereSampling.distanceOnSphere(p, q = uss.getPoint(i = uss.getIndex(p)));
            if (!(d > dmax)) continue;
            dmax = d;
            pmax = p;
            qmax = q;
        }
        float dmaxDegrees = (float)((double)dmax * 180.0 / Math.PI);
        UnitSphereSampling.trace("npoint=" + npoint + " dmax=" + dmax + " degrees=" + dmaxDegrees);
        UnitSphereSampling.trace("pmax=");
        ArrayMath.dump(pmax);
        UnitSphereSampling.trace("qmax=");
        ArrayMath.dump(qmax);
        return dmax;
    }

    private static float[] randomPoint() {
        float x = -1.0f + 2.0f * _random.nextFloat();
        float y = -1.0f + 2.0f * _random.nextFloat();
        float z = -1.0f + 2.0f * _random.nextFloat();
        float f = _random.nextFloat();
        if (f < 0.1f) {
            x = 0.0f;
        }
        if (0.1f <= f && f < 0.2f) {
            y = 0.0f;
        }
        if (0.2f <= f && f < 0.3f) {
            z = 0.0f;
        }
        float s = 1.0f / ArrayMath.sqrt(x * x + y * y + z * z);
        return new float[]{x * s, y * s, z * s};
    }

    static {
        _random = new Random();
    }
}

