/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.swing.view.mxCellStatePreview;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;

public class mxMovePreview
extends mxEventSource {
    protected mxGraphComponent graphComponent;
    protected int threshold = 200;
    protected boolean placeholderPreview = false;
    protected boolean clonePreview = true;
    protected boolean contextPreview = true;
    protected boolean hideSelectionHandler = false;
    protected transient mxCellState startState;
    protected transient mxCellState[] previewStates;
    protected transient Object[] movingCells;
    protected transient Rectangle initialPlaceholder;
    protected transient Rectangle placeholder;
    protected transient mxRectangle lastDirty;
    protected transient mxCellStatePreview preview;

    public mxMovePreview(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxMovePreview.this.paint(g);
            }
        });
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int value) {
        this.threshold = value;
    }

    public boolean isPlaceholderPreview() {
        return this.placeholderPreview;
    }

    public void setPlaceholderPreview(boolean value) {
        this.placeholderPreview = value;
    }

    public boolean isClonePreview() {
        return this.clonePreview;
    }

    public void setClonePreview(boolean value) {
        this.clonePreview = value;
    }

    public boolean isContextPreview() {
        return this.contextPreview;
    }

    public void setContextPreview(boolean value) {
        this.contextPreview = value;
    }

    public boolean isHideSelectionHandler() {
        return this.hideSelectionHandler;
    }

    public void setHideSelectionHandler(boolean value) {
        this.hideSelectionHandler = value;
    }

    public boolean isActive() {
        return this.startState != null;
    }

    public Object[] getMovingCells() {
        return this.movingCells;
    }

    public Object[] getCells(mxCellState initialState) {
        mxGraph graph = this.graphComponent.getGraph();
        return graph.getMovableCells(graph.getSelectionCells());
    }

    protected mxCellState[] getPreviewStates() {
        mxGraph graph = this.graphComponent.getGraph();
        LinkedList<mxCellState> result = new LinkedList<mxCellState>();
        for (Object cell : this.movingCells) {
            Object[] edges;
            mxCellState cellState = graph.getView().getState(cell);
            if (cellState == null) continue;
            result.add(cellState);
            if (result.size() >= this.threshold) {
                return null;
            }
            if (!this.isContextPreview()) continue;
            for (Object edge : edges = graph.getAllEdges(new Object[]{cell})) {
                mxCellState edgeState;
                if (graph.isCellSelected(edge) || (edgeState = graph.getView().getState(edge)) == null) continue;
                if (result.size() >= this.threshold) {
                    return null;
                }
                result.add(edgeState);
            }
        }
        return result.toArray(new mxCellState[result.size()]);
    }

    protected boolean isCellOpaque(Object cell) {
        return this.startState != null && this.startState.getCell() == cell;
    }

    public void start(MouseEvent e, mxCellState state) {
        this.startState = state;
        this.movingCells = this.getCells(state);
        mxCellState[] mxCellStateArray = this.previewStates = !this.placeholderPreview ? this.getPreviewStates() : null;
        if (this.previewStates == null || this.previewStates.length >= this.threshold) {
            this.placeholder = this.getPlaceholderBounds(this.startState).getRectangle();
            this.initialPlaceholder = new Rectangle(this.placeholder);
            this.graphComponent.getGraphControl().repaint(this.placeholder);
        }
        this.fireEvent(new mxEventObject(mxEvent.START, "event", e, "state", this.startState));
    }

    protected mxRectangle getPlaceholderBounds(mxCellState startState) {
        mxGraph graph = this.graphComponent.getGraph();
        return graph.getView().getBounds(graph.getSelectionCells());
    }

    public mxCellStatePreview createCellStatePreview() {
        return new mxCellStatePreview(this.graphComponent, this.isClonePreview()){

            @Override
            protected float getOpacityForCell(Object cell) {
                if (mxMovePreview.this.isCellOpaque(cell)) {
                    return 1.0f;
                }
                return super.getOpacityForCell(cell);
            }
        };
    }

    public void update(MouseEvent e, double dx, double dy, boolean clone) {
        mxGraph graph = this.graphComponent.getGraph();
        if (this.placeholder != null) {
            Rectangle tmp = new Rectangle(this.placeholder);
            this.placeholder.x = this.initialPlaceholder.x + (int)dx;
            this.placeholder.y = this.initialPlaceholder.x + (int)dy;
            tmp.add(this.placeholder);
            this.graphComponent.getGraphControl().repaint(tmp);
        } else if (this.previewStates != null) {
            this.preview = this.createCellStatePreview();
            this.preview.setOpacity(this.graphComponent.getPreviewAlpha());
            for (mxCellState previewState : this.previewStates) {
                this.preview.moveState(previewState, dx, dy, false, false);
                boolean visible = true;
                if (dx == 0.0 && dy == 0.0 || !clone || !this.isContextPreview()) continue;
                visible = false;
                Object tmp = previewState.getCell();
                while (!visible && tmp != null) {
                    visible = graph.isCellSelected(tmp);
                    tmp = graph.getModel().getParent(tmp);
                }
            }
            mxRectangle dirty = this.lastDirty;
            this.lastDirty = this.preview.show();
            if (dirty != null) {
                dirty.add(this.lastDirty);
            } else {
                dirty = this.lastDirty;
            }
            if (dirty != null) {
                this.repaint(dirty);
            }
        }
        if (this.isHideSelectionHandler()) {
            this.graphComponent.getSelectionCellsHandler().setVisible(false);
        }
        this.fireEvent(new mxEventObject(mxEvent.CONTINUE, "event", e, "dx", dx, "dy", dy));
    }

    protected void repaint(mxRectangle dirty) {
        if (dirty != null) {
            this.graphComponent.getGraphControl().repaint(dirty.getRectangle());
        } else {
            this.graphComponent.getGraphControl().repaint();
        }
    }

    protected void reset() {
        mxGraph graph = this.graphComponent.getGraph();
        if (this.placeholder != null) {
            Rectangle tmp = this.placeholder;
            this.placeholder = null;
            this.graphComponent.getGraphControl().repaint(tmp);
        }
        if (this.isHideSelectionHandler()) {
            this.graphComponent.getSelectionCellsHandler().setVisible(true);
        }
        if (!this.isClonePreview() && this.previewStates != null) {
            graph.getView().revalidate();
        }
        this.previewStates = null;
        this.movingCells = null;
        this.startState = null;
        this.preview = null;
        if (this.lastDirty != null) {
            this.graphComponent.getGraphControl().repaint(this.lastDirty.getRectangle());
            this.lastDirty = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] stop(boolean commit, MouseEvent e, double dx, double dy, boolean clone, Object target) {
        Object[] cells = this.movingCells;
        this.reset();
        mxGraph graph = this.graphComponent.getGraph();
        graph.getModel().beginUpdate();
        try {
            if (commit) {
                double s = graph.getView().getScale();
                cells = graph.moveCells(cells, dx / s, dy / s, clone, target, e.getPoint());
            }
            this.fireEvent(new mxEventObject(mxEvent.STOP, "event", e, "commit", commit));
        }
        finally {
            graph.getModel().endUpdate();
        }
        return cells;
    }

    public void paint(Graphics g) {
        if (this.placeholder != null) {
            mxSwingConstants.PREVIEW_BORDER.paintBorder(this.graphComponent, g, this.placeholder.x, this.placeholder.y, this.placeholder.width, this.placeholder.height);
        }
        if (this.preview != null) {
            this.preview.paint(g);
        }
    }
}

