/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.imglib2.roi.GeneralPathRegionOfInterest;
import org.jhotdraw.geom.BezierPath;

public class BezierPathFunctions {
    public static BezierPath toBezierPath(PathIterator iterator) {
        BezierPath path = new BezierPath();
        double[] segment = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            switch (type) {
                case 0: {
                    path.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    path.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    path.quadTo(segment[0], segment[1], segment[2], segment[3]);
                    break;
                }
                case 3: {
                    path.curveTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    path.setClosed(true);
                }
            }
            iterator.next();
        }
        return path;
    }

    public static void addToRegionOfInterest(BezierPath path, GeneralPathRegionOfInterest roi) {
        BezierPathFunctions.addToRegionOfInterest(path.toGeneralPath().getPathIterator(null), roi);
    }

    public static void addToRegionOfInterest(PathIterator iterator, GeneralPathRegionOfInterest roi) {
        double[] segment = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            switch (type) {
                case 0: {
                    roi.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    roi.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    roi.quadTo(segment[0], segment[1], segment[2], segment[3]);
                    break;
                }
                case 3: {
                    roi.cubicTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    roi.close();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            iterator.next();
        }
    }

    public static BezierPath add(BezierPath path1, BezierPath path2) {
        return BezierPathFunctions.op(path1, path2, OP.ADD);
    }

    public static BezierPath exclusiveOr(BezierPath path1, BezierPath path2) {
        return BezierPathFunctions.op(path1, path2, OP.XOR);
    }

    public static BezierPath intersect(BezierPath path1, BezierPath path2) {
        return BezierPathFunctions.op(path1, path2, OP.INTERSECT);
    }

    public static BezierPath subtract(BezierPath path1, BezierPath path2) {
        return BezierPathFunctions.op(path1, path2, OP.SUBTRACT);
    }

    public static BezierPath op(BezierPath path1, BezierPath path2, OP op) {
        Area area1 = new Area(path1.toGeneralPath());
        Area area2 = new Area(path2.toGeneralPath());
        switch (op) {
            case ADD: {
                area1.add(area2);
                break;
            }
            case XOR: {
                area1.exclusiveOr(area2);
                break;
            }
            case INTERSECT: {
                area1.intersect(area2);
                break;
            }
            case SUBTRACT: {
                area1.subtract(area2);
            }
        }
        return BezierPathFunctions.toBezierPath(area1.getPathIterator(new AffineTransform()));
    }

    private static void show(PathIterator iterator) {
        BezierPathFunctions.show(BezierPathFunctions.toBezierPath(iterator).toGeneralPath());
    }

    private static void show(final Shape shape) {
        JFrame frame = new JFrame("debug");
        JPanel panel = new JPanel(){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.draw(shape);
            }
        };
        frame.getContentPane().add(panel);
        Rectangle bounds = shape.getBounds();
        frame.setSize(bounds.x + bounds.width, bounds.y + bounds.height);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        BezierPath path1 = new BezierPath();
        path1.moveTo(0.0, 0.0);
        path1.lineTo(100.0, 0.0);
        path1.lineTo(100.0, 100.0);
        path1.lineTo(0.0, 0.0);
        GeneralPath path2 = new GeneralPath();
        path2.moveTo(0.0f, 0.0f);
        path2.lineTo(100.0f, 0.0f);
        path2.lineTo(100.0f, 100.0f);
        path2.closePath();
        BezierPath path3 = new BezierPath();
        path3.moveTo(0.0, 100.0);
        path3.lineTo(100.0, 0.0);
        path3.lineTo(100.0, 100.0);
        path3.lineTo(0.0, 100.0);
        path1 = BezierPathFunctions.subtract(path1, path3);
        BezierPathFunctions.show(path1.toGeneralPath());
    }

    public static enum OP {
        ADD,
        XOR,
        INTERSECT,
        SUBTRACT;

    }
}

