/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureListener;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.geom.BezierPath;

public class GeneralPathFigure
extends AbstractAttributedFigure {
    private List<BezierFigure> figures = new ArrayList<BezierFigure>(){

        @Override
        public boolean add(BezierFigure figure) {
            figure.restoreAttributesTo(GeneralPathFigure.this.getAttributesRestoreData());
            figure.addFigureListener(new FigureListener(){

                public void areaInvalidated(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireAreaInvalidated();
                }

                public void attributeChanged(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireAttributeChanged(e.getAttribute(), e.getOldValue(), e.getNewValue());
                }

                public void figureHandlesChanged(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireFigureHandlesChanged();
                }

                public void figureChanged(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireFigureChanged();
                }

                public void figureAdded(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireFigureAdded();
                }

                public void figureRemoved(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireFigureRemoved();
                }

                public void figureRequestRemove(FigureEvent e) {
                    GeneralPathFigure.this.invalidate();
                    GeneralPathFigure.this.fireFigureRequestRemove();
                }
            });
            return super.add(figure);
        }
    };
    private transient GeneralPath path;
    private static final long serialVersionUID = 1L;

    public GeneralPathFigure(BezierFigure ... list) {
        Color color = (Color)this.get(AttributeKeys.STROKE_COLOR);
        this.set(AttributeKeys.FILL_COLOR, new Color(color.getRed(), color.getGreen(), color.getBlue(), 127));
        for (BezierFigure figure : list) {
            this.figures.add(figure);
        }
    }

    public boolean contains(Point2D.Double point) {
        GeneralPath path = this.getGeneralPath();
        return path.contains(point);
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double result = new Rectangle2D.Double();
        for (BezierFigure figure : this.figures) {
            Rectangle2D.union(result, figure.getBounds(), result);
        }
        return result;
    }

    public Object getTransformRestoreData() {
        ArrayList<BezierFigure> result = new ArrayList<BezierFigure>();
        for (BezierFigure figure : this.figures) {
            result.add(figure.clone());
        }
        return result;
    }

    public void restoreTransformTo(Object geometry) {
        this.figures = (List)geometry;
    }

    public void transform(AffineTransform tx) {
        for (BezierFigure figure : this.figures) {
            figure.getBezierPath().transform(tx);
        }
        this.invalidate();
    }

    protected void drawFill(Graphics2D g) {
        g.setColor((Color)this.get(AttributeKeys.FILL_COLOR));
        g.fill(this.getGeneralPath());
    }

    protected void drawStroke(Graphics2D g) {
        for (BezierFigure figure : this.figures) {
            g.draw((Shape)figure.getBezierPath());
        }
    }

    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        for (BezierFigure figure : this.figures) {
            handles.addAll(figure.createHandles(detailLevel));
        }
        return handles;
    }

    public synchronized void invalidate() {
        this.path = null;
        super.invalidate();
    }

    public void setAttributeEnabled(AttributeKey key, boolean b) {
        super.setAttributeEnabled(key, b);
        for (BezierFigure figure : this.figures) {
            figure.setAttributeEnabled(key, b);
        }
    }

    public void setAttributes(Map<AttributeKey, Object> map) {
        super.setAttributes(map);
        for (BezierFigure figure : this.figures) {
            figure.setAttributes(map);
        }
    }

    public void restoreAttributesTo(Object restoreData) {
        super.restoreAttributesTo(restoreData);
        for (BezierFigure figure : this.figures) {
            figure.restoreAttributesTo(restoreData);
        }
    }

    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        for (BezierFigure figure : this.figures) {
            figure.set(key, newValue);
        }
    }

    public synchronized void setGeneralPath(GeneralPath path) {
        this.path = path;
        this.figures.clear();
        BezierPath bezierPath = null;
        PathIterator iterator = path.getPathIterator(null);
        double[] segment = new double[6];
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            switch (type) {
                case 0: {
                    if (bezierPath != null) {
                        this.add(bezierPath, false);
                    }
                    bezierPath = new BezierPath();
                    bezierPath.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    bezierPath.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    bezierPath.quadTo(segment[0], segment[1], segment[2], segment[3]);
                    break;
                }
                case 3: {
                    bezierPath.curveTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    this.add(bezierPath, true);
                    bezierPath = null;
                }
            }
            iterator.next();
        }
        if (bezierPath != null) {
            this.add(bezierPath, false);
        }
    }

    public synchronized GeneralPath getGeneralPath() {
        if (this.path == null) {
            this.path = new GeneralPath(0);
            for (BezierFigure figure : this.figures) {
                this.path.append((Shape)figure.getBezierPath(), false);
            }
        }
        return this.path;
    }

    private boolean add(BezierPath bezierPath, boolean isClosed) {
        bezierPath.setClosed(isClosed);
        BezierFigure figure = new BezierFigure(isClosed);
        figure.setBezierPath(bezierPath);
        return this.figures.add(figure);
    }
}

