/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.GeneralPathOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJBezierTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.PolylineFigure;
import net.imagej.ui.swing.tools.SwingPolylineTool;
import net.imglib2.roi.GeneralPathRegionOfInterest;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;

@Plugin(type=JHotDrawAdapter.class, priority=96.0)
public class PolylineJHotDrawAdapter
extends AbstractJHotDrawAdapter<GeneralPathOverlay, BezierFigure> {
    @Parameter(required=false)
    private LogService log;

    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingPolylineTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof GeneralPathOverlay)) {
            return false;
        }
        return figure == null || figure instanceof PolylineFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        return new GeneralPathOverlay(this.getContext());
    }

    @Override
    public Figure createDefaultFigure() {
        PolylineFigure figure = new PolylineFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateOverlay(BezierFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        assert (view.getData() instanceof GeneralPathOverlay);
        GeneralPathOverlay gpo = (GeneralPathOverlay)view.getData();
        GeneralPathRegionOfInterest gpr = (GeneralPathRegionOfInterest)gpo.getRegionOfInterest();
        gpr.reset();
        for (int i = 0; i < figure.getNodeCount(); ++i) {
            BezierPath.Node n = figure.getNode(i);
            if (i == 0) {
                gpr.moveTo(n.x[0], n.y[0]);
                continue;
            }
            gpr.lineTo(n.x[0], n.y[0]);
        }
        gpo.update();
    }

    @Override
    public void updateFigure(OverlayView view, BezierFigure figure) {
        super.updateFigure(view, figure);
        assert (view.getData() instanceof GeneralPathOverlay);
        GeneralPathOverlay gpo = (GeneralPathOverlay)view.getData();
        GeneralPathRegionOfInterest gpr = (GeneralPathRegionOfInterest)gpo.getRegionOfInterest();
        PathIterator pi = gpr.getGeneralPath().getPathIterator(null);
        int nCount = figure.getNodeCount();
        int i = 0;
        double[] pos = new double[6];
        while (!pi.isDone()) {
            pi.currentSegment(pos);
            BezierPath.Node n = new BezierPath.Node(pos[0], pos[1]);
            if (i < nCount) {
                figure.getNode(i).setTo(n);
            } else {
                figure.addNode(n);
            }
            pi.next();
            ++i;
        }
        while (i < figure.getNodeCount()) {
            figure.removeNode(i);
        }
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJBezierTool(display, this);
    }

    @Override
    public Shape toShape(BezierFigure figure) {
        return figure.getBezierPath().toGeneralPath();
    }
}

