/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.RectangleOverlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.tools.SwingRectangleTool;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RectangleFigure;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.util.RealCoords;

@Plugin(type=JHotDrawAdapter.class, priority=100.0)
public class RectangleJHotDrawAdapter
extends AbstractJHotDrawAdapter<RectangleOverlay, RectangleFigure> {
    @Parameter
    private ToolService toolService;

    protected static RectangleOverlay downcastOverlay(Overlay roi) {
        assert (roi instanceof RectangleOverlay);
        return (RectangleOverlay)roi;
    }

    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingRectangleTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof RectangleOverlay)) {
            return false;
        }
        return figure == null || figure instanceof RectangleFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        return new RectangleOverlay(this.getContext());
    }

    @Override
    public Figure createDefaultFigure() {
        RectangleFigure figure = new RectangleFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView view, RectangleFigure figure) {
        super.updateFigure(view, figure);
        RectangleOverlay overlay = RectangleJHotDrawAdapter.downcastOverlay(view.getData());
        double x0 = overlay.getOrigin(0);
        double y0 = overlay.getOrigin(1);
        double w = overlay.getExtent(0);
        double h = overlay.getExtent(1);
        Point2D.Double anch = new Point2D.Double(x0, y0);
        Point2D.Double lead = new Point2D.Double(x0 + w, y0 + h);
        figure.setBounds(anch, lead);
    }

    @Override
    public void updateOverlay(RectangleFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        RectangleOverlay overlay = RectangleJHotDrawAdapter.downcastOverlay(view.getData());
        Rectangle2D.Double bounds = figure.getBounds();
        double x = bounds.getMinX();
        double y = bounds.getMinY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        overlay.setOrigin(x, 0);
        overlay.setOrigin(y, 1);
        overlay.setExtent(w, 0);
        overlay.setExtent(h, 1);
        overlay.update();
        this.toolService.reportRectangle(x, y, w, h);
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<RectangleFigure>(display, this);
    }

    @Override
    public void report(RealCoords p1, RealCoords p2) {
        this.toolService.reportRectangle(p1, p2);
    }

    @Override
    public Shape toShape(RectangleFigure figure) {
        return figure.getBounds();
    }
}

