/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.JFrame;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.imagej.ui.swing.updater.DiffView;
import net.imagej.updater.Diff;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.util.ByteCodeAnalyzer;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.LogService;
import org.scijava.util.ProcessUtils;

public class DiffFile
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected String title;
    protected LogService log;
    protected String filename;
    protected URL remote;
    protected URL local;
    protected DiffView diffView;
    protected Cursor normalCursor;
    protected Cursor waitCursor;
    protected Diff diff;
    protected int diffOffset;
    protected Thread worker;

    public DiffFile(FilesCollection files, FileObject file, Diff.Mode mode) throws MalformedURLException {
        this.title = file.getLocalFilename(true) + " differences";
        this.log = files.log;
        this.filename = file.getLocalFilename(false);
        this.remote = new URL(files.getURL(file));
        this.local = files.prefix(this.filename).toURI().toURL();
        this.diffView = new DiffView();
        this.normalCursor = this.diffView.getCursor();
        this.waitCursor = new Cursor(3);
        this.addModeLinks();
        this.addGitLogLink(files, file);
        this.diffOffset = this.diffView.getDocument().getLength();
        this.diff = new Diff(this.diffView.getPrintStream());
        this.show(mode);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.diffView);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (DiffFile.this.worker != null) {
                    DiffFile.this.worker.interrupt();
                }
            }
        });
        this.pack();
    }

    protected void show(Diff.Mode mode) {
        this.show(() -> {
            try {
                this.setTitle(this.title + " (" + mode + ")");
                this.diff.showDiff(this.filename, this.remote, this.local, mode);
            }
            catch (MalformedURLException e) {
                this.log.error((Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        });
    }

    protected synchronized void show(final Runnable runnable) {
        if (this.worker != null) {
            this.worker.interrupt();
        } else {
            this.diffView.setCursor(this.waitCursor);
        }
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DiffFile.this.clearDiff();
                    runnable.run();
                }
                catch (RuntimeException e) {
                    if (!(e.getCause() instanceof InterruptedException)) {
                        DiffFile.this.log.error((Throwable)e);
                    }
                    DiffFile.this.worker.interrupt();
                }
                catch (Error e) {
                    DiffFile.this.log.error((Throwable)e);
                    DiffFile.this.worker.interrupt();
                }
                DiffFile.this.diffView.setCursor(DiffFile.this.normalCursor);
                DiffFile diffFile = DiffFile.this;
                synchronized (diffFile) {
                    DiffFile.this.worker = null;
                }
            }
        };
        this.worker.start();
    }

    protected void clearDiff() {
        Document doc = this.diffView.getDocument();
        try {
            doc.remove(this.diffOffset, doc.getLength() - this.diffOffset);
        }
        catch (BadLocationException e) {
            this.log.error((Throwable)e);
        }
    }

    private void addModeLinks() {
        for (final Diff.Mode mode : Diff.Mode.values()) {
            if (this.diffView.getDocument().getLength() > 0) {
                this.diffView.normal(" ");
            }
            this.diffView.link(mode.toString(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiffFile.this.show(mode);
                }
            });
        }
    }

    private void addGitLogLink(FilesCollection files, FileObject fileObject) {
        String warning;
        String since;
        String commitRange;
        File gitWorkingDirectory;
        String relativePath;
        String commitRemote;
        String commitLocal = this.getCommit(this.local);
        if (commitLocal == null || "".equals(commitLocal)) {
            commitLocal = "HEAD";
        }
        if (commitLocal.equals(commitRemote = this.getCommit(this.remote))) {
            this.diffView.warn("The remote and local versions were built from the same commit!");
            return;
        }
        File directory = files.prefix(".");
        while (!new File(directory, ".git").exists()) {
            if ((directory = directory.getParentFile()) != null) continue;
            return;
        }
        String baseName = fileObject.filename.substring(fileObject.filename.lastIndexOf(47) + 1);
        for (String pair : new String[]{"ij-[1-9].* ImageJA", "ij-[a-z].* imagej2", "imglib.* imglib", "TrakEM2.* TrakEM2", "mpicbg.* mpicbg"}) {
            File submodule;
            int space = pair.indexOf(32);
            String pattern = pair.substring(0, space);
            if (!baseName.matches(pattern) || !new File(submodule = new File(directory, "modules/" + pair.substring(space + 1)), ".git").isDirectory()) continue;
            directory = submodule;
            break;
        }
        if ((relativePath = this.findSourceDirectory(gitWorkingDirectory = directory, this.local)) == null) {
            return;
        }
        if (commitRemote != null && !"".equals(commitRemote)) {
            commitRange = commitRemote + ".." + commitLocal;
            since = "-p";
            warning = null;
        } else {
            commitRange = commitLocal;
            long millis = UpdaterUtil.timestamp2millis((long)fileObject.current.timestamp);
            since = "--since=" + (millis / 1000L - 300L);
            warning = "No precise commit information in the remote .jar;\n\tUsing timestamp from Updater instead: " + new Date(millis) + " - 5 minutes";
        }
        if (this.diffView.getDocument().getLength() > 0) {
            this.diffView.normal(" ");
        }
        this.diffView.link("Git Log", e -> this.show(() -> {
            this.setTitle(this.title + " (Git Log)");
            PrintStream out = this.diffView.getPrintStream();
            out.println("\n");
            if (warning != null) {
                this.diffView.warn(warning + "\n\n");
            }
            String git = System.getProperty("imagej.updater.git.command", "git");
            ProcessUtils.exec((File)gitWorkingDirectory, (PrintStream)out, (PrintStream)out, (String[])new String[]{git, "log", "-M", "-p", since, commitRange, "--", relativePath});
        }));
    }

    private String getCommit(URL jarURL) {
        try {
            JarInputStream in = new JarInputStream(UpdaterUtil.openStream((URL)jarURL));
            in.close();
            Manifest manifest = in.getManifest();
            if (manifest == null) {
                JarEntry entry;
                do {
                    if ((entry = in.getNextJarEntry()) != null) continue;
                    return null;
                } while (!entry.getName().equals("META-INF/MANIFEST.MF"));
                manifest = new Manifest(in);
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(new Attributes.Name("Implementation-Build"));
        }
        catch (IOException e) {
            return null;
        }
    }

    private String findSourceDirectory(File gitWorkingDirectory, URL jarURL) {
        try {
            JarEntry entry;
            int maxCount = 3;
            JarInputStream in = new JarInputStream(UpdaterUtil.openStream((URL)jarURL));
            while ((entry = in.getNextJarEntry()) != null) {
                String suffix;
                String path;
                block8: {
                    path = entry.getName();
                    if (!path.endsWith(".class")) continue;
                    if (--maxCount <= 0) break;
                    ByteCodeAnalyzer analyzer = Diff.analyzeByteCode((InputStream)in, (boolean)false);
                    String sourceFile = analyzer.getSourceFile();
                    if (sourceFile == null) continue;
                    suffix = path.substring(0, path.lastIndexOf(47) + 1) + sourceFile;
                    String git = System.getProperty("imagej.updater.git.command", "git");
                    try {
                        path = ProcessUtils.exec((File)gitWorkingDirectory, null, null, (String[])new String[]{git, "ls-files", "*/" + suffix});
                        if (path.length() <= suffix.length()) continue;
                        if (!path.endsWith("\n")) break block8;
                        path = path.substring(0, path.length() - 1);
                    }
                    catch (RuntimeException e) {
                        continue;
                    }
                }
                if (path.indexOf(10) >= 0) continue;
                if ("".equals(path = path.substring(0, path.length() - suffix.length()))) {
                    path = ".";
                } else if (path.endsWith("/src/main/java/")) {
                    path = path.substring(0, path.length() - "/src/main/java/".length());
                }
                in.close();
                return path;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

