/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;

public class GnuStringVector
extends StringVector {
    private BytePtr[] values;

    public GnuStringVector(String string) {
        this(new BytePtr[]{BytePtr.nullTerminatedString((String)string, (Charset)Charsets.UTF_8)});
    }

    public GnuStringVector(BytePtr[] values) {
        this(values, AttributeMap.EMPTY);
    }

    public GnuStringVector(BytePtr[] values, AttributeMap attributes) {
        super(attributes);
        this.values = values;
    }

    public int length() {
        return this.values.length;
    }

    protected StringVector cloneWithNewAttributes(AttributeMap attributes) {
        return new GnuStringVector(this.values, attributes);
    }

    public String getElementAsString(int index) {
        BytePtr value = this.values[index];
        if (value == null) {
            return null;
        }
        return value.nullTerminatedString();
    }

    public boolean isElementNA(int index) {
        return this.values[index] == null;
    }

    public boolean isConstantAccessTime() {
        return true;
    }

    public void set(int index, GnuCharSexp charValue) {
        this.values[index] = charValue.getValue();
    }
}

