/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import org.ojalgo.type.context.TypeContext;

public final class TemporalContext<T extends Temporal>
implements TypeContext<T> {
    private final TemporalAdjuster myAdjuster;
    private final DateTimeFormatter myFormatter;

    public static <T extends Temporal> TemporalContext<T> of(DateTimeFormatter formatter) {
        return new TemporalContext<T>(formatter);
    }

    public static <T extends Temporal> TemporalContext<T> of(DateTimeFormatter formatter, TemporalAdjuster adjuster) {
        return new TemporalContext<T>(formatter, adjuster);
    }

    TemporalContext(DateTimeFormatter formatter) {
        this.myFormatter = formatter;
        this.myAdjuster = null;
    }

    TemporalContext(DateTimeFormatter formatter, TemporalAdjuster adjuster) {
        this.myFormatter = formatter;
        this.myAdjuster = adjuster;
    }

    @Override
    public T enforce(T object) {
        if (this.myAdjuster != null) {
            return (T)this.myAdjuster.adjustInto((Temporal)object);
        }
        return object;
    }

    @Override
    public String format(Object object) {
        return this.myFormatter.format((Temporal)object);
    }

    public TemporalContext<T> newAdjuster(TemporalAdjuster adjuster) {
        return new TemporalContext<T>(this.myFormatter, adjuster);
    }

    public TemporalContext<T> newFormatter(DateTimeFormatter formatter) {
        return new TemporalContext<T>(formatter, this.myAdjuster);
    }

    @Override
    public T parse(CharSequence text) {
        return (T)((Temporal)this.myFormatter.parse(text));
    }
}

