/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import net.haesleinhuepf.clij.CLIJ;
import net.haesleinhuepf.clij.clearcl.exceptions.OpenCLException;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij2.CLIJ2;
import sc.fiji.labkit.pixel_classification.gpu.api.ClearCLBufferPool;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuScope;

public class DefaultGpuApi
implements GpuApi {
    private final int deviceId;
    private final CLIJ2 clij;
    private final ClearCLBufferPool pool;
    private static final Set<ClearCLBufferPool> POOLS = new CopyOnWriteArraySet<ClearCLBufferPool>();

    DefaultGpuApi(int deviceId) {
        this.deviceId = deviceId;
        this.clij = DefaultGpuApi.createCLIJ2(deviceId);
        this.pool = new ClearCLBufferPool(this.clij.getCLIJ().getClearCLContext());
        POOLS.add(this.pool);
    }

    public int getOpenClDeviceId() {
        return this.deviceId;
    }

    public static synchronized CLIJ2 createCLIJ2(int deviceId) {
        return new CLIJ2(new CLIJ(deviceId));
    }

    public static boolean isDeviceAvailable() {
        try {
            return CLIJ.getAvailableDeviceNames().isEmpty();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public GpuImage create(long[] dimensions, long numberOfChannels, NativeTypeEnum type) {
        return this.handleOutOfMemoryException(() -> new GpuImage(this.pool.create(dimensions, numberOfChannels, type), this.pool::release));
    }

    @Override
    public GpuApi subScope() {
        return new GpuScope(this, null);
    }

    @Override
    public void close() {
        POOLS.remove(this.pool);
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clij.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void execute(Class<?> anchorClass, String kernelFile, String kernelName, long[] globalSizes, long[] localSizes, HashMap<String, Object> parameters, HashMap<String, Object> defines) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (!(value instanceof GpuImage)) continue;
            parameters.put(key, ((GpuImage)value).clearCLBuffer());
        }
        this.handleOutOfMemoryException(() -> {
            this.clij.executeSubsequently(anchorClass, kernelFile, kernelName, null, globalSizes, localSizes, (Map)parameters, (Map)defines, null).close();
            return null;
        });
    }

    @Override
    public <T> T handleOutOfMemoryException(Supplier<T> action) {
        try {
            return action.get();
        }
        catch (OpenCLException exception) {
            if (exception.getErrorCode() == -4) {
                POOLS.forEach(ClearCLBufferPool::clear);
                return action.get();
            }
            throw exception;
        }
    }
}

