/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.hessian;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.composite.Composite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

@Deprecated
@Plugin(type=FeatureOp.class, label="Hessian")
public class SingleHessianFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma = 1.0;
    List<String> LABELS = Arrays.asList("", "_Trace", "_Determinant", "_Eigenvalue_1", "_Eigenvalue_2", "_Orientation", "_Square_Eigenvalue_Difference", "_Normalized_Eigenvalue_Difference");
    private static final int HESSIAN = 0;
    private static final int TRACE = 1;
    private static final int DETERMINANT = 2;
    private static final int EIGENVALUE_1 = 3;
    private static final int EIGENVALUE_2 = 4;
    private static final int ORIENTATION = 5;
    private static final int SQUARE_EIGENVALUE_DIFFERENCE = 6;
    private static final int NORMALIZED_EIGENVALUE_DIFFERENCE = 7;

    @Override
    public int count() {
        return 8;
    }

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        this.calculateHessianOnChannel(input.original(), output, this.sigma);
    }

    @Override
    public List<String> attributeLabels() {
        return this.LABELS.stream().map(x -> "Hessian" + x + "_" + this.sigma).collect(Collectors.toList());
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 2;
    }

    private void calculateHessianOnChannel(RandomAccessible<FloatType> image, List<RandomAccessibleInterval<FloatType>> output, double sigma) {
        double[] sigmas = new double[]{0.4 * sigma, 0.4 * sigma};
        Interval secondDerivativeInterval = (Interval)output.get(0);
        FinalInterval firstDerivativeInterval = Intervals.union((Interval)RevampUtils.deriveXRequiredInput(secondDerivativeInterval), (Interval)RevampUtils.deriveYRequiredInput(secondDerivativeInterval));
        FinalInterval blurredInterval = Intervals.union((Interval)RevampUtils.deriveXRequiredInput((Interval)firstDerivativeInterval), (Interval)RevampUtils.deriveYRequiredInput((Interval)firstDerivativeInterval));
        RandomAccessibleInterval<FloatType> blurred = RevampUtils.gauss(image, (Interval)blurredInterval, sigmas);
        RandomAccessibleInterval<FloatType> dx = RevampUtils.deriveX(blurred, (Interval)firstDerivativeInterval);
        RandomAccessibleInterval<FloatType> dy = RevampUtils.deriveY(blurred, (Interval)firstDerivativeInterval);
        RandomAccessibleInterval<FloatType> dxx = RevampUtils.deriveX(dx, secondDerivativeInterval);
        RandomAccessibleInterval<FloatType> dxy = RevampUtils.deriveY(dx, secondDerivativeInterval);
        RandomAccessibleInterval<FloatType> dyy = RevampUtils.deriveY(dy, secondDerivativeInterval);
        LoopBuilder.setImages(RevampUtils.vectorizeStack(output), dyy, dxy, dxx).forEachPixel((o, s_xx, s_xy, s_yy) -> SingleHessianFeature.calculateHessianPerPixel((Composite<FloatType>)o, s_xx.getRealFloat(), s_xy.getRealFloat(), s_yy.getRealFloat()));
    }

    private static void calculateHessianPerPixel(Composite<FloatType> output, float s_xx, float s_xy, float s_yy) {
        double t = Math.pow(1.0, 0.75);
        ((FloatType)output.get(0L)).set((float)Math.sqrt(s_xx * s_xx + s_xy * s_xy + s_yy * s_yy));
        float trace = s_xx + s_yy;
        ((FloatType)output.get(1L)).set(trace);
        float determinant = s_xx * s_yy - s_xy * s_xy;
        ((FloatType)output.get(2L)).set(determinant);
        ((FloatType)output.get(3L)).set((float)((double)trace / 2.0 + Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
        ((FloatType)output.get(4L)).set((float)((double)trace / 2.0 - Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
        if ((double)s_xy < 0.0) {
            float orientation = (float)(-0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
            if (Float.isNaN(orientation)) {
                orientation = 0.0f;
            }
            ((FloatType)output.get(5L)).set(orientation);
        } else {
            float orientation = (float)(0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
            if (Float.isNaN(orientation)) {
                orientation = 0.0f;
            }
            ((FloatType)output.get(5L)).set(orientation);
        }
        ((FloatType)output.get(6L)).set((float)(Math.pow(t, 4.0) * (double)trace * (double)trace * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
        ((FloatType)output.get(7L)).set((float)(Math.pow(t, 2.0) * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
    }
}

