/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import fiji.util.gui.OverlayedImageCanvas;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.ShapeRoiHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class RoiListOverlay
implements OverlayedImageCanvas.Overlay {
    private ArrayList<Roi> roi = null;
    private Color color = Roi.getColor();
    private Composite composite = AlphaComposite.getInstance(3);

    public RoiListOverlay() {
    }

    public RoiListOverlay(ArrayList<Roi> roi, Composite composite, Color color) {
        this.setRoi(roi);
        this.setComposite(composite);
        this.setColor(color);
    }

    public void paint(Graphics g, int x, int y, double magnification) {
        if (null == this.roi) {
            return;
        }
        for (Roi r : this.roi) {
            r.setImage(null);
            Shape shape = ShapeRoiHelper.getShape((ShapeRoi)new ShapeRoi(r));
            Rectangle roiBox = r.getBounds();
            Graphics2D g2d = (Graphics2D)g;
            Stroke originalStroke = g2d.getStroke();
            AffineTransform originalTransform = g2d.getTransform();
            AffineTransform at = new AffineTransform();
            at.scale(magnification, magnification);
            at.translate(roiBox.x - x, roiBox.y - y);
            at.concatenate(originalTransform);
            g2d.setTransform(at);
            Composite originalComposite = g2d.getComposite();
            g2d.setComposite(this.composite);
            g2d.setColor(this.color);
            int type = r.getType();
            if (null != r.getStroke()) {
                g2d.setStroke(r.getStroke());
            }
            if (type == 7 || type == 5 || type == 6) {
                g2d.draw(shape);
            } else {
                g2d.fill(shape);
            }
            g2d.setTransform(originalTransform);
            g2d.setComposite(originalComposite);
            g2d.setStroke(originalStroke);
        }
    }

    public void setRoi(ArrayList<Roi> roi) {
        this.roi = roi;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        return "RoiOverlay(" + this.roi + ")";
    }
}

