/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.display.imagej.ImageJVirtualStack;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import net.imglib2.view.Views;

public class ImageJVirtualStackFloat
extends ImageJVirtualStack<FloatType> {
    public static <T extends RealType<?>> ImageJVirtualStackFloat wrap(RandomAccessibleInterval<T> source) {
        return new ImageJVirtualStackFloat(ImageJVirtualStackFloat.toFloat(source));
    }

    private static <T extends RealType<?>> RandomAccessibleInterval<FloatType> toFloat(RandomAccessibleInterval<T> source) {
        if (Util.getTypeFromInterval(source) instanceof FloatType) {
            return source;
        }
        return Converters.convert(source, new ToFloatSamplerConverter<RealType>((RealType)Util.getTypeFromInterval(source)));
    }

    public <S> ImageJVirtualStackFloat(RandomAccessibleInterval<S> source, Converter<? super S, FloatType> converter) {
        this(source, converter, null);
    }

    public <S> ImageJVirtualStackFloat(RandomAccessibleInterval<S> source, Converter<? super S, FloatType> converter, ExecutorService service) {
        super(source, converter, new FloatType(), 32, service);
        this.setMinAndMax(0.0, 1.0);
    }

    private ImageJVirtualStackFloat(RandomAccessibleInterval<FloatType> source) {
        super(source, 32);
        this.setMinAndMax(0.0, 1.0);
    }

    public <S> void setMinMax(RandomAccessibleInterval<S> source, Converter<S, FloatType> converter) {
        if (this.service != null) {
            this.setMinMaxMT((RandomAccessibleInterval<S>)source, converter);
            return;
        }
        RandomAccessibleIntervalCursor cursor = new RandomAccessibleIntervalCursor((RandomAccessible)(Views.isZeroMin(source) ? source : Views.zeroMin(source)));
        FloatType t = new FloatType();
        if (cursor.hasNext()) {
            float min;
            converter.convert(cursor.next(), (Object)t);
            float max = min = t.get();
            while (cursor.hasNext()) {
                converter.convert(cursor.next(), (Object)t);
                float value = t.get();
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            this.setMinAndMax(min, max);
        }
    }

    private <S> void setMinMaxMT(final RandomAccessibleInterval<S> source, final Converter<S, FloatType> converter) {
        final long nTasks = Runtime.getRuntime().availableProcessors();
        long size = 1L;
        for (int d = 0; d < source.numDimensions(); ++d) {
            size *= source.dimension(d);
        }
        final long portionSize = size / nTasks;
        ArrayList<1> tasks = new ArrayList<1>();
        final AtomicInteger ai = new AtomicInteger();
        final ArrayList mins = new ArrayList((int)nTasks);
        final ArrayList maxs = new ArrayList((int)nTasks);
        int t = 0;
        while ((long)t < nTasks) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int i = ai.getAndIncrement();
                    RandomAccessibleIntervalCursor cursor = new RandomAccessibleIntervalCursor((RandomAccessible)(Views.isZeroMin((Interval)source) ? source : Views.zeroMin((RandomAccessibleInterval)source)));
                    FloatType t = new FloatType();
                    long stepsTaken = 0L;
                    cursor.jumpFwd((long)i * portionSize);
                    float min = Float.MAX_VALUE;
                    float max = -3.4028235E38f;
                    while ((long)i != nTasks - 1L && stepsTaken < portionSize || (long)i == nTasks - 1L && cursor.hasNext()) {
                        ++stepsTaken;
                        converter.convert(cursor.next(), (Object)t);
                        float value = t.get();
                        if (value < min) {
                            min = value;
                        }
                        if (!(value > max)) continue;
                        max = value;
                    }
                    mins.add(Float.valueOf(min));
                    maxs.add(Float.valueOf(max));
                    return null;
                }
            });
            ++t;
        }
        try {
            List futures = this.service.invokeAll(tasks);
            for (Future f : futures) {
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        int t2 = 0;
        while ((long)t2 < nTasks) {
            if (min > ((Float)mins.get(t2)).floatValue()) {
                min = ((Float)mins.get(t2)).floatValue();
            }
            if (max < ((Float)maxs.get(t2)).floatValue()) {
                max = ((Float)maxs.get(t2)).floatValue();
            }
            ++t2;
        }
        this.setMinAndMax(min, max);
    }

    private static class ToFloatSamplerConverter<S extends RealType<S>>
    implements SamplerConverter<S, FloatType> {
        private final float min;
        private final float max;

        ToFloatSamplerConverter(S type) {
            this.min = (float)type.getMinValue();
            this.max = (float)type.getMaxValue();
        }

        public FloatType convert(final Sampler<? extends S> sampler) {
            return new FloatType(new FloatAccess(){

                public float getValue(int index) {
                    double val = ((RealType)sampler.get()).getRealDouble();
                    if (val < -3.4028234663852886E38) {
                        val = -3.4028234663852886E38;
                    } else if (val > 3.4028234663852886E38) {
                        val = 3.4028234663852886E38;
                    }
                    return (float)val;
                }

                public void setValue(int index, float value) {
                    float val = value;
                    if (val < min) {
                        val = min;
                    } else if (val > max) {
                        val = max;
                    }
                    ((RealType)sampler.get()).setReal(val);
                }
            });
        }
    }
}

