/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.type.numeric.real.DoubleType;
import org.janelia.thickness.lut.AbstractLUTRealTransformField;

public class SingleDimensionLUTRealTransformField
extends AbstractLUTRealTransformField {
    public SingleDimensionLUTRealTransformField(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> luts) {
        super(numSourceDimensions, numTargetDimensions, luts);
    }

    public void applyInverse(double[] source, double[] target) {
        source[0] = target[0];
        source[1] = target[1];
        source[2] = this.applyInverseChecked(target[2], (int)target[0], (int)target[1]);
    }

    public void applyInverse(float[] source, float[] target) {
        source[0] = target[0];
        source[1] = target[1];
        source[2] = (float)this.applyInverseChecked(target[2], (int)target[0], (int)target[1]);
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        source.setPosition(target);
        source.setPosition(this.applyInverseChecked(target.getDoublePosition(2), (int)target.getDoublePosition(0), (int)target.getDoublePosition(1)), 2);
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public InvertibleRealTransform copy() {
        return new SingleDimensionLUTRealTransformField(this.numSourceDimensions, this.numTargetDimensions, (RandomAccessibleInterval<DoubleType>)this.luts);
    }

    public void apply(double[] source, double[] target) {
        target[0] = source[0];
        target[1] = source[1];
        target[2] = this.applyChecked(source[2], (int)source[0], (int)source[1]);
    }

    public void apply(float[] source, float[] target) {
        target[0] = source[0];
        target[1] = source[1];
        target[2] = (float)this.applyChecked(source[2], (int)source[0], (int)source[1]);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        target.setPosition(source);
        target.setPosition(this.applyChecked(source.getDoublePosition(2), (int)source.getDoublePosition(0), (int)source.getDoublePosition(1)), 2);
    }
}

