/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.Flow3JColorNoiseMapper;
import FlowJ.Flow3JDynamicColorMapper;
import FlowJ.FlowJColorNoiseMapper;
import FlowJ.FlowJDynamicColorMapper;
import FlowJ.FlowJFlow;
import FlowJ.FlowJMapper;
import FlowJ.FlowJQuiverMapper;
import FlowJ.FlowJSpotNoiseMapper;
import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class FlowJDisplay {
    public static final int DCM2D = 0;
    public static final int QUIVER = 1;
    public static final int DCNOISE = 2;
    public static final int SPOTNOISE = 3;
    public static final int DCM3D = 4;
    public static final int DCM3DNOISE = 5;
    public static String[] description = new String[]{"dcm 2D", "quiver", "dc 2D noise", "spotnoise"};
    private static double p;
    private static double q;
    private static double x;
    private static double y;
    private static double dx;
    private static double dy;
    private static int ix;
    private static int iy;
    private static int ip;
    private static int iq;
    private static int maxp;
    private static int maxq;

    public static ImageProcessor quiver(FlowJFlow f, double scale, double rho) {
        return FlowJDisplay.mapImage(f.v.v, f.full, null, 1, 0, scale, scale, rho);
    }

    public static ImageProcessor dcmImage(FlowJFlow f, ImageProcessor image, double scale, double rho) {
        return FlowJDisplay.mapImage(f.v.v, f.full, image, 0, 0, scale, scale, rho);
    }

    public static String toString(int mapping, double scale, double rho) {
        String s = "Flow " + description[mapping];
        s = s + " " + rho;
        return s;
    }

    public static synchronized ImageProcessor mapImage(float[][][] f, boolean[][] full, ImageProcessor image, int mapping, int mappingaxes, double pFactor, double qFactor, double rho) {
        maxp = (int)((double)f[0].length * pFactor);
        maxq = (int)((double)f.length * qFactor);
        Object processor = mapping == 1 || mapping == 3 ? new ByteProcessor(maxp, maxq) : new ColorProcessor(maxp, maxq);
        Object pixels = processor.getPixels();
        FlowJMapper mapper = null;
        switch (mapping) {
            case 2: {
                mapper = new FlowJColorNoiseMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
                break;
            }
            case 3: {
                mapper = new FlowJSpotNoiseMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
                break;
            }
            case 5: {
                mapper = new Flow3JColorNoiseMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
                break;
            }
            case 1: {
                mapper = new FlowJQuiverMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
                break;
            }
            case 0: {
                mapper = new FlowJDynamicColorMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
                break;
            }
            case 4: {
                mapper = new Flow3JDynamicColorMapper((ImageProcessor)processor, f, mappingaxes, maxp, maxq, pFactor, qFactor, rho);
            }
        }
        IJ.showStatus((String)"Rendering...");
        for (iq = 0; iq < maxq; ++iq) {
            IJ.showProgress((double)((float)iq / (float)maxq));
            for (ip = 0; ip < maxp; ++ip) {
                boolean valid;
                x = (double)ip / pFactor;
                y = (double)iq / qFactor;
                ix = (int)x;
                iy = (int)y;
                dx = x - (double)ix;
                dy = y - (double)iy;
                if (ix >= f[0].length - 1 || iy >= f.length - 1) continue;
                int index = iq * maxp + ip;
                if (image != null) {
                    if (image instanceof ByteProcessor) {
                        if (pixels instanceof byte[]) {
                            ((byte[])pixels)[index] = (byte)FlowJDisplay.bilinearV((byte[])image.getPixels(), image.getWidth(), ix, iy, dx, dy);
                        } else if (pixels instanceof int[]) {
                            int b = (int)FlowJDisplay.bilinearV((byte[])image.getPixels(), image.getWidth(), ix, iy, dx, dy);
                            ((int[])pixels)[index] = (b << 16) + (b << 8) + b;
                        }
                    }
                } else if (mapping == 1) {
                    ((byte[])pixels)[index] = -1;
                }
                boolean bl = valid = full == null || full instanceof boolean[][] && full[iy][ix];
                if (!valid) continue;
                mapper.pixel(ip, iq, ix, iy, dx, dy);
            }
        }
        IJ.showStatus((String)"");
        return processor;
    }

    private static double bilinearV(byte[] i, int width, int x, int y, double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return i[y * width + x];
        }
        double p11 = i[y * width + x];
        double p12 = i[y * width + x + 1];
        double p1 = (p12 - p11) * dx + p11;
        double p21 = i[(y + 1) * width + x];
        double p22 = i[(y + 1) * width + x + 1];
        double p2 = (p22 - p21) * dx + p21;
        double r1 = (p2 - p1) * dy + p1;
        return r1;
    }
}

