/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import bijnum.BIJmatrix;

public class FlowJSpotNoise {
    public static final double SIGMA = (double)0.4f;
    public static final double SIGMAM = 2.0;
    private Object pixels;
    private boolean isInt = false;
    protected int maxp;
    protected int maxq;
    protected double sigmas;
    public int width;
    protected static double magnitude;
    protected static double correction;
    protected static double e1;
    protected static double e2;
    protected static double ge;
    protected static int i;
    protected static int j;
    protected static int p;
    protected static int q;
    protected static int index;
    protected static int value;
    protected static double e1d;
    protected static double e2d;
    protected static double e12;
    protected static double e22;
    protected static double sigmas2;
    protected static double sigmal2;
    protected static double v0i;
    protected static double v0j;
    protected static double v1i;
    protected static double v1j;
    protected static int rcomposite;
    protected static int gcomposite;
    protected static int bcomposite;
    protected static int rp;
    protected static int gp;
    protected static int bp;

    public FlowJSpotNoise() {
    }

    public FlowJSpotNoise(byte[] pixels, int maxp, int maxq, double sigmas) {
        this.pixels = pixels;
        this.maxp = maxp;
        this.maxq = maxq;
        this.sigmas = sigmas;
        this.isInt = false;
    }

    public FlowJSpotNoise(int[] pixels, int maxp, int maxq, double sigmas) {
        this.pixels = pixels;
        this.isInt = true;
        this.maxp = maxp;
        this.maxq = maxq;
        this.sigmas = sigmas;
    }

    public void spot(int ip, int iq, double sigmal, int gray, float[] v) {
        magnitude = BIJmatrix.norm(v);
        this.width = this.widthEllipse(sigmal);
        for (j = -this.width / 2; j < this.width / 2; ++j) {
            for (i = -this.width / 2; i < this.width / 2; ++i) {
                p = ip + i;
                q = iq + j;
                if (p < 0 || p >= this.maxp || q < 0 || q >= this.maxq) continue;
                v0i = v[0] * (float)i;
                v1j = v[1] * (float)j;
                v1i = v[1] * (float)i;
                v0j = v[0] * (float)j;
                e1d = v1i + v0j;
                e2d = v0i - v1j;
                e1 = e1d / magnitude;
                e2 = e2d / magnitude;
                e12 = (float)Math.pow(e1, 2.0);
                sigmas2 = (float)Math.pow(this.sigmas, 2.0);
                e22 = (float)Math.pow(e2, 2.0);
                sigmal2 = (float)Math.pow(sigmal, 2.0);
                ge = (float)Math.exp(-(e12 / sigmas2 + e22 / sigmal2) / 2.0);
                index = q * this.maxp + p;
                value = ((byte[])this.pixels)[index] & 0xFF;
                ((byte[])this.pixels)[FlowJSpotNoise.index] = (byte)this.composePixel(value, gray, ge);
            }
        }
    }

    public void spot(int ip, int iq, double sigmal, int r, int g, int b, float[] v) {
        magnitude = BIJmatrix.norm(v);
        this.width = this.widthEllipse(sigmal);
        if (this.width == 0) {
            return;
        }
        for (j = -this.width / 2; j < this.width / 2; ++j) {
            for (i = -this.width / 2; i < this.width / 2; ++i) {
                p = ip + i;
                q = iq + j;
                if (p < 0 || p >= this.maxp || q < 0 || q >= this.maxq) continue;
                v0i = v[0] * (float)i;
                v1j = v[1] * (float)j;
                v1i = v[1] * (float)i;
                v0j = v[0] * (float)j;
                e1d = v1i + v0j;
                e2d = v0i - v1j;
                e1 = e1d / magnitude;
                e2 = e2d / magnitude;
                e12 = (float)Math.pow(e1, 2.0);
                sigmas2 = (float)Math.pow(this.sigmas, 2.0);
                e22 = (float)Math.pow(e2, 2.0);
                sigmal2 = (float)Math.pow(sigmal, 2.0);
                ge = (float)Math.exp(-(e12 / sigmas2 + e22 / sigmal2) / 2.0);
                index = q * this.maxp + p;
                value = ((int[])this.pixels)[index];
                ((int[])this.pixels)[FlowJSpotNoise.index] = this.compositePixel(value, r, g, b, ge);
            }
        }
    }

    protected float gaussianEllipse(double e1, double e2, double sigmas, double sigmal) {
        return (float)Math.exp(-(Math.pow(e1, 2.0) / Math.pow(sigmas, 2.0) + Math.pow(e2, 2.0) / Math.pow(sigmal, 2.0)) / 2.0);
    }

    protected int widthEllipse(double sigma) {
        double sigma6i = 6.0 * sigma + 1.0;
        if (sigma6i % 2.0 == 0.0) {
            return (int)sigma6i + 1;
        }
        return (int)sigma6i;
    }

    protected float sigmaEllipse(int width) {
        return ((float)width - 1.0f) / 6.0f;
    }

    private int composePixel(int pxl, int gray, double ge) {
        pxl = Math.min((int)(ge * (double)gray) + pxl, 255);
        return pxl;
    }

    private int compositePixel(int pxl, int r, int g, int b, double ge) {
        rp = pxl >> 16 & 0xFF;
        gp = pxl >> 8 & 0xFF;
        bp = pxl & 0xFF;
        correction = ge;
        rcomposite = Math.min((int)(correction * (double)r) + rp, 255);
        gcomposite = Math.min((int)(correction * (double)g) + gp, 255);
        bcomposite = Math.min((int)(correction * (double)b) + bp, 255);
        pxl = rcomposite << 16 | gcomposite << 8 | bcomposite;
        return pxl;
    }
}

