/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import volume.Volume;

public class VolumeRGB
extends Volume {
    public byte[] b;
    public byte[] index;
    public Object[] sliceArray;

    public VolumeRGB(int width, int height, int depth, double aspectx, double aspecty, double aspectz) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.b = new byte[depth * height * width];
        this.setAspects(aspectx, aspecty, aspectz);
        this.edge = 0;
    }

    public VolumeRGB(Object[] sliceArray, int width, int depth, double aspectx, double aspecty, double aspectz) {
        this(width, ((int[])sliceArray[0]).length / width, depth, aspectx, aspecty, aspectz);
        this.sliceArray = sliceArray;
        this.load(sliceArray, 0);
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Byte(this.b[z * this.width * this.height + y * this.width + x]);
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.b[z * this.width * this.height + y * this.width + x] = ((Number)value).byteValue();
    }

    protected void load(Object[] sliceArray, int start) {
        float[] hsb = new float[3];
        for (int z = start; z < start + this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int[] slice = (int[])sliceArray[z];
                    int vv = slice[y * this.width + x];
                    VolumeRGB.intToHSB(hsb, vv);
                    this.b[(z - start) * this.height * this.width + y * this.width + x] = (byte)((int)((double)hsb[2] * 255.0) & 0xFF);
                }
            }
        }
    }

    public ImageStack getImageStack() {
        ImageStack stack = new ImageStack(this.width, this.height);
        for (int z = 0; z < this.depth; ++z) {
            ByteProcessor ip = new ByteProcessor(this.width, this.height);
            byte[] plane = (byte[])ip.getPixels();
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    plane[y * this.width + x] = this.b[z * this.height * this.width + y * this.width + x];
                }
            }
            stack.addSlice("" + (z + 1), (ImageProcessor)ip);
        }
        return stack;
    }

    public static float[] intToHSB(float[] hsb, int i) {
        int red = (i & 0xFF0000) >> 16;
        int green = (i & 0xFF00) >> 8;
        int blue = i & 0xFF;
        Color.RGBtoHSB(red, green, blue, hsb);
        return hsb;
    }

    public static int ColorToInt(Color color) {
        int rvalue = color.getRed();
        int gvalue = color.getGreen();
        int bvalue = color.getBlue();
        return rvalue << 16 | gvalue << 8 | bvalue;
    }

    public void setIndex(Object[] sliceArray) {
        this.index = new byte[this.depth * this.height * this.width];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    byte[] slice = (byte[])sliceArray[z];
                    this.index[z * this.height * this.width + y * this.width + x] = slice[y * this.width + x];
                }
            }
        }
    }

    public boolean isIndexed() {
        return this.index instanceof byte[];
    }
}

