/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import org.scijava.util.LongArray;

public class DllFile {
    private final RandomAccessFile ra;
    private long[] rvaMap;
    private long dataDirectoryOffset;
    private LongArray toSkip;

    public static void main(String ... args) throws MalformedURLException {
        File a = new File(System.getProperty("user.home") + "/ij2/updater/a1.dll");
        File b = new File(System.getProperty("user.home") + "/ij2/updater/c2.dll");
        System.err.println("equal: " + DllFile.equals(a, b.toURI().toURL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(File a, URL b) {
        boolean bl;
        DllFile dllA = new DllFile(a);
        try {
            bl = dllA.equals(b.openConnection());
        }
        catch (Throwable throwable) {
            try {
                dllA.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        dllA.close();
        return bl;
    }

    public DllFile(File file) throws IOException {
        this.ra = new RandomAccessFile(file, "r");
        this.ra.seek(60L);
        int peOffset = this.read32();
        this.ra.seek(peOffset);
        int signature = this.read32();
        if (signature != 17744) {
            this.ra.close();
            throw new IllegalArgumentException("Not a DLL!!!" + String.format("0x%08x", signature));
        }
    }

    public void close() throws IOException {
        this.ra.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(URLConnection o) throws IOException {
        if (this.ra.length() != (long)o.getContentLength()) {
            return false;
        }
        this.initialize();
        long[] toSkip = (long[])this.toSkip.copyArray();
        Arrays.sort(toSkip);
        try (InputStream in = o.getInputStream();){
            int i = 0;
            while (i + 1 < toSkip.length) {
                this.ra.seek(toSkip[i]);
                long skipCount = toSkip[i] - (i > 0 ? toSkip[i - 1] : 0L);
                if (skipCount != 0L) {
                    in.skip(skipCount);
                }
                if (!this.equals(in, toSkip[i + 1] - toSkip[i])) {
                    boolean bl = false;
                    return bl;
                }
                i += 2;
            }
        }
        return true;
    }

    private void addSkip(long offset, long length) {
        this.toSkip.add((Object)offset);
        this.toSkip.add((Object)(offset + length));
    }

    private long rva2offset(long rva) {
        int i = 0;
        while (i + 2 < this.rvaMap.length) {
            long base = this.rvaMap[i];
            if (rva >= base && rva < base + this.rvaMap[i + 1]) {
                return rva + this.rvaMap[i + 2] - base;
            }
            i += 3;
        }
        return -1L;
    }

    private int read16() throws IOException {
        return this.ra.readByte() & 0xFF | (this.ra.readByte() & 0xFF) << 8;
    }

    private int read32() throws IOException {
        return this.ra.readByte() & 0xFF | (this.ra.readByte() & 0xFF) << 8 | (this.ra.readByte() & 0xFF) << 16 | (this.ra.readByte() & 0xFF) << 24;
    }

    private void initialize() throws IOException {
        if (this.toSkip != null) {
            return;
        }
        this.toSkip = new LongArray();
        this.toSkip.add((Object)0L);
        this.ra.skipBytes(2);
        int sectionCount = this.read16();
        this.addSkip(this.ra.getFilePointer(), 4L);
        this.ra.skipBytes(12);
        int optHeaderSize = this.read16();
        this.ra.skipBytes(2);
        long optHeaderOffset = this.ra.getFilePointer();
        this.addSkip(optHeaderOffset + 64L, 4L);
        long firstSectionOffset = optHeaderOffset + (long)optHeaderSize;
        this.rvaMap = new long[sectionCount * 3];
        for (int i = 0; i < sectionCount; ++i) {
            this.ra.seek(firstSectionOffset + (long)(i * 40) + 12L);
            for (int j = 0; j < 3; ++j) {
                this.rvaMap[3 * i + j] = (long)this.read32() & 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (optHeaderSize != 224 && optHeaderSize != 240) {
            throw new IOException("Unknown optHeaderSize: " + String.format("0x%04x", optHeaderSize));
        }
        this.dataDirectoryOffset = optHeaderOffset + (long)optHeaderSize - 128L;
        this.ra.seek(this.dataDirectoryOffset);
        int rva = this.read32();
        long offset = this.rva2offset(rva);
        if (offset > 0L && this.read32() >= 8) {
            this.addSkip(offset + 4L, 4L);
        }
        this.ra.seek(this.dataDirectoryOffset + 8L);
        rva = this.read32();
        offset = this.rva2offset(rva);
        if (offset > 0L && this.read32() >= 8) {
            this.addSkip(offset + 4L, 4L);
        }
        this.ra.seek(this.dataDirectoryOffset + 48L);
        rva = this.read32();
        offset = this.rva2offset(rva);
        if (offset > 0L && this.read32() >= 28) {
            this.addSkip(offset + 4L, 4L);
            this.ra.seek(offset + 16L);
            int size = this.read32();
            this.ra.skipBytes(4);
            int filePointer = this.read32();
            if (filePointer > 0) {
                this.addSkip(filePointer, size);
            }
        }
        this.toSkip.add((Object)this.ra.length());
    }

    private boolean equals(InputStream in, long length) throws IOException {
        byte[] buffer = new byte[65536];
        byte[] otherBuffer = new byte[65536];
        while (length > 0L) {
            int count2;
            int count = buffer.length;
            if ((long)count > length) {
                count = (int)length;
            }
            this.ra.readFully(buffer, 0, count);
            for (int offset = 0; offset < count; offset += count2) {
                count2 = in.read(otherBuffer, offset, count - offset);
                if (count2 >= 0) continue;
                throw new IOException("Short read!");
            }
            for (int i = 0; i < count; ++i) {
                if (buffer[i] == otherBuffer[i]) continue;
                return false;
            }
            length -= (long)count;
        }
        return true;
    }
}

