/*
 * Decompiled with CFR 0.152.
 */
package adt;

import java.awt.Point;
import java.awt.Polygon;
import java.util.HashSet;

public class Points {
    private HashSet<Point> points = new HashSet();
    private Points child = null;
    private Point topLeft;
    private Point bottomRight;

    public void addPoint(int x, int y) {
        this.addPoint(new Point(x, y));
    }

    public void addPoint(Point p) {
        if (this.topLeft == null) {
            this.topLeft = new Point(p.x, p.y);
        } else {
            if (p.x < this.topLeft.x) {
                this.topLeft.x = p.x;
            }
            if (p.y < this.topLeft.y) {
                this.topLeft.y = p.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(p.x, p.y);
        } else {
            if (p.x > this.bottomRight.x) {
                this.bottomRight.x = p.x;
            }
            if (p.y > this.bottomRight.y) {
                this.bottomRight.y = p.y;
            }
        }
        this.points.add(p);
    }

    public int getSize() {
        return this.points.size() + (this.child == null ? 0 : this.child.getSize());
    }

    public boolean contains(Point p) {
        if (this.child == null) {
            return this.points.contains(p);
        }
        return this.points.contains(p) || this.child.contains(p);
    }

    public void addPoints(Points other) {
        if (other.topLeft.x < this.topLeft.x) {
            this.topLeft.x = other.topLeft.x;
        }
        if (other.topLeft.y < this.topLeft.y) {
            this.topLeft.y = other.topLeft.y;
        }
        if (other.bottomRight.x < this.bottomRight.x) {
            this.bottomRight.x = other.bottomRight.x;
        }
        if (other.bottomRight.y < this.bottomRight.y) {
            this.bottomRight.y = other.bottomRight.y;
        }
        if (other.points.size() > 5) {
            if (this.child == null) {
                this.child = other;
            } else {
                this.child.addPoints(other);
            }
        } else {
            this.points.addAll(other.points);
        }
    }

    private void removeChildRef() {
        Points current = this.child;
        while (current != null) {
            this.points.addAll(current.points);
            Points old = current;
            current = current.child;
            old.child = null;
        }
        this.child = null;
    }

    public Iterable<Point> getPoints() {
        this.removeChildRef();
        return this.points;
    }

    public Polygon getOutline() {
        this.removeChildRef();
        Polygon poly = new Polygon();
        SearchNode current = this.findInitialEdge();
        Point start = current.p;
        do {
            poly.addPoint(current.p.x, current.p.y);
            current.next();
        } while (!current.p.equals(start));
        return poly;
    }

    private SearchNode findInitialEdge() {
        for (int x = this.topLeft.x; x <= this.bottomRight.x; ++x) {
            for (int y = this.topLeft.y; y <= this.bottomRight.y; ++y) {
                if (!this.contains(new Point(x, y))) continue;
                if (y > this.topLeft.y) {
                    System.err.println("border has been calculated incorrectly, but corrected for");
                }
                return new SearchNode(new Point(x, y), 0);
            }
        }
        throw new RuntimeException("border has been calculated incorrectly");
    }

    class SearchNode {
        Point p;
        int borderDir;

        public SearchNode(Point p, int borderDir) {
            this.p = p;
            this.borderDir = borderDir;
        }

        public void next() {
            int i;
            Point next = null;
            int searchDir = this.borderDir;
            Point knownExterior = this.getPointInDir(this.p, this.borderDir);
            for (i = 1; i < 8 && !Points.this.contains(next = this.getPointInDir(this.p, searchDir = (this.borderDir + i) % 8)); ++i) {
                knownExterior = next;
            }
            if (next == null) {
                next = this.p;
                System.out.println("single point points = " + Points.this.points);
            }
            this.p = next;
            this.borderDir = this.dir(this.p, knownExterior);
            for (i = 1; i < 8 && !Points.this.contains(next = this.getPointInDir(this.p, searchDir = (this.borderDir + 1) % 8)); ++i) {
                this.borderDir = searchDir;
            }
        }

        public Point getPointInDir(Point ref, int dir) {
            if (dir == 0) {
                return new Point(ref.x, ref.y - 1);
            }
            if (dir == 1) {
                return new Point(ref.x + 1, ref.y - 1);
            }
            if (dir == 2) {
                return new Point(ref.x + 1, ref.y);
            }
            if (dir == 3) {
                return new Point(ref.x + 1, ref.y + 1);
            }
            if (dir == 4) {
                return new Point(ref.x, ref.y + 1);
            }
            if (dir == 5) {
                return new Point(ref.x - 1, ref.y + 1);
            }
            if (dir == 6) {
                return new Point(ref.x - 1, ref.y);
            }
            if (dir == 7) {
                return new Point(ref.x - 1, ref.y - 1);
            }
            throw new RuntimeException("dir = " + dir);
        }

        public int dir(Point ref, Point neighbour) {
            if (neighbour.x < ref.x) {
                if (neighbour.y < ref.y) {
                    return 7;
                }
                if (neighbour.y == ref.y) {
                    return 6;
                }
                return 5;
            }
            if (neighbour.x == ref.x) {
                if (neighbour.y < ref.y) {
                    return 0;
                }
                if (neighbour.y == ref.y) {
                    return -1;
                }
                return 4;
            }
            if (neighbour.y < ref.y) {
                return 1;
            }
            if (neighbour.y == ref.y) {
                return 2;
            }
            return 3;
        }
    }
}

