/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import process3d.Convolve3d;

public class Gradient {
    public static ImagePlus calculateGrad(ImagePlus imp, boolean useCalib) {
        IJ.showStatus((String)"Calculating gradient");
        Calibration c = imp.getCalibration();
        float dx = useCalib ? 2.0f * (float)c.pixelWidth : 2.0f;
        float dy = useCalib ? 2.0f * (float)c.pixelHeight : 2.0f;
        float dz = useCalib ? 2.0f * (float)c.pixelDepth : 2.0f;
        float[] H_x = new float[]{-1.0f / dx, 0.0f, 1.0f / dx};
        ImagePlus g_x = Convolve3d.convolveX(imp, H_x);
        float[] H_y = new float[]{-1.0f / dy, 0.0f, 1.0f / dy};
        ImagePlus g_y = Convolve3d.convolveY(imp, H_y);
        float[] H_z = new float[]{-1.0f / dz, 0.0f, 1.0f / dz};
        ImagePlus g_z = Convolve3d.convolveZ(imp, H_z);
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        ImageStack grad = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            FloatProcessor res = new FloatProcessor(w, h);
            grad.addSlice("", (ImageProcessor)res);
            float[] values = (float[])res.getPixels();
            float[] x_ = (float[])g_x.getStack().getProcessor(z + 1).getPixels();
            float[] y_ = (float[])g_y.getStack().getProcessor(z + 1).getPixels();
            float[] z_ = (float[])g_z.getStack().getProcessor(z + 1).getPixels();
            for (int i = 0; i < w * h; ++i) {
                values[i] = (float)Math.sqrt(x_[i] * x_[i] + y_[i] * y_[i] + z_[i] * z_[i]);
            }
        }
        ImagePlus ret = new ImagePlus("Gradient", grad);
        ret.setCalibration(c);
        return ret;
    }
}

