/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Vector;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.TransformedImage;
import vib.VIB;
import vib.app.module.Module;
import vib.app.module.Resample;
import vib.app.module.State;
import vib.app.module.TransformImages;

public class AverageBrain
extends Module {
    int[][] cumul;
    int w;
    int h;
    int d;
    int count;
    private FastMatrix[] matrices;
    private ImagePlus scratch;

    @Override
    public String getName() {
        return "AverageBrain";
    }

    @Override
    protected String getMessage() {
        return "Averaging brain";
    }

    @Override
    protected boolean runsOnce() {
        return true;
    }

    @Override
    protected void run(State state, int index) {
        if (index != 0) {
            return;
        }
        new TransformImages().runOnAllImages(state);
        new Resample().runOnAllImages(state);
        this.prereqsDone(state, index);
        new AverageBrain().doit(state);
    }

    private void doit(State state) {
        this.matrices = null;
        this.scratch = null;
        for (int i = -1; i < state.options.numChannels; ++i) {
            String outputPath = state.getOutputPath(i);
            this.doit(state, this.getCompleteChannel(state, i), outputPath);
        }
    }

    public void doit(State state, String[] images, String outputPath) {
        if (State.upToDate(images, outputPath)) {
            return;
        }
        if (this.matrices == null) {
            this.matrices = this.getMatrices(state);
        }
        if (this.scratch == null) {
            this.scratch = state.options.needsLabels() ? state.getTemplateLabels() : state.getTemplate();
        }
        this.doit(this.scratch, images, this.matrices);
        if (!state.save(this.scratch, outputPath)) {
            throw new RuntimeException("Could not save " + outputPath);
        }
    }

    private FastMatrix[] getMatrices(State state) {
        FastMatrix[] result = new FastMatrix[state.getImageCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new FastMatrix();
            result[i].copyFrom(state.getTransformMatrix(i));
        }
        return result;
    }

    private String[] getCompleteChannel(State state, int channel) {
        String[] result = new String[state.getImageCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = state.getWarpedPath(channel, i);
        }
        return result;
    }

    public void doit(ImagePlus image, String[] fileNames, FastMatrix[] matrices) {
        int n = this.count = "".equals(fileNames[0]) ? 0 : fileNames.length;
        if (this.count != matrices.length) {
            IJ.error((String)("Count mismatch: " + this.count + " files, but " + matrices.length + " matrices!"));
            return;
        }
        int realCount = this.count;
        InterpolatedImage ii = new InterpolatedImage(image);
        this.w = ii.w;
        this.h = ii.h;
        this.d = ii.d;
        this.cumul = new int[ii.d][ii.w * ii.h];
        boolean isGray = !image.getProcessor().isColorLut();
        Method method = isGray ? new AverageGray() : new AverageLabels();
        method.cumul = this.cumul;
        if (!isGray) {
            AmiraParameters p = new AmiraParameters(image);
            p.changeLabelfieldToGray();
            p.setParameters(image);
        }
        for (int m = 0; m < this.count; ++m) {
            VIB.showStatus("Brain (" + (m + 1) + "/" + this.count + ")");
            ImagePlus img = IJ.openImage((String)fileNames[m]);
            if (img == null) {
                --realCount;
                continue;
            }
            method.t = new TransformedImage(image, img);
            method.t.setTransformation(matrices[m]);
            method.isIdentity = method.t.matrix.isIdentity();
            TransformedImage.Iterator iter = method.t.iterator();
            while (iter.next() != null) {
                method.accumulate(iter.i, iter.j, iter.k, iter.x, iter.y, iter.z);
            }
            method.t = null;
            img.close();
        }
        method.count = realCount < 1 ? 1 : realCount;
        InterpolatedImage.Iterator iter = ii.iterator();
        while (iter.next() != null) {
            ii.set(iter.i, iter.j, iter.k, method.get(iter.i, iter.j, iter.k));
        }
    }

    private static byte physicsLUTHelper(double rad) {
        double s = Math.sin(rad);
        if (s < 0.0) {
            return 0;
        }
        return (byte)Math.round(255.0 * s);
    }

    private static void setPhysicsLUT(ImagePlus ip) {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int max = 100;
        for (int i = 0; i <= max; ++i) {
            double rad = (double)i * Math.PI / (double)(max / 2);
            rLUT[i] = AverageBrain.physicsLUTHelper(rad + Math.PI);
            gLUT[i] = AverageBrain.physicsLUTHelper(rad - 1.5707963267948966);
            bLUT[i] = AverageBrain.physicsLUTHelper(rad);
        }
        IndexColorModel c = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
        ip.getProcessor().setColorModel((ColorModel)c);
        if (ip.getStackSize() > 1) {
            ip.getStack().setColorModel((ColorModel)c);
        }
    }

    public static void main(String[] args) {
        Tuple t = new Tuple(5, 1, 3);
        Tuple t1 = new Tuple(t, 5);
        Tuple t2 = new Tuple(t, 3);
        Tuple t3 = new Tuple(t, 2);
        Tuple t4 = new Tuple(t1, 5);
        Tuple t5 = new Tuple(t1, 3);
        System.err.println("3(1) 5(1) : " + t);
        System.err.println("5(2) 3(1) : " + t1);
        System.err.println("3(2) 5(1) : " + t2);
        System.err.println("3(1) 5(1) 2(1) : " + t3);
        System.err.println("5(3) 3(1) : " + t4);
        System.err.println("5(2) 3(2) : " + t5);
    }

    static class Tuple {
        byte[] labels = new byte[256];
        int[] counts = new int[256];

        public Tuple(int label1, int count1, int label2) {
            if (count1 == 1 && label2 < label1) {
                int l = label2;
                label2 = label1;
                label1 = l;
            }
            this.labels[0] = (byte)label1;
            this.counts[0] = count1;
            this.labels[1] = (byte)label2;
            this.counts[1] = 1;
        }

        public Tuple(Tuple tuple, int label) {
            int j;
            int i;
            System.arraycopy(tuple.labels, 0, this.labels, 0, this.labels.length);
            System.arraycopy(tuple.counts, 0, this.counts, 0, this.counts.length);
            for (i = 0; i < this.labels.length && this.labels[i] != label && this.labels[i] != 0; ++i) {
            }
            if (this.labels[i] == 0) {
                this.labels[i] = (byte)label;
            }
            for (j = i - 1; j >= 0 && this.counts[j] == this.counts[i]; --j) {
            }
            if (++j < i) {
                int c = this.counts[i];
                System.arraycopy(this.labels, j, this.labels, j + 1, i - j);
                System.arraycopy(this.counts, j, this.counts, j + 1, i - j);
                this.labels[j] = (byte)label;
                this.counts[j] = c;
                i = j;
            }
            int n = i;
            this.counts[n] = this.counts[n] + 1;
        }

        public boolean equals(Tuple tuple) {
            for (int i = 0; i == 0 || this.labels[i - 1] != 0; ++i) {
                if (this.labels[i] == tuple.labels[i] && this.counts[i] == tuple.counts[i]) continue;
                return false;
            }
            return true;
        }

        public int getIndex(Vector tuples) {
            int count = tuples.size();
            for (int i = 0; i < count; ++i) {
                if (!this.equals((Tuple)tuples.get(i))) continue;
                return i;
            }
            tuples.add(this);
            return count;
        }

        public String toString() {
            String result = "";
            for (int i = 0; i < 256 && this.labels[i] != 0; ++i) {
                result = result + "" + this.labels[i] + "(" + this.counts[i] + ") ";
            }
            return result;
        }
    }

    class AverageLabels
    extends Method {
        byte[][] labels;
        Vector[] tuples;
        static final int maxProb = 100;

        public AverageLabels() {
            this.labels = new byte[AverageBrain.this.d][AverageBrain.this.w * AverageBrain.this.h];
            this.tuples = new Vector[256];
            for (int i = 0; i < 256; ++i) {
                this.tuples[i] = new Vector();
            }
        }

        @Override
        public void accumulate(int i, int j, int k, double x, double y, double z) {
            int v = this.t.transform.getNearestByte(x, y, z);
            if (v == 0) {
                return;
            }
            int l = v < 0 ? 256 + v : v;
            int l1 = this.labels[k][i + j * AverageBrain.this.w];
            if (l1 < 0) {
                l1 += 256;
            }
            int c1 = this.cumul[k][i + j * AverageBrain.this.w];
            if (l1 == 0) {
                this.labels[k][i + j * AverageBrain.this.w] = v;
                this.cumul[k][i + j * AverageBrain.this.w] = 1;
            } else if (l1 == l && c1 > 0) {
                int[] nArray = this.cumul[k];
                int n = i + j * AverageBrain.this.w;
                nArray[n] = nArray[n] + 1;
            } else {
                Tuple newTuple;
                if (c1 > 0) {
                    newTuple = new Tuple(l1, c1, l);
                } else {
                    Tuple old = (Tuple)this.tuples[l1].get(-c1);
                    newTuple = new Tuple(old, l);
                }
                if (newTuple.labels[0] != (byte)l1) {
                    l1 = newTuple.labels[0];
                    this.labels[k][i + j * AverageBrain.this.w] = (byte)l1;
                    if (l1 < 0) {
                        l1 += 256;
                    }
                }
                this.cumul[k][i + j * AverageBrain.this.w] = -newTuple.getIndex(this.tuples[l1]);
            }
        }

        @Override
        public int get(int i, int j, int k) {
            int c;
            int label = this.labels[k][i + j * AverageBrain.this.w];
            if (label == 0) {
                return 0;
            }
            if (label < 0) {
                label += 256;
            }
            if ((c = this.cumul[k][i + j * AverageBrain.this.w]) <= 0) {
                Tuple t = (Tuple)this.tuples[label].get(-c);
                c = t.counts[0];
            }
            return c * 100 / this.count;
        }
    }

    class AverageGray
    extends Method {
        AverageGray() {
        }

        @Override
        public void accumulate(int i, int j, int k, double x, double y, double z) {
            if (this.isIdentity) {
                int[] nArray = this.cumul[k];
                int n = i + j * AverageBrain.this.w;
                nArray[n] = nArray[n] + this.t.transform.getNoInterpol(i, j, k);
                return;
            }
            double v = this.t.transform.interpol.get(x, y, z);
            int[] nArray = this.cumul[k];
            int n = i + j * AverageBrain.this.w;
            nArray[n] = nArray[n] + (int)v;
        }

        @Override
        public int get(int i, int j, int k) {
            return this.cumul[k][i + j * AverageBrain.this.w] / this.count;
        }
    }

    abstract class Method {
        boolean isIdentity = false;
        TransformedImage t;
        int[][] cumul;
        int count;

        Method() {
        }

        public abstract void accumulate(int var1, int var2, int var3, double var4, double var6, double var8);

        public abstract int get(int var1, int var2, int var3);
    }
}

