/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType64BitSignedFloat
extends AbstractContextual
implements DataType<DoubleType> {
    private final DoubleType type = new DoubleType();

    @Override
    public DoubleType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "64-bit float";
    }

    @Override
    public String longName() {
        return "64-bit signed float";
    }

    @Override
    public String description() {
        return "A float data type ranging between -1.7976931348623157E308 and 1.7976931348623157E308";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(DoubleType dest) {
        dest.set(-1.7976931348623157E308);
    }

    @Override
    public void upperBound(DoubleType dest) {
        dest.set(Double.MAX_VALUE);
    }

    @Override
    public int bitCount() {
        return 64;
    }

    @Override
    public DoubleType createVariable() {
        return new DoubleType();
    }

    @Override
    public void cast(DoubleType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, DoubleType dest) {
        this.setDouble(dest, val.getReal().doubleValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(DoubleType val) {
        return val.get();
    }

    @Override
    public long asLong(DoubleType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(DoubleType val, double v) {
        val.set(v);
    }

    @Override
    public void setLong(DoubleType val, long v) {
        this.setDouble(val, (double)v);
    }
}

