/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij3d.Volume;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.vecmath.Point3d;

public class VoltexVolume
extends Volume {
    int xTexSize;
    int yTexSize;
    int zTexSize;
    float xTexGenScale;
    float yTexGenScale;
    float zTexGenScale;
    final Point3d volRefPt = new Point3d();
    protected static final ColorModel greyCM = VoltexVolume.createGreyColorModel();
    protected static final ColorModel rgbCM = VoltexVolume.createRGBColorModel();
    protected ComponentCreator compCreator;
    private final ImageUpdater updater = new ImageUpdater();
    private byte[][] xy;
    private byte[][] xz;
    private byte[][] yz;
    private ImageComponent2D[] xyComp;
    private ImageComponent2D[] xzComp;
    private ImageComponent2D[] yzComp;
    private VoltexLoader voltexLoader;

    public VoltexVolume(ImagePlus imp) {
        this(imp, new boolean[]{true, true, true});
    }

    public VoltexVolume(ImagePlus imp, boolean[] ch) {
        this.setImage(imp, ch);
    }

    @Override
    public void setImage(ImagePlus imp, boolean[] ch) {
        super.setImage(imp, ch);
        this.xTexSize = VoltexVolume.powerOfTwo(this.xDim);
        this.yTexSize = VoltexVolume.powerOfTwo(this.yDim);
        this.zTexSize = VoltexVolume.powerOfTwo(this.zDim);
        float xSpace = (float)this.pw;
        float ySpace = (float)this.ph;
        float zSpace = (float)this.pd;
        this.xTexGenScale = (float)(1.0 / (double)(xSpace * (float)this.xTexSize));
        this.yTexGenScale = (float)(1.0 / (double)(ySpace * (float)this.yTexSize));
        this.zTexGenScale = (float)(1.0 / (double)(zSpace * (float)this.zTexSize));
        this.volRefPt.x = (this.maxCoord.x + this.minCoord.x) / 2.0;
        this.volRefPt.y = (this.maxCoord.y + this.minCoord.y) / 2.0;
        this.volRefPt.z = (this.maxCoord.z + this.minCoord.z) / 2.0;
        this.initDataType();
        this.initVoltexLoader();
        this.createImageComponents();
        this.updateData();
    }

    @Override
    public void clear() {
        super.clear();
        this.xy = null;
        this.xz = null;
        this.yz = null;
        this.xyComp = null;
        this.xzComp = null;
        this.yzComp = null;
    }

    @Override
    public void swap(String path) {
        super.swap(path);
        this.xy = null;
        this.xz = null;
        this.yz = null;
        this.xyComp = null;
        this.xzComp = null;
        this.yzComp = null;
    }

    @Override
    public void restore(String path) {
        ImagePlus imp = IJ.openImage((String)(path + ".tif"));
        try {
            this.setImage(IJ.openImage((String)(path + ".tif")), this.channels);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Cannot load image from " + path);
        }
        catch (RuntimeException e) {
            System.out.println("Cannot load " + path);
            throw e;
        }
    }

    private void createImageComponents() {
        for (int z = 0; z < this.zDim; ++z) {
            this.xyComp[z] = this.compCreator.createImageComponent(this.xy[z], this.xTexSize, this.yTexSize);
        }
        for (int y = 0; y < this.yDim; ++y) {
            this.xzComp[y] = this.compCreator.createImageComponent(this.xz[y], this.xTexSize, this.zTexSize);
        }
        for (int x = 0; x < this.xDim; ++x) {
            this.yzComp[x] = this.compCreator.createImageComponent(this.yz[x], this.yTexSize, this.zTexSize);
        }
    }

    public void updateData() {
        for (int z = 0; z < this.zDim; ++z) {
            this.loadZ(z, this.xy[z]);
            this.xyComp[z].updateData((ImageComponent2D.Updater)this.updater, 0, 0, this.xTexSize, this.yTexSize);
        }
        for (int y = 0; y < this.yDim; ++y) {
            this.loadY(y, this.xz[y]);
            this.xzComp[y].updateData((ImageComponent2D.Updater)this.updater, 0, 0, this.xTexSize, this.zTexSize);
        }
        for (int x = 0; x < this.xDim; ++x) {
            this.loadX(x, this.yz[x]);
            this.yzComp[x].updateData((ImageComponent2D.Updater)this.updater, 0, 0, this.yTexSize, this.zTexSize);
        }
    }

    public ImageComponent2D getImageComponentZ(int index) {
        return this.xyComp[index];
    }

    public ImageComponent2D getImageComponentY(int index) {
        return this.xzComp[index];
    }

    public ImageComponent2D getImageComponentX(int index) {
        return this.yzComp[index];
    }

    public void setNoCheckNoUpdate(int x, int y, int z, int v) {
        this.voltexLoader.setNoCheckNoUpdate(x, y, z, v);
    }

    @Override
    public boolean setSaturatedVolumeRendering(boolean b) {
        if (super.setSaturatedVolumeRendering(b) && this.dataType == 0) {
            ((VoltexIntLoader)this.voltexLoader).setLoader((Volume.IntLoader)this.loader);
            this.updateData();
            return true;
        }
        return false;
    }

    @Override
    public boolean setAverage(boolean average) {
        if (super.setAverage(average)) {
            this.initVoltexLoader();
            this.createImageComponents();
            this.updateData();
            return true;
        }
        return false;
    }

    @Override
    public boolean setChannels(boolean[] ch) {
        if (super.setChannels(ch)) {
            this.initVoltexLoader();
            this.createImageComponents();
            this.updateData();
            return true;
        }
        return false;
    }

    @Override
    public boolean setLUTs(int[] r, int[] g, int[] b, int[] a) {
        boolean ret = super.setLUTs(r, g, b, a);
        if (ret) {
            this.initVoltexLoader();
            this.createImageComponents();
        }
        this.updateData();
        return ret;
    }

    @Override
    public boolean setAlphaLUTFullyOpaque() {
        boolean ret = super.setAlphaLUTFullyOpaque();
        if (ret) {
            this.initVoltexLoader();
            this.createImageComponents();
        }
        this.updateData();
        return ret;
    }

    protected void initVoltexLoader() {
        switch (this.dataType) {
            case 1: {
                this.voltexLoader = new VoltexByteLoader((Volume.ByteLoader)this.loader);
                this.compCreator = new GreyComponentCreator();
                break;
            }
            case 0: {
                this.voltexLoader = new VoltexIntLoader((Volume.IntLoader)this.loader);
                this.compCreator = new ColorComponentCreator();
            }
        }
    }

    protected static int powerOfTwo(int value) {
        int retval;
        for (retval = 1; retval < value; retval *= 2) {
        }
        return retval;
    }

    private void loadZ(int z, byte[] dst) {
        this.voltexLoader.loadZ(z, dst);
    }

    private void loadY(int y, byte[] dst) {
        this.voltexLoader.loadY(y, dst);
    }

    private void loadX(int x, byte[] dst) {
        this.voltexLoader.loadX(x, dst);
    }

    private static final ColorModel createGreyColorModel() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    private static final ColorModel createRGBColorModel() {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        return new ComponentColorModel(cs, nBits, true, false, 3, 0);
    }

    static /* synthetic */ ImageComponent2D[] access$302(VoltexVolume x0, ImageComponent2D[] x1) {
        x0.xyComp = x1;
        return x1;
    }

    static /* synthetic */ ImageComponent2D[] access$402(VoltexVolume x0, ImageComponent2D[] x1) {
        x0.xzComp = x1;
        return x1;
    }

    static /* synthetic */ ImageComponent2D[] access$502(VoltexVolume x0, ImageComponent2D[] x1) {
        x0.yzComp = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$602(VoltexVolume x0, byte[][] x1) {
        x0.xy = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$702(VoltexVolume x0, byte[][] x1) {
        x0.xz = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$802(VoltexVolume x0, byte[][] x1) {
        x0.yz = x1;
        return x1;
    }

    private final class VoltexIntLoader
    implements VoltexLoader {
        protected Volume.IntLoader l;

        VoltexIntLoader(Volume.IntLoader l) {
            this.l = l;
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][4 * VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][4 * VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        public void setLoader(Volume.IntLoader l) {
            this.l = l;
        }

        @Override
        public int load(int x, int y, int z) {
            return this.l.load(x, y, z);
        }

        @Override
        public int loadWithLUT(int x, int y, int z) {
            return this.l.load(x, y, z);
        }

        @Override
        public void setNoCheckNoUpdate(int x, int y, int z, int v) {
            this.l.setNoCheck(x, y, z, v);
        }

        @Override
        public void setNoCheck(int x, int y, int z, int v) {
            this.l.setNoCheck(x, y, z, v);
            v = this.l.loadWithLUT(x, y, z);
            int a = (v & 0xFF000000) >> 24;
            int r = (v & 0xFF0000) >> 16;
            int g = (v & 0xFF00) >> 8;
            int b = v & 0xFF;
            int i = 4 * (y * VoltexVolume.this.xTexSize + x);
            ((VoltexVolume)VoltexVolume.this).xy[z][i++] = (byte)r;
            ((VoltexVolume)VoltexVolume.this).xy[z][i++] = (byte)g;
            ((VoltexVolume)VoltexVolume.this).xy[z][i++] = (byte)b;
            ((VoltexVolume)VoltexVolume.this).xy[z][i++] = (byte)a;
            VoltexVolume.this.xyComp[z].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, x, y, 1, 1);
            i = 4 * (z * VoltexVolume.this.xTexSize + x);
            ((VoltexVolume)VoltexVolume.this).xz[y][i++] = (byte)r;
            ((VoltexVolume)VoltexVolume.this).xz[y][i++] = (byte)g;
            ((VoltexVolume)VoltexVolume.this).xz[y][i++] = (byte)b;
            ((VoltexVolume)VoltexVolume.this).xz[y][i++] = (byte)a;
            VoltexVolume.this.xzComp[y].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, x, z, 1, 1);
            i = 4 * (z * VoltexVolume.this.yTexSize + y);
            ((VoltexVolume)VoltexVolume.this).yz[x][i++] = (byte)r;
            ((VoltexVolume)VoltexVolume.this).yz[x][i++] = (byte)g;
            ((VoltexVolume)VoltexVolume.this).yz[x][i++] = (byte)b;
            ((VoltexVolume)VoltexVolume.this).yz[x][i++] = (byte)a;
            VoltexVolume.this.yzComp[x].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, y, z, 1, 1);
        }

        @Override
        public void set(int x, int y, int z, int v) {
            if (x >= 0 && x < VoltexVolume.this.xDim && y >= 0 && y < VoltexVolume.this.yDim && z >= 0 && z < VoltexVolume.this.zDim) {
                this.setNoCheck(x, y, z, v);
            }
        }

        @Override
        public void loadZ(int zValue, byte[] dst) {
            for (int y = 0; y < VoltexVolume.this.yDim; ++y) {
                int offsDst = y * VoltexVolume.this.xTexSize * 4;
                for (int x = 0; x < VoltexVolume.this.xDim; ++x) {
                    int c = this.l.loadWithLUT(x, y, zValue);
                    int a = (c & 0xFF000000) >> 24;
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    dst[offsDst++] = (byte)r;
                    dst[offsDst++] = (byte)g;
                    dst[offsDst++] = (byte)b;
                    dst[offsDst++] = (byte)a;
                }
            }
        }

        @Override
        public void loadY(int yValue, byte[] dst) {
            for (int z = 0; z < VoltexVolume.this.zDim; ++z) {
                int offsDst = z * VoltexVolume.this.xTexSize * 4;
                for (int x = 0; x < VoltexVolume.this.xDim; ++x) {
                    int c = this.l.loadWithLUT(x, yValue, z);
                    int a = (c & 0xFF000000) >> 24;
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    dst[offsDst++] = (byte)r;
                    dst[offsDst++] = (byte)g;
                    dst[offsDst++] = (byte)b;
                    dst[offsDst++] = (byte)a;
                }
            }
        }

        @Override
        public void loadX(int xValue, byte[] dst) {
            for (int z = 0; z < VoltexVolume.this.zDim; ++z) {
                int offsDst = z * VoltexVolume.this.yTexSize * 4;
                for (int y = 0; y < VoltexVolume.this.yDim; ++y) {
                    int c = this.l.loadWithLUT(xValue, y, z);
                    int a = (c & 0xFF000000) >> 24;
                    int r = (c & 0xFF0000) >> 16;
                    int g = (c & 0xFF00) >> 8;
                    int b = c & 0xFF;
                    dst[offsDst++] = (byte)r;
                    dst[offsDst++] = (byte)g;
                    dst[offsDst++] = (byte)b;
                    dst[offsDst++] = (byte)a;
                }
            }
        }
    }

    private final class VoltexByteLoader
    implements VoltexLoader {
        private final Volume.ByteLoader l;

        public VoltexByteLoader(Volume.ByteLoader l) {
            this.l = l;
            VoltexVolume.access$602(VoltexVolume.this, new byte[VoltexVolume.this.zDim][VoltexVolume.this.xTexSize * VoltexVolume.this.yTexSize]);
            VoltexVolume.access$702(VoltexVolume.this, new byte[VoltexVolume.this.yDim][VoltexVolume.this.xTexSize * VoltexVolume.this.zTexSize]);
            VoltexVolume.access$802(VoltexVolume.this, new byte[VoltexVolume.this.xDim][VoltexVolume.this.yTexSize * VoltexVolume.this.zTexSize]);
        }

        @Override
        public int load(int x, int y, int z) {
            return this.l.load(x, y, z);
        }

        @Override
        public int loadWithLUT(int x, int y, int z) {
            return this.l.load(x, y, z);
        }

        @Override
        public void setNoCheck(int x, int y, int z, int v) {
            this.l.setNoCheck(x, y, z, v);
            v = this.l.loadWithLUT(x, y, z);
            ((VoltexVolume)VoltexVolume.this).xy[z][y * VoltexVolume.this.xTexSize + x] = (byte)v;
            ((VoltexVolume)VoltexVolume.this).xz[y][z * VoltexVolume.this.xTexSize + x] = (byte)v;
            ((VoltexVolume)VoltexVolume.this).yz[x][z * VoltexVolume.this.yTexSize + y] = (byte)v;
            VoltexVolume.this.xyComp[z].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, x, y, 1, 1);
            VoltexVolume.this.xzComp[y].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, x, z, 1, 1);
            VoltexVolume.this.yzComp[x].updateData((ImageComponent2D.Updater)VoltexVolume.this.updater, y, z, 1, 1);
        }

        @Override
        public void setNoCheckNoUpdate(int x, int y, int z, int v) {
            this.l.setNoCheck(x, y, z, v);
        }

        @Override
        public void set(int x, int y, int z, int v) {
            if (x >= 0 && x < VoltexVolume.this.xDim && y >= 0 && y < VoltexVolume.this.yDim && z >= 0 && z < VoltexVolume.this.zDim) {
                this.setNoCheck(x, y, z, v);
            }
        }

        @Override
        public void loadZ(int z, byte[] d) {
            for (int y = 0; y < VoltexVolume.this.yDim; ++y) {
                int offs = y * VoltexVolume.this.xTexSize;
                for (int x = 0; x < VoltexVolume.this.xDim; ++x) {
                    d[offs++] = (byte)this.l.loadWithLUT(x, y, z);
                }
            }
        }

        @Override
        public void loadY(int y, byte[] d) {
            for (int z = 0; z < VoltexVolume.this.zDim; ++z) {
                int offs = z * VoltexVolume.this.xTexSize;
                for (int x = 0; x < VoltexVolume.this.xDim; ++x) {
                    d[offs++] = (byte)this.l.loadWithLUT(x, y, z);
                }
            }
        }

        @Override
        public void loadX(int x, byte[] d) {
            for (int z = 0; z < VoltexVolume.this.zDim; ++z) {
                int offs = z * VoltexVolume.this.yTexSize;
                for (int y = 0; y < VoltexVolume.this.yDim; ++y) {
                    d[offs++] = (byte)this.l.loadWithLUT(x, y, z);
                }
            }
        }
    }

    protected static interface VoltexLoader
    extends Volume.Loader {
        public void loadZ(int var1, byte[] var2);

        public void loadY(int var1, byte[] var2);

        public void loadX(int var1, byte[] var2);

        public void setNoCheckNoUpdate(int var1, int var2, int var3, int var4);
    }

    private final class ColorComponentCreator
    extends ComponentCreator {
        private ColorComponentCreator() {
        }

        @Override
        ImageComponent2D createImageComponent(byte[] pix, int w, int h) {
            int[] bandOffset = new int[]{0, 1, 2, 3};
            DataBufferByte db = new DataBufferByte(pix, w * h * 4, 0);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bandOffset, null);
            BufferedImage bImage = new BufferedImage(rgbCM, raster, false, null);
            ImageComponent2D bComp = new ImageComponent2D(2, w, h, true, true);
            bComp.setCapability(3);
            bComp.set(bImage);
            return bComp;
        }
    }

    private final class GreyComponentCreator
    extends ComponentCreator {
        private GreyComponentCreator() {
        }

        @Override
        ImageComponent2D createImageComponent(byte[] pix, int w, int h) {
            DataBufferByte db = new DataBufferByte(pix, w * h, 0);
            SampleModel smod = greyCM.createCompatibleSampleModel(w, h);
            WritableRaster raster = Raster.createWritableRaster(smod, db, null);
            BufferedImage bImage = new BufferedImage(greyCM, raster, false, null);
            ImageComponent2D bComp = new ImageComponent2D(10, w, h, true, true);
            bComp.setCapability(3);
            bComp.set(bImage);
            return bComp;
        }
    }

    private abstract class ComponentCreator {
        ComponentCreator() {
            VoltexVolume.access$302(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.zDim]);
            VoltexVolume.access$402(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.yDim]);
            VoltexVolume.access$502(VoltexVolume.this, new ImageComponent2D[VoltexVolume.this.xDim]);
        }

        abstract ImageComponent2D createImageComponent(byte[] var1, int var2, int var3);
    }

    private class ImageUpdater
    implements ImageComponent2D.Updater {
        private ImageUpdater() {
        }

        public void updateData(ImageComponent2D comp, int x, int y, int w, int h) {
        }
    }
}

