/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.InlineImageInfo;
import com.itextpdf.text.pdf.parser.MarkedContentInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.Vector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageRenderInfo {
    private final GraphicsState gs;
    private final PdfIndirectReference ref;
    private final InlineImageInfo inlineImageInfo;
    private final PdfDictionary colorSpaceDictionary;
    private PdfImageObject imageObject = null;
    private final Collection<MarkedContentInfo> markedContentInfos;

    private ImageRenderInfo(GraphicsState gs, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary, Collection<MarkedContentInfo> markedContentInfo) {
        this.gs = gs;
        this.ref = ref;
        this.inlineImageInfo = null;
        this.colorSpaceDictionary = colorSpaceDictionary;
        this.markedContentInfos = new ArrayList<MarkedContentInfo>();
        if (markedContentInfo != null) {
            this.markedContentInfos.addAll(markedContentInfo);
        }
    }

    private ImageRenderInfo(GraphicsState gs, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary, Collection<MarkedContentInfo> markedContentInfo) {
        this.gs = gs;
        this.ref = null;
        this.inlineImageInfo = inlineImageInfo;
        this.colorSpaceDictionary = colorSpaceDictionary;
        this.markedContentInfos = new ArrayList<MarkedContentInfo>();
        if (markedContentInfo != null) {
            this.markedContentInfos.addAll(markedContentInfo);
        }
    }

    public static ImageRenderInfo createForXObject(GraphicsState gs, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary) {
        return new ImageRenderInfo(gs, ref, colorSpaceDictionary, null);
    }

    public static ImageRenderInfo createForXObject(GraphicsState gs, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary, Collection<MarkedContentInfo> markedContentInfo) {
        return new ImageRenderInfo(gs, ref, colorSpaceDictionary, markedContentInfo);
    }

    protected static ImageRenderInfo createForEmbeddedImage(GraphicsState gs, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary, Collection<MarkedContentInfo> markedContentInfo) {
        ImageRenderInfo renderInfo = new ImageRenderInfo(gs, inlineImageInfo, colorSpaceDictionary, markedContentInfo);
        return renderInfo;
    }

    public PdfImageObject getImage() throws IOException {
        this.prepareImageObject();
        return this.imageObject;
    }

    private void prepareImageObject() throws IOException {
        if (this.imageObject != null) {
            return;
        }
        if (this.ref != null) {
            PRStream stream = (PRStream)PdfReader.getPdfObject(this.ref);
            this.imageObject = new PdfImageObject(stream, this.colorSpaceDictionary);
        } else if (this.inlineImageInfo != null) {
            this.imageObject = new PdfImageObject(this.inlineImageInfo.getImageDictionary(), this.inlineImageInfo.getSamples(), this.colorSpaceDictionary);
        }
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.gs.ctm);
    }

    public Matrix getImageCTM() {
        return this.gs.ctm;
    }

    public float getArea() {
        return this.gs.ctm.getDeterminant();
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }

    public BaseColor getCurrentFillColor() {
        return this.gs.fillColor;
    }

    public boolean hasMcid(int mcid) {
        return this.hasMcid(mcid, false);
    }

    public boolean hasMcid(int mcid, boolean checkTheTopmostLevelOnly) {
        if (checkTheTopmostLevelOnly) {
            if (this.markedContentInfos instanceof ArrayList) {
                Integer infoMcid = this.getMcid();
                return infoMcid != null ? infoMcid == mcid : false;
            }
        } else {
            for (MarkedContentInfo info : this.markedContentInfos) {
                if (!info.hasMcid() || info.getMcid() != mcid) continue;
                return true;
            }
        }
        return false;
    }

    public Integer getMcid() {
        if (this.markedContentInfos instanceof ArrayList) {
            ArrayList mci = (ArrayList)this.markedContentInfos;
            MarkedContentInfo info = mci.size() > 0 ? (MarkedContentInfo)mci.get(mci.size() - 1) : null;
            return info != null && info.hasMcid() ? Integer.valueOf(info.getMcid()) : null;
        }
        return null;
    }
}

