/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"implode/0"})
public class ImplodeFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputArrayType("implode", in, JsonNodeType.NUMBER);
        StringBuilder builder = new StringBuilder();
        for (JsonNode ch : in) {
            if (ch.canConvertToInt()) {
                builder.append((char)ch.asInt());
                continue;
            }
            throw new JsonQueryException("input to implode() must be a list of codepoints; " + ch.getNodeType() + " found");
        }
        output.emit((JsonNode)new TextNode(builder.toString()), null);
    }
}

