/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;

public class mxStackLayout
extends mxGraphLayout {
    protected boolean horizontal;
    protected int spacing;
    protected int x0;
    protected int y0;
    protected int border;
    protected boolean fill = false;
    protected boolean resizeParent = false;
    protected int wrap = 0;

    public mxStackLayout(mxGraph graph) {
        this(graph, true);
    }

    public mxStackLayout(mxGraph graph, boolean horizontal) {
        this(graph, horizontal, 0);
    }

    public mxStackLayout(mxGraph graph, boolean horizontal, int spacing) {
        this(graph, horizontal, spacing, 0, 0, 0);
    }

    public mxStackLayout(mxGraph graph, boolean horizontal, int spacing, int x0, int y0, int border) {
        super(graph);
        this.horizontal = horizontal;
        this.spacing = spacing;
        this.x0 = x0;
        this.y0 = y0;
        this.border = border;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    @Override
    public void moveCell(Object cell, double x, double y) {
        mxIGraphModel model = this.graph.getModel();
        Object parent = model.getParent(cell);
        boolean horizontal = this.isHorizontal();
        if (cell instanceof mxICell && parent instanceof mxICell) {
            int idx;
            int i = 0;
            double last = 0.0;
            int childCount = model.getChildCount(parent);
            double value = horizontal ? x : y;
            mxCellState pstate = this.graph.getView().getState(parent);
            if (pstate != null) {
                value -= horizontal ? pstate.getX() : pstate.getY();
            }
            for (i = 0; i < childCount; ++i) {
                double tmp;
                mxGeometry bounds;
                Object child = model.getChildAt(parent, i);
                if (child == cell || (bounds = model.getGeometry(child)) == null) continue;
                double d = tmp = horizontal ? bounds.getX() + bounds.getWidth() / 2.0 : bounds.getY() + bounds.getHeight() / 2.0;
                if (last < value && tmp > value) break;
                last = tmp;
            }
            idx = Math.max(0, i - (i > (idx = ((mxICell)parent).getIndex((mxICell)cell)) ? 1 : 0));
            model.add(parent, cell, idx);
        }
    }

    public mxRectangle getContainerSize() {
        return new mxRectangle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object parent) {
        if (parent != null) {
            boolean horizontal = this.isHorizontal();
            mxIGraphModel model = this.graph.getModel();
            mxGeometry pgeo = model.getGeometry(parent);
            if (pgeo == null && model.getParent(parent) == model.getRoot() || parent == this.graph.getView().getCurrentRoot()) {
                mxRectangle tmp = this.getContainerSize();
                pgeo = new mxGeometry(0.0, 0.0, tmp.getWidth(), tmp.getHeight());
            }
            double fillValue = 0.0;
            if (pgeo != null) {
                fillValue = horizontal ? pgeo.getHeight() : pgeo.getWidth();
            }
            fillValue -= (double)(2 * this.spacing + 2 * this.border);
            mxRectangle size = this.graph.getStartSize(parent);
            fillValue -= horizontal ? size.getHeight() : size.getWidth();
            double x0 = (double)this.x0 + size.getWidth() + (double)this.border;
            double y0 = (double)this.y0 + size.getHeight() + (double)this.border;
            model.beginUpdate();
            try {
                double tmp = 0.0;
                mxPoint last = null;
                int childCount = model.getChildCount(parent);
                for (int i = 0; i < childCount; ++i) {
                    mxGeometry geo;
                    Object child = model.getChildAt(parent, i);
                    if (this.isVertexIgnored(child) || !this.isVertexMovable(child) || (geo = model.getGeometry(child)) == null) continue;
                    geo = (mxGeometry)geo.clone();
                    if (this.wrap != 0 && last != null && (horizontal && last.getX() + ((mxRectangle)last).getWidth() + geo.getWidth() + (double)(2 * this.spacing) > (double)this.wrap || !horizontal && last.getY() + ((mxRectangle)last).getHeight() + geo.getHeight() + (double)(2 * this.spacing) > (double)this.wrap)) {
                        last = null;
                        if (horizontal) {
                            y0 += tmp + (double)this.spacing;
                        } else {
                            x0 += tmp + (double)this.spacing;
                        }
                        tmp = 0.0;
                    }
                    tmp = Math.max(tmp, horizontal ? geo.getHeight() : geo.getWidth());
                    if (last != null) {
                        if (horizontal) {
                            geo.setX(last.getX() + ((mxRectangle)last).getWidth() + (double)this.spacing);
                        } else {
                            geo.setY(last.getY() + ((mxRectangle)last).getHeight() + (double)this.spacing);
                        }
                    } else if (horizontal) {
                        geo.setX(x0);
                    } else {
                        geo.setY(y0);
                    }
                    if (horizontal) {
                        geo.setY(y0);
                    } else {
                        geo.setX(x0);
                    }
                    if (this.fill && fillValue > 0.0) {
                        if (horizontal) {
                            geo.setHeight(fillValue);
                        } else {
                            geo.setWidth(fillValue);
                        }
                    }
                    model.setGeometry(child, geo);
                    last = geo;
                }
                if (this.resizeParent && pgeo != null && last != null && !this.graph.isCellCollapsed(parent)) {
                    pgeo = (mxGeometry)pgeo.clone();
                    if (horizontal) {
                        pgeo.setWidth(last.getX() + ((mxRectangle)last).getWidth() + (double)this.spacing);
                    } else {
                        pgeo.setHeight(last.getY() + ((mxRectangle)last).getHeight() + (double)this.spacing);
                    }
                    model.setGeometry(parent, pgeo);
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }
}

