/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.ByteVector;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;

public class ZlibCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to compress");
        }
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        deflater.finish();
        byte[] buf = new byte[8192];
        ByteVector bytes = new ByteVector();
        int r = 0;
        while ((r = deflater.deflate(buf, 0, buf.length)) > 0) {
            bytes.add(buf, 0, r);
        }
        return bytes.toByteArray();
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        InflaterInputStream i = new InflaterInputStream((InputStream)in);
        ByteVector bytes = new ByteVector();
        byte[] buf = new byte[8192];
        int r = 0;
        try {
            while ((r = i.read(buf, 0, buf.length)) > 0) {
                bytes.add(buf, 0, r);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return bytes.toByteArray();
    }
}

