/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.volatiles;

import bdv.img.cache.CreateInvalidVolatileCell;
import bdv.img.cache.VolatileCachedCellImg;
import bdv.util.volatiles.SharedQueue;
import bdv.util.volatiles.VolatileRandomAccessibleIntervalView;
import bdv.util.volatiles.VolatileRandomAccessibleView;
import bdv.util.volatiles.VolatileTypeMatcher;
import bdv.util.volatiles.VolatileViewData;
import java.util.Set;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.Cache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.cache.ref.WeakRefVolatileCache;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.WrappedImg;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;

public class VolatileViews {
    public static <T, V extends Volatile<T>> RandomAccessibleInterval<V> wrapAsVolatile(RandomAccessibleInterval<T> rai) {
        return VolatileViews.wrapAsVolatile(rai, null, null);
    }

    public static <T, V extends Volatile<T>> RandomAccessibleInterval<V> wrapAsVolatile(RandomAccessibleInterval<T> rai, bdv.cache.SharedQueue queue) {
        return VolatileViews.wrapAsVolatile(rai, queue, null);
    }

    public static <T, V extends Volatile<T>> RandomAccessibleInterval<V> wrapAsVolatile(RandomAccessibleInterval<T> rai, bdv.cache.SharedQueue queue, CacheHints hints) {
        VolatileViewData<T, V> viewData = VolatileViews.wrapAsVolatileViewData(rai, queue, hints);
        return new VolatileRandomAccessibleIntervalView<T, V>(viewData);
    }

    public static <T, V extends Volatile<T>> RandomAccessible<V> wrapAsVolatile(RandomAccessible<T> rai) {
        return VolatileViews.wrapAsVolatile(rai, null, null);
    }

    public static <T, V extends Volatile<T>> RandomAccessible<V> wrapAsVolatile(RandomAccessible<T> rai, bdv.cache.SharedQueue queue) {
        return VolatileViews.wrapAsVolatile(rai, queue, null);
    }

    public static <T, V extends Volatile<T>> RandomAccessible<V> wrapAsVolatile(RandomAccessible<T> rai, bdv.cache.SharedQueue queue, CacheHints hints) {
        VolatileViewData<T, V> viewData = VolatileViews.wrapAsVolatileViewData(rai, queue, hints);
        return new VolatileRandomAccessibleView<T, V>(viewData);
    }

    private static <T, V extends Volatile<T>> VolatileViewData<T, V> wrapAsVolatileViewData(RandomAccessible<T> rai, bdv.cache.SharedQueue queue, CacheHints hints) {
        if (rai instanceof CachedCellImg) {
            VolatileViewData<T, V> o;
            VolatileViewData<T, V> viewData = o = VolatileViews.wrapCachedCellImg((CachedCellImg)rai, queue, hints);
            return viewData;
        }
        if (rai instanceof IntervalView) {
            IntervalView view = (IntervalView)rai;
            VolatileViewData sourceData = VolatileViews.wrapAsVolatileViewData(view.getSource(), queue, hints);
            return new VolatileViewData(new IntervalView<V>(sourceData.getImg(), view), sourceData.getCacheControl(), sourceData.getType(), sourceData.getVolatileType());
        }
        if (rai instanceof MixedTransformView) {
            MixedTransformView view = (MixedTransformView)rai;
            VolatileViewData sourceData = VolatileViews.wrapAsVolatileViewData(view.getSource(), queue, hints);
            return new VolatileViewData(new MixedTransformView<V>(sourceData.getImg(), view.getTransformToSource()), sourceData.getCacheControl(), sourceData.getType(), sourceData.getVolatileType());
        }
        if (rai instanceof WrappedImg) {
            return VolatileViews.wrapAsVolatileViewData(((WrappedImg)((Object)rai)).getImg(), queue, hints);
        }
        throw new IllegalArgumentException();
    }

    private static <T extends NativeType<T>, V extends Volatile<T>, A extends DataAccess> VolatileViewData<T, V> wrapCachedCellImg(CachedCellImg<T, A> cachedCellImg, bdv.cache.SharedQueue queue, CacheHints hints) {
        NativeType type = cachedCellImg.createLinkedType();
        CellGrid grid = cachedCellImg.getCellGrid();
        Cache cache = cachedCellImg.getCache();
        Set<AccessFlags> flags = AccessFlags.ofAccess(cachedCellImg.getAccessType());
        if (!flags.contains((Object)AccessFlags.VOLATILE)) {
            throw new IllegalArgumentException("underlying " + CachedCellImg.class.getSimpleName() + " must have volatile access type");
        }
        boolean dirty = flags.contains((Object)AccessFlags.DIRTY);
        Volatile vtype = (Volatile)((Object)VolatileTypeMatcher.getVolatileTypeForType(type));
        if (queue == null) {
            queue = new bdv.cache.SharedQueue(1, 1);
        }
        if (hints == null) {
            hints = new CacheHints(LoadingStrategy.VOLATILE, 0, false);
        }
        VolatileCachedCellImg<NativeType, A> img = VolatileViews.createVolatileCachedCellImg(grid, (NativeType)((Object)vtype), dirty, cache, queue, hints);
        return new VolatileViewData<NativeType, Volatile>(img, queue, type, vtype);
    }

    private static <T extends NativeType<T>, A extends VolatileArrayDataAccess<A>> VolatileCachedCellImg<T, A> createVolatileCachedCellImg(CellGrid grid, T type, boolean dirty, Cache<Long, Cell<A>> cache, bdv.cache.SharedQueue queue, CacheHints hints) {
        CreateInvalidVolatileCell createInvalid = CreateInvalidVolatileCell.get(grid, type, dirty);
        WeakRefVolatileCache volatileCache = new WeakRefVolatileCache(cache, (BlockingFetchQueues)queue, createInvalid);
        VolatileCachedCellImg volatileImg = new VolatileCachedCellImg(grid, type, hints, volatileCache);
        return volatileImg;
    }

    @Deprecated
    public static <T, V extends Volatile<T>> RandomAccessibleInterval<V> wrapAsVolatile(RandomAccessibleInterval<T> rai, SharedQueue queue) {
        return VolatileViews.wrapAsVolatile(rai, (bdv.cache.SharedQueue)queue);
    }

    @Deprecated
    public static <T, V extends Volatile<T>> RandomAccessibleInterval<V> wrapAsVolatile(RandomAccessibleInterval<T> rai, SharedQueue queue, CacheHints hints) {
        return VolatileViews.wrapAsVolatile(rai, (bdv.cache.SharedQueue)queue, hints);
    }

    @Deprecated
    public static <T, V extends Volatile<T>> RandomAccessible<V> wrapAsVolatile(RandomAccessible<T> rai, SharedQueue queue) {
        return VolatileViews.wrapAsVolatile(rai, (bdv.cache.SharedQueue)queue);
    }

    @Deprecated
    public static <T, V extends Volatile<T>> RandomAccessible<V> wrapAsVolatile(RandomAccessible<T> rai, SharedQueue queue, CacheHints hints) {
        return VolatileViews.wrapAsVolatile(rai, (bdv.cache.SharedQueue)queue, hints);
    }
}

