/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.util.MipmapTransforms;
import bdv.viewer.Source;
import bdv.viewer.render.MipmapOrdering;
import java.util.ArrayList;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.realtransform.AffineTransform3D;

public class DefaultMipmapOrdering
implements MipmapOrdering {
    private final Source<?> source;
    private final ArrayList<MipmapOrdering.Level> precomputedLevels;

    public DefaultMipmapOrdering(Source<?> source, boolean createHints, LoadingStrategy renderLoadingStrategy, boolean renderEnqueuToFront, LoadingStrategy prefetchLoadingStrategy, boolean prefetchEnqueuToFront) {
        this.source = source;
        this.precomputedLevels = new ArrayList();
        int numMipmapLevels = source.getNumMipmapLevels();
        int maxLevel = numMipmapLevels - 1;
        for (int level = 0; level < numMipmapLevels; ++level) {
            int priority = maxLevel - level;
            CacheHints renderCacheHints = createHints ? new CacheHints(renderLoadingStrategy, priority, renderEnqueuToFront) : null;
            CacheHints prefetchCacheHints = createHints ? new CacheHints(prefetchLoadingStrategy, priority, prefetchEnqueuToFront) : null;
            this.precomputedLevels.add(new MipmapOrdering.Level(level, 0, 0, renderCacheHints, prefetchCacheHints));
        }
    }

    public DefaultMipmapOrdering(Source<?> source) {
        this(source, false, null, false, null, false);
    }

    @Override
    public MipmapOrdering.MipmapHints getMipmapHints(AffineTransform3D screenTransform, int timepoint, int previousTimepoint) {
        int bestLevel = MipmapTransforms.getBestMipMapLevel(screenTransform, this.source, timepoint);
        int numMipmapLevels = this.source.getNumMipmapLevels();
        int maxLevel = numMipmapLevels - 1;
        boolean renewHintsAfterPaintingOnce = false;
        ArrayList<MipmapOrdering.Level> levels = new ArrayList<MipmapOrdering.Level>();
        if (timepoint != previousTimepoint) {
            levels.add(this.getLevel(bestLevel, 0, 1));
            if (maxLevel != bestLevel) {
                levels.add(this.getLevel(maxLevel, 1, 0));
            }
            renewHintsAfterPaintingOnce = true;
        } else {
            for (int i = bestLevel; i < numMipmapLevels; ++i) {
                levels.add(this.getLevel(i, i, -i));
            }
        }
        return new MipmapOrdering.MipmapHints(levels, renewHintsAfterPaintingOnce);
    }

    private MipmapOrdering.Level getLevel(int mipmapLevel, int renderOrder, int prefetchOrder) {
        MipmapOrdering.Level l = this.precomputedLevels.get(mipmapLevel);
        return new MipmapOrdering.Level(mipmapLevel, renderOrder, prefetchOrder, l.getRenderCacheHints(), l.getPrefetchCacheHints());
    }
}

