/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import bdv.util.BoundedRange;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.animate.SimilarityModel3D;
import bigwarp.BigWarpData;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.transforms.AbstractTransformSolver;
import bigwarp.transforms.MaskedSimRotTransformSolver;
import bigwarp.transforms.MaskedTransformSolver;
import bigwarp.transforms.ModelTransformSolver;
import bigwarp.transforms.TpsTransformSolver;
import bigwarp.transforms.WrappedCoordinateTransform;
import ij.IJ;
import java.util.Arrays;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.MaskedSimilarityTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class BigWarpTransform {
    public static final String TPS = "Thin Plate Spline";
    public static final String AFFINE = "Affine";
    public static final String SIMILARITY = "Similarity";
    public static final String ROTATION = "Rotation";
    public static final String TRANSLATION = "Translation";
    public static final String NO_MASK_INTERP = "NONE";
    public static final String MASK_INTERP = "LINEAR";
    public static final String SIM_MASK_INTERP = "SIMILARITY";
    public static final String ROT_MASK_INTERP = "ROTATION";
    private final int ndims;
    private final LandmarkTableModel tableModel;
    private String transformType;
    private String maskInterpolationType;
    private InvertibleRealTransform currentTransform;
    private double inverseTolerance = 0.5;
    private int maxIterations = 1000;
    private RealRandomAccessible<? extends RealType<?>> lambdaRaw;
    private RealRandomAccessible<? extends RealType<?>> lambda;
    private Converter<? extends RealType<?>, ? extends RealType<?>> lambdaConverter;
    private double lambdaConverterMin;
    private double lambdaConverterMax;
    private AbstractTransformSolver<?> solver;

    public BigWarpTransform(LandmarkTableModel tableModel) {
        this(tableModel, TPS);
    }

    public BigWarpTransform(LandmarkTableModel tableModel, String transformType) {
        this.tableModel = tableModel;
        this.ndims = tableModel.getNumdims();
        this.transformType = transformType;
        this.maskInterpolationType = NO_MASK_INTERP;
        this.updateSolver();
    }

    public void setMaskIntensityBounds(final double min, final double max) {
        this.lambdaConverterMin = min;
        this.lambdaConverterMax = max;
        this.lambdaConverter = new Converter<RealType<?>, RealType<?>>(){

            public void convert(RealType<?> input, RealType<?> output) {
                double v = input.getRealDouble();
                if (v <= min) {
                    output.setZero();
                } else if (v >= max) {
                    output.setOne();
                } else {
                    output.setReal((v - min) / (max - min));
                }
            }
        };
        this.updateLambda();
    }

    public BoundedRange getMaskIntensityBounds() {
        return new BoundedRange(this.lambdaConverterMin, this.lambdaConverterMax, this.lambdaConverterMin, this.lambdaConverterMax);
    }

    protected void updateLambda() {
        this.lambda = this.lambdaConverter != null && !(this.lambdaRaw instanceof PlateauSphericalMaskRealRandomAccessible) ? Converters.convert2(this.lambdaRaw, this.lambdaConverter, DoubleType::new) : this.lambdaRaw;
        if (this.solver instanceof MaskedTransformSolver) {
            ((MaskedTransformSolver)this.solver).setMask(this.lambda);
        } else if (this.solver instanceof MaskedSimRotTransformSolver) {
            ((MaskedSimRotTransformSolver)this.solver).setMask(this.lambda);
        }
    }

    public void setMaskInterpolationType(String maskType) {
        this.maskInterpolationType = maskType;
        this.updateSolver();
    }

    public String getMaskInterpolationType() {
        return this.maskInterpolationType;
    }

    public boolean isMasked() {
        return this.maskInterpolationType.equals(MASK_INTERP) || this.maskInterpolationType.equals(ROT_MASK_INTERP) || this.maskInterpolationType.equals(SIM_MASK_INTERP);
    }

    public AbstractTransformSolver<?> getSolver() {
        return this.solver;
    }

    public void updateSolver() {
        this.solver = this.transformType.equals(TPS) ? new TpsTransformSolver() : new ModelTransformSolver(this.getModelType());
        if (this.maskInterpolationType.equals(MASK_INTERP)) {
            this.solver = new MaskedTransformSolver(this.solver, this.lambda);
        } else if (this.maskInterpolationType.equals(ROT_MASK_INTERP) || this.maskInterpolationType.equals(SIM_MASK_INTERP)) {
            double[] center = new double[3];
            if (this.lambda instanceof PlateauSphericalMaskRealRandomAccessible) {
                ((PlateauSphericalMaskRealRandomAccessible)this.lambda).getCenter().localize(center);
            }
            this.solver = new MaskedSimRotTransformSolver(this.tableModel.getNumdims(), this.solver, this.lambda, center, MaskedSimilarityTransform.Interpolators.valueOf(this.maskInterpolationType));
        }
    }

    public void setInverseTolerance(double inverseTolerance) {
        this.inverseTolerance = inverseTolerance;
    }

    public void setInverseMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getInverseTolerance() {
        return this.inverseTolerance;
    }

    public int getInverseMaxIterations() {
        return this.maxIterations;
    }

    public void setTransformType(String transformType) {
        this.transformType = transformType;
        this.updateSolver();
    }

    public String getTransformType() {
        return this.transformType;
    }

    public RealRandomAccessible<? extends RealType<?>> getLambda() {
        return this.lambda;
    }

    public void setLambda(RealRandomAccessible<? extends RealType<?>> lambda) {
        this.lambdaRaw = lambda;
        this.updateLambda();
    }

    public boolean isNonlinear() {
        return this.getTransformType().equals(TPS);
    }

    public InvertibleRealTransform getTransformation() {
        return this.getTransformation(-1, true);
    }

    public InvertibleRealTransform getTransformation(int index) {
        return this.getTransformation(index, true);
    }

    public InvertibleRealTransform getTransformation(boolean force3D) {
        return this.getTransformation(-1, force3D);
    }

    public InvertibleRealTransform getTransformation(int index, boolean force3D) {
        InvertibleWrapped2DTransformAs3D invXfm = null;
        if (this.transformType.equals(TPS)) {
            WrappedIterativeInvertibleRealTransform tpsXfm = (WrappedIterativeInvertibleRealTransform)this.solver.solve(this.tableModel, index);
            tpsXfm.getOptimzer().setMaxIters(this.maxIterations);
            tpsXfm.getOptimzer().setTolerance(this.inverseTolerance);
            tpsXfm.getOptimzer().setBeta(0.5);
            tpsXfm.getOptimzer().setMaxStep(1000.0);
            invXfm = tpsXfm;
        } else {
            invXfm = (InvertibleWrapped2DTransformAs3D)this.solver.solve(this.tableModel, index);
        }
        if (force3D && this.tableModel.getNumdims() == 2) {
            invXfm = new InvertibleWrapped2DTransformAs3D(invXfm);
        }
        this.currentTransform = invXfm;
        return invXfm;
    }

    public void fitModel(Model<?> model) {
        int numActive = this.tableModel.numActive();
        double[][] mvgPts = new double[this.ndims][numActive];
        double[][] tgtPts = new double[this.ndims][numActive];
        this.tableModel.copyLandmarks(mvgPts, tgtPts);
        double[] w = new double[numActive];
        Arrays.fill(w, 1.0);
        try {
            model.fit(mvgPts, tgtPts, w);
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
        }
    }

    public Model<?> getModelType() {
        if (this.tableModel.getNumdims() == 2) {
            return this.getModel2D();
        }
        return this.getModel3D();
    }

    public AbstractAffineModel3D<?> getModel3D() {
        switch (this.transformType) {
            case "Affine": {
                return new AffineModel3D();
            }
            case "Similarity": {
                return new SimilarityModel3D();
            }
            case "Rotation": {
                return new RigidModel3D();
            }
            case "Translation": {
                return new TranslationModel3D();
            }
        }
        return null;
    }

    public AbstractAffineModel2D<?> getModel2D() {
        switch (this.transformType) {
            case "Affine": {
                return new AffineModel2D();
            }
            case "Similarity": {
                return new SimilarityModel2D();
            }
            case "Rotation": {
                return new RigidModel2D();
            }
            case "Translation": {
                return new TranslationModel2D();
            }
        }
        return null;
    }

    public InvertibleCoordinateTransform getCoordinateTransform() {
        if (!this.transformType.equals(TPS)) {
            WrappedCoordinateTransform wct = (WrappedCoordinateTransform)this.unwrap2d(this.getTransformation());
            return wct.getTransform();
        }
        return null;
    }

    public InvertibleRealTransform unwrap2d(InvertibleRealTransform ixfm) {
        if (ixfm instanceof InvertibleWrapped2DTransformAs3D) {
            return ((InvertibleWrapped2DTransformAs3D)ixfm).getTransform();
        }
        return ixfm;
    }

    public AffineTransform3D affine3d() {
        AffineTransform3D out = new AffineTransform3D();
        if (this.transformType.equals(TPS)) {
            return BigWarpTransform.affine3d(this.getTpsBase(), out);
        }
        if (this.ndims == 2) {
            AbstractAffineModel2D model2d = (AbstractAffineModel2D)this.getCoordinateTransform();
            return BigWarpTransform.affine3d(model2d, out);
        }
        if (this.ndims == 3) {
            AbstractAffineModel3D model3d = (AbstractAffineModel3D)this.getCoordinateTransform();
            return BigWarpTransform.affine3d(model3d, out);
        }
        System.err.println("Only support 2d and 3d transformations.");
        return null;
    }

    public ThinPlateR2LogRSplineKernelTransform getTpsBase() {
        ThinplateSplineTransform tps = this.getTps();
        if (tps == null) {
            return null;
        }
        return tps.getKernelTransform();
    }

    public ThinplateSplineTransform getTps() {
        if (this.transformType.equals(TPS)) {
            WrappedIterativeInvertibleRealTransform wiirt = (WrappedIterativeInvertibleRealTransform)this.unwrap2d(this.getTransformation());
            return (ThinplateSplineTransform)wiirt.getTransform();
        }
        return null;
    }

    public void printAffine() {
        if (IJ.getInstance() != null) {
            IJ.log((String)this.affineToString());
            IJ.log((String)("" + this.affine3d()));
        } else {
            System.out.println(this.affineToString());
            System.out.println(this.affine3d());
        }
    }

    public String transformToString() {
        if (this.currentTransform == null) {
            return "(identity)";
        }
        String s = "";
        s = this.currentTransform instanceof InverseRealTransform ? ((InverseRealTransform)this.currentTransform).toString() : (this.currentTransform instanceof WrappedCoordinateTransform ? ((WrappedCoordinateTransform)this.currentTransform).getTransform().toString() : (this.currentTransform instanceof InvertibleWrapped2DTransformAs3D ? ((InvertibleWrapped2DTransformAs3D)this.currentTransform).toString() : ((WrappedIterativeInvertibleRealTransform)this.currentTransform).getTransform().toString()));
        System.out.println(s);
        return s;
    }

    public String affineToString() {
        String s = "";
        if (this.getTransformType().equals(TPS)) {
            double[][] affine = this.affinePartOfTpsHC();
            for (int r = 0; r < affine.length; ++r) {
                s = s + Arrays.toString(affine[r]).replaceAll("\\[|\\]||\\s", "");
                if (r >= affine.length - 1) continue;
                s = s + "\n";
            }
        } else if (this.currentTransform instanceof WrappedCoordinateTransform) {
            s = ((WrappedCoordinateTransform)this.currentTransform).getTransform().toString();
        }
        return s;
    }

    public double[][] affinePartOfTpsHC() {
        int nr = 3;
        int nc = 4;
        double[][] mtx = null;
        if (this.ndims == 2) {
            nr = 2;
            nc = 3;
            mtx = new double[2][3];
        } else {
            mtx = new double[3][4];
        }
        ThinPlateR2LogRSplineKernelTransform tps = this.getTpsBase();
        double[][] tpsAffine = tps.getAffine();
        double[] translation = tps.getTranslation();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                mtx[r][c] = c == nc - 1 ? translation[r] : (r == c ? 1.0 + tpsAffine[r][c] : tpsAffine[r][c]);
            }
        }
        return mtx;
    }

    public AffineGet affinePartOfTps() {
        AffineTransform2D affine = null;
        double[][] affineArray = this.affinePartOfTpsHC();
        if (affineArray.length == 2) {
            AffineTransform2D affine2d = new AffineTransform2D();
            affine2d.set(affineArray);
            affine = affine2d;
        } else {
            AffineTransform3D affine3d = new AffineTransform3D();
            affine3d.set(affineArray);
            affine = affine3d;
        }
        return affine;
    }

    public void initializeInverseParameters(BigWarpData<?> bwData) {
        int N = bwData.numTargetSources();
        double highestResDim = 1.0;
        for (int i = 0; i < N; ++i) {
            SourceAndConverter<?> src = bwData.getTargetSource(i);
            String name = src.getSpimSource().getName();
            if (name.equals("WarpMagnitudeSource") || name.equals("JacobianDeterminantSource") || name.equals("GridSource")) continue;
            AffineTransform3D xfm = new AffineTransform3D();
            src.getSpimSource().getSourceTransform(0, 0, xfm);
            double val = xfm.get(0, 0);
            highestResDim = val > highestResDim ? val : highestResDim;
            val = xfm.get(1, 1);
            highestResDim = val > highestResDim ? val : highestResDim;
            val = xfm.get(2, 2);
            highestResDim = val > highestResDim ? val : highestResDim;
        }
        this.setInverseTolerance(0.5 * highestResDim);
    }

    public static AffineTransform3D affine3d(AbstractAffineModel2D model2d, AffineTransform3D out) {
        double[][] mtx = new double[2][3];
        model2d.toMatrix(mtx);
        double[] affine = new double[12];
        affine[0] = mtx[0][0];
        affine[1] = mtx[0][1];
        affine[3] = mtx[0][2];
        affine[4] = mtx[1][0];
        affine[5] = mtx[1][1];
        affine[7] = mtx[1][2];
        affine[10] = 1.0;
        out.set(affine);
        return out;
    }

    public static AffineTransform2D affine2d(AbstractAffineModel2D model2d, AffineTransform2D out) {
        double[][] mtx = new double[2][3];
        model2d.toMatrix(mtx);
        double[] affine = new double[]{mtx[0][0], mtx[0][1], mtx[0][2], mtx[1][0], mtx[1][1], mtx[1][2]};
        out.set(affine);
        return out;
    }

    public static AffineTransform3D affine3d(AbstractAffineModel3D model3d, AffineTransform3D out) {
        double[][] mtx = new double[3][4];
        model3d.toMatrix(mtx);
        double[] affine = new double[]{mtx[0][0], mtx[0][1], mtx[0][2], mtx[0][3], mtx[1][0], mtx[1][1], mtx[1][2], mtx[1][3], mtx[2][0], mtx[2][1], mtx[2][2], mtx[2][3]};
        out.set(affine);
        return out;
    }

    public static AffineTransform3D affine3d(ThinPlateR2LogRSplineKernelTransform tps, AffineTransform3D out) {
        double[][] tpsAffine = tps.getAffine();
        double[] translation = tps.getTranslation();
        int ndims = tps.getNumDims();
        double[] affine = new double[12];
        if (ndims == 2) {
            affine[0] = 1.0 + tpsAffine[0][0];
            affine[1] = tpsAffine[0][1];
            affine[3] = translation[0];
            affine[4] = tpsAffine[1][0];
            affine[5] = 1.0 + tpsAffine[1][1];
            affine[7] = translation[1];
            affine[10] = 1.0;
        } else {
            affine[0] = 1.0 + tpsAffine[0][0];
            affine[1] = tpsAffine[0][1];
            affine[2] = tpsAffine[0][2];
            affine[3] = translation[0];
            affine[4] = tpsAffine[1][0];
            affine[5] = 1.0 + tpsAffine[1][1];
            affine[6] = tpsAffine[1][2];
            affine[7] = translation[1];
            affine[8] = tpsAffine[2][0];
            affine[9] = tpsAffine[2][1];
            affine[10] = 1.0 + tpsAffine[2][2];
            affine[11] = translation[2];
        }
        out.set(affine);
        return out;
    }

    public AffineGet toImglib2(Model<?> model) {
        if (this.tableModel.getNumdims() == 2) {
            return BigWarpTransform.toAffine2D((AbstractAffineModel2D)model);
        }
        return BigWarpTransform.toAffine3D((AbstractAffineModel3D)model);
    }

    public static AffineGet toAffine2D(AbstractAffineModel2D model) {
        if (model instanceof TranslationModel2D) {
            TranslationModel2D t = (TranslationModel2D)model;
            return new Translation2D(t.getTranslation());
        }
        AffineTransform2D out = new AffineTransform2D();
        return BigWarpTransform.affine2d(model, out);
    }

    public static AffineTransform3D toAffine3D(AbstractAffineModel3D<?> model) {
        return BigWarpTransform.affine3d(model, new AffineTransform3D());
    }
}

