/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.util.AlphanumComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.util.Util;

public class Spot
extends AbstractEuclideanSpace
implements RealLocalizable,
Comparable<Spot> {
    public static AtomicInteger IDcounter = new AtomicInteger(-1);
    private final ConcurrentHashMap<String, Double> features = new ConcurrentHashMap();
    private String name;
    private final int ID;
    private SpotRoi roi;
    public static final String QUALITY = "QUALITY";
    public static final String RADIUS = "RADIUS";
    public static final String POSITION_X = "POSITION_X";
    public static final String POSITION_Y = "POSITION_Y";
    public static final String POSITION_Z = "POSITION_Z";
    public static final String POSITION_T = "POSITION_T";
    public static final String FRAME = "FRAME";
    public static final String[] POSITION_FEATURES = new String[]{"POSITION_X", "POSITION_Y", "POSITION_Z"};
    public static final Collection<String> FEATURES = new ArrayList<String>(7);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(7);
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(7);
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(7);
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(7);
    public static final Comparator<Spot> timeComparator;
    public static final Comparator<Spot> frameComparator;
    public static final Comparator<Spot> nameComparator;

    public Spot(double x, double y, double z, double radius, double quality, String name) {
        super(3);
        this.ID = IDcounter.incrementAndGet();
        this.putFeature(POSITION_X, x);
        this.putFeature(POSITION_Y, y);
        this.putFeature(POSITION_Z, z);
        this.putFeature(RADIUS, radius);
        this.putFeature(QUALITY, quality);
        this.name = null == name ? "ID" + this.ID : name;
    }

    public Spot(double x, double y, double z, double radius, double quality) {
        this(x, y, z, radius, quality, null);
    }

    public Spot(RealLocalizable location, double radius, double quality, String name) {
        this(location.getDoublePosition(0), location.getDoublePosition(1), location.getDoublePosition(2), radius, quality, name);
    }

    public Spot(RealLocalizable location, double radius, double quality) {
        this(location, radius, quality, null);
    }

    public Spot(Spot spot) {
        this(spot, spot.getFeature(RADIUS), spot.getFeature(QUALITY), spot.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Spot(int ID) {
        super(3);
        this.ID = ID;
        AtomicInteger atomicInteger = IDcounter;
        synchronized (atomicInteger) {
            if (IDcounter.get() < ID) {
                IDcounter.set(ID);
            }
        }
    }

    public int hashCode() {
        return this.ID;
    }

    @Override
    public int compareTo(Spot o) {
        return this.ID - o.ID;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Spot)) {
            return false;
        }
        Spot os = (Spot)other;
        return os.ID == this.ID;
    }

    public void setRoi(SpotRoi roi) {
        this.roi = roi;
    }

    public SpotRoi getRoi() {
        return this.roi;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int ID() {
        return this.ID;
    }

    public String toString() {
        String str = null == this.name || this.name.equals("") ? "ID" + this.ID : this.name;
        return str;
    }

    public String echo() {
        StringBuilder s = new StringBuilder();
        if (null == this.name) {
            s.append("Spot: <no name>\n");
        } else {
            s.append("Spot: " + this.name + "\n");
        }
        s.append("Time: " + this.getFeature(POSITION_T) + '\n');
        double[] coordinates = new double[3];
        this.localize(coordinates);
        s.append("Position: " + Util.printCoordinates((double[])coordinates) + "\n");
        if (null == this.features || this.features.size() < 1) {
            s.append("No features calculated\n");
        } else {
            s.append("Feature list:\n");
            for (String key : this.features.keySet()) {
                s.append("\t" + key.toString() + ": ");
                double val = this.features.get(key);
                if (val >= 10000.0) {
                    s.append(String.format("%.1g", val));
                } else {
                    s.append(String.format("%.1f", val));
                }
                s.append('\n');
            }
        }
        return s.toString();
    }

    public Map<String, Double> getFeatures() {
        return this.features;
    }

    public Double getFeature(String feature) {
        return this.features.get(feature);
    }

    public void putFeature(String feature, Double value) {
        this.features.put(feature, value);
    }

    public void copyFeatures(Spot src, Map<String, Double> features) {
        if (null == features || features.isEmpty()) {
            return;
        }
        for (String feat : features.keySet()) {
            this.putFeature(feat, src.getFeature(feat));
        }
    }

    public double diffTo(Spot s, String feature) {
        double f1 = this.features.get(feature);
        double f2 = s.getFeature(feature);
        return f1 - f2;
    }

    public double normalizeDiffTo(Spot s, String feature) {
        double b;
        double a = this.features.get(feature);
        if (a == -(b = s.getFeature(feature).doubleValue())) {
            return 0.0;
        }
        return Math.abs(a - b) / ((a + b) / 2.0);
    }

    public double squareDistanceTo(RealLocalizable s) {
        double sumSquared = 0.0;
        for (int d = 0; d < 3; ++d) {
            double dx = this.getDoublePosition(d) - s.getDoublePosition(d);
            sumSquared += dx * dx;
        }
        return sumSquared;
    }

    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    public float getFloatPosition(int d) {
        return (float)this.getDoublePosition(d);
    }

    public double getDoublePosition(int d) {
        return this.getFeature(POSITION_FEATURES[d]);
    }

    public static final Comparator<Spot> featureComparator(final String feature) {
        Comparator<Spot> comparator = new Comparator<Spot>(){

            @Override
            public int compare(Spot o1, Spot o2) {
                double diff = o2.diffTo(o1, feature);
                if (diff == 0.0) {
                    return 0;
                }
                if (diff < 0.0) {
                    return 1;
                }
                return -1;
            }
        };
        return comparator;
    }

    static {
        FEATURES.add(QUALITY);
        FEATURES.add(POSITION_X);
        FEATURES.add(POSITION_Y);
        FEATURES.add(POSITION_Z);
        FEATURES.add(POSITION_T);
        FEATURES.add(FRAME);
        FEATURES.add(RADIUS);
        FEATURES.add("VISIBILITY");
        FEATURE_NAMES.put(POSITION_X, "X");
        FEATURE_NAMES.put(POSITION_Y, "Y");
        FEATURE_NAMES.put(POSITION_Z, "Z");
        FEATURE_NAMES.put(POSITION_T, "T");
        FEATURE_NAMES.put(FRAME, "Frame");
        FEATURE_NAMES.put(RADIUS, "Radius");
        FEATURE_NAMES.put(QUALITY, "Quality");
        FEATURE_NAMES.put("VISIBILITY", "Visibility");
        FEATURE_SHORT_NAMES.put(POSITION_X, "X");
        FEATURE_SHORT_NAMES.put(POSITION_Y, "Y");
        FEATURE_SHORT_NAMES.put(POSITION_Z, "Z");
        FEATURE_SHORT_NAMES.put(POSITION_T, "T");
        FEATURE_SHORT_NAMES.put(FRAME, "Frame");
        FEATURE_SHORT_NAMES.put(RADIUS, "R");
        FEATURE_SHORT_NAMES.put(QUALITY, "Quality");
        FEATURE_SHORT_NAMES.put("VISIBILITY", "Visibility");
        FEATURE_DIMENSIONS.put(POSITION_X, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(POSITION_Y, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(POSITION_Z, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(POSITION_T, Dimension.TIME);
        FEATURE_DIMENSIONS.put(FRAME, Dimension.NONE);
        FEATURE_DIMENSIONS.put(RADIUS, Dimension.LENGTH);
        FEATURE_DIMENSIONS.put(QUALITY, Dimension.QUALITY);
        FEATURE_DIMENSIONS.put("VISIBILITY", Dimension.NONE);
        IS_INT.put(POSITION_X, Boolean.FALSE);
        IS_INT.put(POSITION_Y, Boolean.FALSE);
        IS_INT.put(POSITION_Z, Boolean.FALSE);
        IS_INT.put(POSITION_T, Boolean.FALSE);
        IS_INT.put(FRAME, Boolean.TRUE);
        IS_INT.put(RADIUS, Boolean.FALSE);
        IS_INT.put(QUALITY, Boolean.FALSE);
        IS_INT.put("VISIBILITY", Boolean.TRUE);
        timeComparator = Spot.featureComparator(POSITION_T);
        frameComparator = Spot.featureComparator(FRAME);
        nameComparator = new Comparator<Spot>(){
            private final Comparator<String> comparator = AlphanumComparator.instance;

            @Override
            public int compare(Spot o1, Spot o2) {
                return this.comparator.compare(o1.getName(), o2.getName());
            }
        };
    }
}

