/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CaptureOverlayPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int firstFrame;
    private int lastFrame;
    private boolean hideImage;
    private boolean whiteBackground;

    public CaptureOverlayPanel(int firstFrame, int lastFrame, boolean hideImage, boolean whiteBackground) {
        this.firstFrame = firstFrame;
        this.lastFrame = lastFrame;
        this.hideImage = hideImage;
        this.whiteBackground = whiteBackground;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblFirstFrame = new JLabel("First frame:");
        GridBagConstraints gbcLblFirstFrame = new GridBagConstraints();
        gbcLblFirstFrame.anchor = 13;
        gbcLblFirstFrame.insets = new Insets(0, 0, 5, 5);
        gbcLblFirstFrame.gridx = 0;
        gbcLblFirstFrame.gridy = 0;
        this.add((Component)lblFirstFrame, gbcLblFirstFrame);
        JFormattedTextField tftFirst = new JFormattedTextField(NumberFormat.getIntegerInstance());
        tftFirst.setValue(firstFrame);
        tftFirst.setColumns(5);
        GridBagConstraints gbcTftFirst = new GridBagConstraints();
        gbcTftFirst.anchor = 11;
        gbcTftFirst.insets = new Insets(0, 0, 5, 0);
        gbcTftFirst.fill = 2;
        gbcTftFirst.gridx = 1;
        gbcTftFirst.gridy = 0;
        this.add((Component)tftFirst, gbcTftFirst);
        JLabel lblLastFrame = new JLabel("Last frame:");
        GridBagConstraints gbcLblLastFrame = new GridBagConstraints();
        gbcLblLastFrame.anchor = 13;
        gbcLblLastFrame.insets = new Insets(0, 0, 5, 5);
        gbcLblLastFrame.gridx = 0;
        gbcLblLastFrame.gridy = 1;
        this.add((Component)lblLastFrame, gbcLblLastFrame);
        JFormattedTextField tftLast = new JFormattedTextField(NumberFormat.getIntegerInstance());
        tftLast.setValue(lastFrame);
        tftLast.setColumns(5);
        GridBagConstraints gbcTftLast = new GridBagConstraints();
        gbcTftLast.insets = new Insets(0, 0, 5, 0);
        gbcTftLast.fill = 2;
        gbcTftLast.gridx = 1;
        gbcTftLast.gridy = 1;
        this.add((Component)tftLast, gbcTftLast);
        JLabel lblHideImage = new JLabel("Hide image:");
        GridBagConstraints gbcLblHideImage = new GridBagConstraints();
        gbcLblHideImage.anchor = 13;
        gbcLblHideImage.insets = new Insets(0, 0, 5, 5);
        gbcLblHideImage.gridx = 0;
        gbcLblHideImage.gridy = 2;
        this.add((Component)lblHideImage, gbcLblHideImage);
        JCheckBox chckbxHideImage = new JCheckBox();
        chckbxHideImage.setSelected(hideImage);
        GridBagConstraints gbcChckbxHideImage = new GridBagConstraints();
        gbcChckbxHideImage.anchor = 17;
        gbcChckbxHideImage.insets = new Insets(0, 0, 5, 0);
        gbcChckbxHideImage.gridx = 1;
        gbcChckbxHideImage.gridy = 2;
        this.add((Component)chckbxHideImage, gbcChckbxHideImage);
        JLabel lblWhiteBackground = new JLabel("White background:");
        lblWhiteBackground.setEnabled(hideImage);
        GridBagConstraints gbcLblWhiteBackground = new GridBagConstraints();
        gbcLblWhiteBackground.anchor = 13;
        gbcLblWhiteBackground.insets = new Insets(0, 0, 5, 5);
        gbcLblWhiteBackground.gridx = 0;
        gbcLblWhiteBackground.gridy = 3;
        this.add((Component)lblWhiteBackground, gbcLblWhiteBackground);
        JCheckBox chckbxWhiteBackground = new JCheckBox();
        chckbxWhiteBackground.setSelected(whiteBackground);
        chckbxWhiteBackground.setEnabled(hideImage);
        GridBagConstraints gbcChckbxWhiteBackground = new GridBagConstraints();
        gbcChckbxWhiteBackground.anchor = 17;
        gbcChckbxWhiteBackground.insets = new Insets(0, 0, 5, 0);
        gbcChckbxWhiteBackground.gridx = 1;
        gbcChckbxWhiteBackground.gridy = 3;
        this.add((Component)chckbxWhiteBackground, gbcChckbxWhiteBackground);
        FocusAdapter fl = new FocusAdapter(){

            @Override
            public void focusGained(final FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JFormattedTextField)e.getSource()).selectAll();
                    }
                });
            }
        };
        tftFirst.addFocusListener(fl);
        tftLast.addFocusListener(fl);
        tftFirst.addPropertyChangeListener("value", e -> {
            this.firstFrame = ((Number)tftFirst.getValue()).intValue();
        });
        tftLast.addPropertyChangeListener("value", e -> {
            this.lastFrame = ((Number)tftLast.getValue()).intValue();
        });
        chckbxHideImage.addActionListener(e -> {
            this.hideImage = chckbxHideImage.isSelected();
            chckbxWhiteBackground.setEnabled(this.hideImage);
            lblWhiteBackground.setEnabled(this.hideImage);
        });
        chckbxWhiteBackground.addActionListener(e -> {
            this.whiteBackground = chckbxWhiteBackground.isSelected();
        });
    }

    public int getFirstFrame() {
        return this.firstFrame;
    }

    public int getLastFrame() {
        return this.lastFrame;
    }

    public boolean isHideImage() {
        return this.hideImage;
    }

    public boolean isWhiteBackground() {
        return this.whiteBackground;
    }
}

