/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.detection.SpotDetectorFactoryBase;
import fiji.plugin.trackmate.detection.util.MedianFilter2D;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.localextrema.LocalExtrema;
import net.imglib2.algorithm.localextrema.RefinedPeak;
import net.imglib2.algorithm.localextrema.SubpixelLocalization;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.thread.ThreadService;

public class DetectionUtils {
    public static final void preview(Model model, Settings settings, SpotDetectorFactoryBase<?> detectorFactory, Map<String, Object> detectorSettings, int frame, Logger logger, Consumer<Boolean> buttonEnabler) {
        buttonEnabler.accept(false);
        Threads.run("TrackMate preview detection thread", () -> {
            try {
                Settings lSettings = new Settings(settings.imp);
                lSettings.tstart = frame;
                lSettings.tend = frame;
                settings.setRoi(settings.imp.getRoi());
                lSettings.detectorFactory = detectorFactory;
                lSettings.detectorSettings = detectorSettings;
                TrackMate trackmate = new TrackMate(lSettings);
                trackmate.getModel().setLogger(logger);
                boolean detectionOk = trackmate.execDetection();
                if (!detectionOk) {
                    logger.error(trackmate.getErrorMessage());
                    return;
                }
                logger.log("Found " + trackmate.getModel().getSpots().getNSpots(false) + " spots.");
                SpotCollection newspots = trackmate.getModel().getSpots();
                Iterator<Spot> it = newspots.iterator(frame, false);
                ArrayList<Spot> spotsToCopy = new ArrayList<Spot>(newspots.getNSpots(frame, false));
                while (it.hasNext()) {
                    spotsToCopy.add(it.next());
                }
                model.getSpots().put(frame, spotsToCopy);
                for (Spot spot : spotsToCopy) {
                    spot.putFeature("VISIBILITY", SpotCollection.ONE);
                }
                model.setSpots(model.getSpots(), true);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
            finally {
                buttonEnabler.accept(true);
            }
        });
    }

    public static final boolean is2D(ImgPlus<?> img) {
        return img.dimensionIndex(Axes.Z) < 0 || img.dimension(img.dimensionIndex(Axes.Z)) <= 1L;
    }

    public static final boolean is2D(ImagePlus imp) {
        return imp == null ? true : imp.getNSlices() <= 1;
    }

    public static final Img<FloatType> createLoGKernel(double radius, int nDims, double[] calibration) {
        double sigma = radius / Math.sqrt(nDims);
        double[] sigmaPixels = new double[nDims];
        for (int i = 0; i < sigmaPixels.length; ++i) {
            sigmaPixels[i] = sigma / calibration[i];
        }
        int n = sigmaPixels.length;
        long[] sizes = new long[n];
        long[] middle = new long[n];
        for (int d = 0; d < n; ++d) {
            int hksizes = Math.max(2, (int)(3.0 * sigmaPixels[d] + 0.5) + 1);
            sizes[d] = 3 + 2 * hksizes;
            middle[d] = 1 + hksizes;
        }
        ArrayImg kernel = ArrayImgs.floats((long[])sizes);
        ArrayCursor c = kernel.cursor();
        long[] coords = new long[nDims];
        while (c.hasNext()) {
            c.fwd();
            c.localize(coords);
            double sumx2 = 0.0;
            double mantissa = 0.0;
            for (int d = 0; d < coords.length; ++d) {
                double x = calibration[d] * (double)(coords[d] - middle[d]);
                sumx2 += x * x;
                mantissa += 1.0 / sigmaPixels[d] / sigmaPixels[d] * (x * x / sigma / sigma - 1.0);
            }
            double exponent = -sumx2 / 2.0 / sigma / sigma;
            double C = 0.3183098861837907 / sigmaPixels[0] / sigmaPixels[0];
            ((FloatType)c.get()).setReal(-C * mantissa * Math.exp(exponent));
        }
        return kernel;
    }

    public static final <T extends RealType<T>> Img<FloatType> copyToFloatImg(RandomAccessible<T> img, Interval interval, ImgFactory<FloatType> factory) {
        Img output = factory.create((Dimensions)interval);
        RandomAccess in = Views.zeroMin((RandomAccessibleInterval)Views.interval(img, (Interval)interval)).randomAccess();
        Cursor out = output.cursor();
        RealFloatConverter c = new RealFloatConverter();
        while (out.hasNext()) {
            out.fwd();
            in.setPosition((Localizable)out);
            c.convert((RealType)in.get(), (FloatType)out.get());
        }
        return output;
    }

    public static final Interval squeeze(Interval interval) {
        int nNonSingletonDimensions;
        for (int d = nNonSingletonDimensions = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) <= 1L) continue;
            ++nNonSingletonDimensions;
        }
        long[] min = new long[nNonSingletonDimensions];
        long[] max = new long[nNonSingletonDimensions];
        int index = 0;
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) <= 1L) continue;
            min[index] = interval.min(d);
            max[index] = interval.max(d);
            ++index;
        }
        return new FinalInterval(min, max);
    }

    public static final <R extends RealType<R> & NativeType<R>> Img<R> applyMedianFilter(RandomAccessibleInterval<R> image) {
        MedianFilter2D<R> medFilt = new MedianFilter2D<R>(image, 1);
        if (!medFilt.checkInput() || !medFilt.process()) {
            return null;
        }
        return medFilt.getResult();
    }

    public static final <T extends RealType<T>> List<Spot> findLocalMaxima(RandomAccessibleInterval<T> source, double threshold, double[] calibration, double radius, boolean doSubPixelLocalization, int nTasks) {
        ArrayList<Spot> spots;
        List peaks;
        RealType val = (RealType)((RealType)Util.getTypeFromInterval(source)).createVariable();
        val.setReal(threshold);
        LocalExtrema.MaximumCheck localNeighborhoodCheck = new LocalExtrema.MaximumCheck((Comparable)val);
        IntervalView dogWithBorder = Views.interval((RandomAccessible)Views.extendMirrorSingle(source), (Interval)Intervals.expand(source, (long)1L));
        ThreadService threadService = (ThreadService)TMUtils.getContext().getService(ThreadService.class);
        ExecutorService es = threadService == null ? Threads.newCachedThreadPool() : threadService.getExecutorService();
        try {
            peaks = LocalExtrema.findLocalExtrema((RandomAccessibleInterval)dogWithBorder, (LocalExtrema.LocalNeighborhoodCheck)localNeighborhoodCheck, (Shape)new RectangleShape(1, true), (ExecutorService)es, (int)nTasks);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            peaks = Collections.emptyList();
        }
        if (peaks.isEmpty()) {
            return Collections.emptyList();
        }
        if (doSubPixelLocalization) {
            SubpixelLocalization spl = new SubpixelLocalization(source.numDimensions());
            spl.setNumThreads(nTasks);
            spl.setReturnInvalidPeaks(true);
            spl.setCanMoveOutside(true);
            spl.setAllowMaximaTolerance(true);
            spl.setMaxNumMoves(10);
            ArrayList refined = spl.process(peaks, (RandomAccessible)dogWithBorder, source);
            spots = new ArrayList(refined.size());
            RandomAccess ra = source.randomAccess();
            if (source.numDimensions() > 2) {
                for (RefinedPeak refinedPeak : refined) {
                    ra.setPosition(refinedPeak.getOriginalPeak());
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = refinedPeak.getDoublePosition(0) * calibration[0];
                    double y = refinedPeak.getDoublePosition(1) * calibration[1];
                    double z = refinedPeak.getDoublePosition(2) * calibration[2];
                    Spot spot = new Spot(x, y, z, radius, quality);
                    spots.add(spot);
                }
            } else if (source.numDimensions() > 1) {
                double z = 0.0;
                for (RefinedPeak refinedPeak : refined) {
                    ra.setPosition(refinedPeak.getOriginalPeak());
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = refinedPeak.getDoublePosition(0) * calibration[0];
                    double y = refinedPeak.getDoublePosition(1) * calibration[1];
                    Spot spot = new Spot(x, y, 0.0, radius, quality);
                    spots.add(spot);
                }
            } else {
                double z = 0.0;
                double y = 0.0;
                for (RefinedPeak refinedPeak : refined) {
                    ra.setPosition(refinedPeak.getOriginalPeak());
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = refinedPeak.getDoublePosition(0) * calibration[0];
                    Spot spot = new Spot(x, 0.0, 0.0, radius, quality);
                    spots.add(spot);
                }
            }
        } else {
            spots = new ArrayList<Spot>(peaks.size());
            RandomAccess ra = source.randomAccess();
            if (source.numDimensions() > 2) {
                for (Point peak : peaks) {
                    ra.setPosition((Localizable)peak);
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = peak.getDoublePosition(0) * calibration[0];
                    double y = peak.getDoublePosition(1) * calibration[1];
                    double z = peak.getDoublePosition(2) * calibration[2];
                    Spot spot = new Spot(x, y, z, radius, quality);
                    spots.add(spot);
                }
            } else if (source.numDimensions() > 1) {
                double z = 0.0;
                for (Point peak : peaks) {
                    ra.setPosition((Localizable)peak);
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = peak.getDoublePosition(0) * calibration[0];
                    double y = peak.getDoublePosition(1) * calibration[1];
                    Spot spot = new Spot(x, y, 0.0, radius, quality);
                    spots.add(spot);
                }
            } else {
                double z = 0.0;
                double y = 0.0;
                for (Point peak : peaks) {
                    ra.setPosition((Localizable)peak);
                    double quality = ((RealType)ra.get()).getRealDouble();
                    double x = peak.getDoublePosition(0) * calibration[0];
                    Spot spot = new Spot(x, 0.0, 0.0, radius, quality);
                    spots.add(spot);
                }
            }
        }
        return spots;
    }

    public static final <T extends Type<T>> RandomAccessibleInterval<T> prepareFrameImg(ImgPlus<T> img, int channel, int frame) {
        ImgPlus singleTimePoint = img.dimensionIndex(Axes.TIME) < 0 ? img : ImgPlusViews.hyperSlice(img, (int)img.dimensionIndex(Axes.TIME), (long)frame);
        ImgPlus singleChannel = singleTimePoint.dimensionIndex(Axes.CHANNEL) < 0 ? singleTimePoint : ImgPlusViews.hyperSlice((ImgPlus)singleTimePoint, (int)singleTimePoint.dimensionIndex(Axes.CHANNEL), (long)channel);
        return singleChannel;
    }

    public static final <T extends RealType<T>> void normalize(Iterable<T> input) {
        double val;
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.POSITIVE_INFINITY;
        for (RealType d : input) {
            val = d.getRealDouble();
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        for (RealType d : input) {
            val = d.getRealDouble();
            d.setReal((val - min) / (max - min));
        }
    }
}

