/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.jaqaman.JaqamanLinker;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.FeaturePenaltyCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.SquareDistCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.JaqamanLinkingCostMatrixCreator;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Cancelable;

public class SparseLAPFrameToFrameTracker
extends MultiThreadedBenchmarkAlgorithm
implements SpotTracker,
Cancelable {
    private static final String BASE_ERROR_MESSAGE = "[SparseLAPFrameToFrameTracker] ";
    protected SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;
    protected Logger logger = Logger.VOID_LOGGER;
    protected final SpotCollection spots;
    protected final Map<String, Object> settings;
    private boolean isCanceled;
    private String cancelReason;

    public SparseLAPFrameToFrameTracker(SpotCollection spots, Map<String, Object> settings) {
        this.spots = spots;
        this.settings = settings;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        this.isCanceled = false;
        this.cancelReason = null;
        if (null == this.spots) {
            this.errorMessage = "[SparseLAPFrameToFrameTracker] The spot collection is null.";
            return false;
        }
        if (this.spots.keySet().isEmpty()) {
            this.errorMessage = "[SparseLAPFrameToFrameTracker] The spot collection is empty.";
            return false;
        }
        boolean empty = true;
        for (int frame : this.spots.keySet()) {
            if (this.spots.getNSpots(frame, true) <= 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            this.errorMessage = "[SparseLAPFrameToFrameTracker] The spot collection is empty.";
            return false;
        }
        StringBuilder errorHolder = new StringBuilder();
        if (!this.checkSettingsValidity(this.settings, errorHolder)) {
            this.errorMessage = BASE_ERROR_MESSAGE + errorHolder.toString();
            return false;
        }
        long start = System.currentTimeMillis();
        final ArrayList<int[]> framePairs = new ArrayList<int[]>(this.spots.keySet().size() - 1);
        Iterator<Integer> frameIterator = this.spots.keySet().iterator();
        int frame0 = frameIterator.next();
        while (frameIterator.hasNext()) {
            int frame1 = frameIterator.next();
            framePairs.add(new int[]{frame0, frame1});
            frame0 = frame1;
        }
        Map featurePenalties = (Map)this.settings.get("LINKING_FEATURE_PENALTIES");
        final CostFunction<Spot, Spot> costFunction = this.getCostFunction(featurePenalties);
        Double maxDist = (Double)this.settings.get("LINKING_MAX_DISTANCE");
        final double costThreshold = maxDist * maxDist;
        final double alternativeCostFactor = (Double)this.settings.get("ALTERNATIVE_LINKING_COST_FACTOR");
        this.graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        final AtomicInteger progress = new AtomicInteger(0);
        final AtomicBoolean ok = new AtomicBoolean(true);
        ExecutorService executors = Threads.newFixedThreadPool(this.numThreads);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(framePairs.size());
        for (final int[] nArray : framePairs) {
            Future<Void> future = executors.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    if (!ok.get() || SparseLAPFrameToFrameTracker.this.isCanceled()) {
                        return null;
                    }
                    int lFrame0 = nArray[0];
                    int lFrame1 = nArray[1];
                    ArrayList<Spot> sources = new ArrayList<Spot>(SparseLAPFrameToFrameTracker.this.spots.getNSpots(lFrame0, true));
                    Iterator<Spot> iterator = SparseLAPFrameToFrameTracker.this.spots.iterator(lFrame0, true);
                    while (iterator.hasNext()) {
                        sources.add(iterator.next());
                    }
                    ArrayList<Spot> targets = new ArrayList<Spot>(SparseLAPFrameToFrameTracker.this.spots.getNSpots(lFrame1, true));
                    Iterator<Spot> iterator2 = SparseLAPFrameToFrameTracker.this.spots.iterator(lFrame1, true);
                    while (iterator2.hasNext()) {
                        targets.add(iterator2.next());
                    }
                    if (sources.isEmpty() || targets.isEmpty()) {
                        return null;
                    }
                    JaqamanLinkingCostMatrixCreator creator = new JaqamanLinkingCostMatrixCreator(sources, targets, costFunction, costThreshold, alternativeCostFactor, 1.0);
                    JaqamanLinker linker = new JaqamanLinker(creator);
                    if (!linker.checkInput() || !linker.process()) {
                        SparseLAPFrameToFrameTracker.this.errorMessage = "At frame " + lFrame0 + " to " + lFrame1 + ": " + linker.getErrorMessage();
                        ok.set(false);
                        return null;
                    }
                    SimpleWeightedGraph<Spot, DefaultWeightedEdge> simpleWeightedGraph = SparseLAPFrameToFrameTracker.this.graph;
                    synchronized (simpleWeightedGraph) {
                        Map costs = linker.getAssignmentCosts();
                        Object assignment = linker.getResult();
                        for (Spot source : assignment.keySet()) {
                            double cost = costs.get(source);
                            Spot target = (Spot)assignment.get(source);
                            SparseLAPFrameToFrameTracker.this.graph.addVertex((Object)source);
                            SparseLAPFrameToFrameTracker.this.graph.addVertex((Object)target);
                            DefaultWeightedEdge edge = (DefaultWeightedEdge)SparseLAPFrameToFrameTracker.this.graph.addEdge((Object)source, (Object)target);
                            SparseLAPFrameToFrameTracker.this.graph.setEdgeWeight((Object)edge, cost);
                        }
                    }
                    SparseLAPFrameToFrameTracker.this.logger.setProgress(progress.incrementAndGet() / framePairs.size());
                    return null;
                }
            });
            futures.add(future);
        }
        this.logger.setStatus("Frame to frame linking...");
        try {
            for (Future future : futures) {
                future.get();
            }
            executors.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            ok.set(false);
            this.errorMessage = BASE_ERROR_MESSAGE + e.getMessage();
            e.printStackTrace();
        }
        this.logger.setProgress(1.0);
        this.logger.setStatus("");
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return ok.get();
    }

    protected CostFunction<Spot, Spot> getCostFunction(Map<String, Double> featurePenalties) {
        if (null == featurePenalties || featurePenalties.isEmpty()) {
            return new SquareDistCostFunction();
        }
        return new FeaturePenaltyCostFunction(featurePenalties);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder str) {
        if (null == settings) {
            str.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        ok &= TMUtils.checkParameter(settings, "LINKING_MAX_DISTANCE", Double.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "LINKING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALTERNATIVE_LINKING_COST_FACTOR", Double.class, str);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("LINKING_MAX_DISTANCE");
        mandatoryKeys.add("ALTERNATIVE_LINKING_COST_FACTOR");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        optionalKeys.add("LINKING_FEATURE_PENALTIES");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, str);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void cancel(String reason) {
        this.isCanceled = true;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

