/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman.costmatrix;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.FeaturePenaltyCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.SquareDistCostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.DefaultCostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.GraphSegmentSplitter;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.ResizableDoubleArray;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.imglib2.algorithm.MultiThreaded;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class JaqamanSegmentCostMatrixCreator
implements CostMatrixCreator<Spot, Spot>,
MultiThreaded {
    private static final String BASE_ERROR_MESSAGE = "[JaqamanSegmentCostMatrixCreator] ";
    private final Map<String, Object> settings;
    private String errorMessage;
    private SparseCostMatrix scm;
    private long processingTime;
    private List<Spot> uniqueSources;
    private List<Spot> uniqueTargets;
    private final Graph<Spot, DefaultWeightedEdge> graph;
    private double alternativeCost = -1.0;
    private int numThreads;

    public JaqamanSegmentCostMatrixCreator(Graph<Spot, DefaultWeightedEdge> graph, Map<String, Object> settings) {
        this.graph = graph;
        this.settings = settings;
        this.setNumThreads();
    }

    public boolean checkInput() {
        StringBuilder str = new StringBuilder();
        if (!JaqamanSegmentCostMatrixCreator.checkSettingsValidity(this.settings, str)) {
            this.errorMessage = "[JaqamanSegmentCostMatrixCreator] Incorrect settings map:\n" + str.toString();
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean process() {
        List<Spot> allMiddles;
        long start = System.currentTimeMillis();
        Map gcFeaturePenalties = (Map)this.settings.get("GAP_CLOSING_FEATURE_PENALTIES");
        final CostFunction<Spot, Spot> gcCostFunction = this.getCostFunctionFor(gcFeaturePenalties);
        final int maxFrameInterval = (Integer)this.settings.get("MAX_FRAME_GAP");
        double gcMaxDistance = (Double)this.settings.get("GAP_CLOSING_MAX_DISTANCE");
        final double gcCostThreshold = gcMaxDistance * gcMaxDistance;
        final boolean allowGapClosing = (Boolean)this.settings.get("ALLOW_GAP_CLOSING");
        Map mFeaturePenalties = (Map)this.settings.get("MERGING_FEATURE_PENALTIES");
        final CostFunction<Spot, Spot> mCostFunction = this.getCostFunctionFor(mFeaturePenalties);
        double mMaxDistance = (Double)this.settings.get("MERGING_MAX_DISTANCE");
        final double mCostThreshold = mMaxDistance * mMaxDistance;
        final boolean allowMerging = (Boolean)this.settings.get("ALLOW_TRACK_MERGING");
        Map sFeaturePenalties = (Map)this.settings.get("SPLITTING_FEATURE_PENALTIES");
        final CostFunction<Spot, Spot> sCostFunction = this.getCostFunctionFor(sFeaturePenalties);
        boolean allowSplitting = (Boolean)this.settings.get("ALLOW_TRACK_SPLITTING");
        double sMaxDistance = (Double)this.settings.get("SPLITTING_MAX_DISTANCE");
        final double sCostThreshold = sMaxDistance * sMaxDistance;
        double alternativeCostFactor = (Double)this.settings.get("ALTERNATIVE_LINKING_COST_FACTOR");
        double percentile = (Double)this.settings.get("CUTOFF_PERCENTILE");
        if (!(allowGapClosing || allowSplitting || allowMerging)) {
            this.uniqueSources = Collections.emptyList();
            this.uniqueTargets = Collections.emptyList();
            this.scm = new SparseCostMatrix(new double[0], new int[0], new int[0], 0);
            return true;
        }
        boolean mergingOrSplitting = allowMerging || allowSplitting;
        GraphSegmentSplitter segmentSplitter = new GraphSegmentSplitter(this.graph, mergingOrSplitting);
        List<Spot> segmentEnds = segmentSplitter.getSegmentEnds();
        final List<Spot> segmentStarts = segmentSplitter.getSegmentStarts();
        if (mergingOrSplitting) {
            List<List<Spot>> segmentMiddles = segmentSplitter.getSegmentMiddles();
            allMiddles = new ArrayList<Spot>();
            for (List<Spot> segment : segmentMiddles) {
                allMiddles.addAll(segment);
            }
        } else {
            allMiddles = Collections.emptyList();
        }
        final Object lock = new Object();
        final ArrayList sources = new ArrayList();
        final ArrayList targets = new ArrayList();
        final ResizableDoubleArray linkCosts = new ResizableDoubleArray();
        ExecutorService executorGCM = Threads.newFixedThreadPool(this.numThreads);
        for (final Spot spot : segmentEnds) {
            executorGCM.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    double cost;
                    int tdiff;
                    int targetFrame;
                    int sourceFrame = spot.getFeature("FRAME").intValue();
                    if (allowGapClosing) {
                        for (Spot target : segmentStarts) {
                            targetFrame = target.getFeature("FRAME").intValue();
                            tdiff = targetFrame - sourceFrame;
                            if (tdiff < 1 || tdiff > maxFrameInterval || (cost = gcCostFunction.linkingCost(spot, target)) > gcCostThreshold) continue;
                            object = lock;
                            synchronized (object) {
                                sources.add(spot);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                    if (allowMerging) {
                        for (Spot target : allMiddles) {
                            targetFrame = target.getFeature("FRAME").intValue();
                            tdiff = targetFrame - sourceFrame;
                            if (tdiff != 1 || (cost = mCostFunction.linkingCost(spot, target)) > mCostThreshold) continue;
                            object = lock;
                            synchronized (object) {
                                sources.add(spot);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                }
            });
        }
        executorGCM.shutdown();
        try {
            executorGCM.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.errorMessage = BASE_ERROR_MESSAGE + e.getMessage();
            return false;
        }
        if (allowSplitting) {
            ExecutorService executorS = Threads.newFixedThreadPool(this.numThreads);
            for (final Spot source : allMiddles) {
                executorS.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int sourceFrame = source.getFeature("FRAME").intValue();
                        for (Spot target : segmentStarts) {
                            double cost;
                            int targetFrame = target.getFeature("FRAME").intValue();
                            int tdiff = targetFrame - sourceFrame;
                            if (tdiff != 1 || (cost = sCostFunction.linkingCost(source, target)) > sCostThreshold) continue;
                            Object object = lock;
                            synchronized (object) {
                                sources.add(source);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                });
            }
            executorS.shutdown();
            try {
                executorS.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                this.errorMessage = BASE_ERROR_MESSAGE + interruptedException.getMessage();
            }
        }
        linkCosts.trimToSize();
        if (sources.isEmpty() || targets.isEmpty()) {
            this.uniqueSources = Collections.emptyList();
            this.uniqueTargets = Collections.emptyList();
            this.alternativeCost = Double.NaN;
            this.scm = null;
        } else {
            DefaultCostMatrixCreator creator = new DefaultCostMatrixCreator(sources, targets, linkCosts.data, alternativeCostFactor, percentile);
            if (!creator.checkInput() || !creator.process()) {
                this.errorMessage = "Linking track segments: " + creator.getErrorMessage();
                return false;
            }
            this.alternativeCost = creator.computeAlternativeCosts();
            this.scm = creator.getResult();
            this.uniqueSources = creator.getSourceList();
            this.uniqueTargets = creator.getTargetList();
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    protected CostFunction<Spot, Spot> getCostFunctionFor(Map<String, Double> featurePenalties) {
        CostFunction<Spot, Spot> costFunction = null == featurePenalties || featurePenalties.isEmpty() ? new SquareDistCostFunction() : new FeaturePenaltyCostFunction(featurePenalties);
        return costFunction;
    }

    public SparseCostMatrix getResult() {
        return this.scm;
    }

    @Override
    public List<Spot> getSourceList() {
        return this.uniqueSources;
    }

    @Override
    public List<Spot> getTargetList() {
        return this.uniqueTargets;
    }

    @Override
    public double getAlternativeCostForSource(Spot source) {
        return this.alternativeCost;
    }

    @Override
    public double getAlternativeCostForTarget(Spot target) {
        return this.alternativeCost;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    private static final boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder str) {
        if (null == settings) {
            str.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        ok &= TMUtils.checkParameter(settings, "ALLOW_GAP_CLOSING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "GAP_CLOSING_MAX_DISTANCE", Double.class, str);
        ok &= TMUtils.checkParameter(settings, "MAX_FRAME_GAP", Integer.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "GAP_CLOSING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_SPLITTING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "SPLITTING_MAX_DISTANCE", Double.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "SPLITTING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_MERGING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "MERGING_MAX_DISTANCE", Double.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "MERGING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALTERNATIVE_LINKING_COST_FACTOR", Double.class, str);
        ok &= TMUtils.checkParameter(settings, "CUTOFF_PERCENTILE", Double.class, str);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("ALLOW_GAP_CLOSING");
        mandatoryKeys.add("GAP_CLOSING_MAX_DISTANCE");
        mandatoryKeys.add("MAX_FRAME_GAP");
        mandatoryKeys.add("ALLOW_TRACK_SPLITTING");
        mandatoryKeys.add("SPLITTING_MAX_DISTANCE");
        mandatoryKeys.add("ALLOW_TRACK_MERGING");
        mandatoryKeys.add("MERGING_MAX_DISTANCE");
        mandatoryKeys.add("ALTERNATIVE_LINKING_COST_FACTOR");
        mandatoryKeys.add("CUTOFF_PERCENTILE");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        optionalKeys.add("GAP_CLOSING_FEATURE_PENALTIES");
        optionalKeys.add("SPLITTING_FEATURE_PENALTIES");
        optionalKeys.add("MERGING_FEATURE_PENALTIES");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, str);
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

