/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.graph.TimeDirectedNeighborIndex;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackNavigator {
    private final Model model;
    private final SelectionModel selectionModel;
    private final TimeDirectedNeighborIndex neighborIndex;

    public TrackNavigator(Model model, SelectionModel selectionModel) {
        this.model = model;
        this.selectionModel = selectionModel;
        this.neighborIndex = model.getTrackModel().getDirectedNeighborIndex();
    }

    public synchronized void nextTrack() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Set<Integer> trackIDs = this.model.getTrackModel().trackIDs(true);
        if (trackIDs.isEmpty()) {
            return;
        }
        Integer trackID = this.model.getTrackModel().trackIDOf(spot);
        if (null == trackID) {
            trackID = this.model.getTrackModel().trackIDs(true).iterator().next();
        }
        Iterator<Integer> it = trackIDs.iterator();
        Integer nextTrackID = null;
        while (it.hasNext()) {
            Integer id = it.next();
            if (!id.equals(trackID)) continue;
            if (it.hasNext()) {
                nextTrackID = it.next();
                break;
            }
            nextTrackID = trackIDs.iterator().next();
        }
        Set<Spot> spots = this.model.getTrackModel().trackSpots(nextTrackID);
        TreeSet<Spot> ring = new TreeSet<Spot>(Spot.frameComparator);
        ring.addAll(spots);
        Spot target = ring.ceiling(spot);
        if (null == target) {
            target = ring.floor(spot);
        }
        this.selectionModel.clearSelection();
        this.selectionModel.addSpotToSelection(target);
    }

    public synchronized void previousTrack() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Integer trackID = this.model.getTrackModel().trackIDOf(spot);
        Set<Integer> trackIDs = this.model.getTrackModel().trackIDs(true);
        if (trackIDs.isEmpty()) {
            return;
        }
        Integer lastID = null;
        Iterator<Integer> iterator = trackIDs.iterator();
        while (iterator.hasNext()) {
            Integer id;
            lastID = id = iterator.next();
        }
        if (null == trackID) {
            trackID = lastID;
        }
        Iterator<Integer> it = trackIDs.iterator();
        Integer previousTrackID = null;
        while (it.hasNext()) {
            Integer id = it.next();
            if (id.equals(trackID)) {
                if (previousTrackID != null) break;
                previousTrackID = lastID;
                break;
            }
            previousTrackID = id;
        }
        Set<Spot> spots = this.model.getTrackModel().trackSpots(previousTrackID);
        TreeSet<Spot> ring = new TreeSet<Spot>(Spot.frameComparator);
        ring.addAll(spots);
        Spot target = ring.ceiling(spot);
        if (null == target) {
            target = ring.floor(spot);
        }
        this.selectionModel.clearSelection();
        this.selectionModel.addSpotToSelection(target);
    }

    public synchronized void nextSibling() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Integer trackID = this.model.getTrackModel().trackIDOf(spot);
        if (null == trackID) {
            return;
        }
        int frame = spot.getFeature("FRAME").intValue();
        TreeSet<Spot> ring = new TreeSet<Spot>(Spot.nameComparator);
        Set<Spot> spots = this.model.getTrackModel().trackSpots(trackID);
        for (Spot s : spots) {
            int fs = s.getFeature("FRAME").intValue();
            if (frame != fs || s == spot) continue;
            ring.add(s);
        }
        if (!ring.isEmpty()) {
            Spot nextSibling = ring.ceiling(spot);
            if (null == nextSibling) {
                nextSibling = ring.first();
            }
            this.selectionModel.clearSelection();
            this.selectionModel.addSpotToSelection(nextSibling);
        }
    }

    public synchronized void previousSibling() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Integer trackID = this.model.getTrackModel().trackIDOf(spot);
        if (null == trackID) {
            return;
        }
        int frame = spot.getFeature("FRAME").intValue();
        TreeSet<Spot> ring = new TreeSet<Spot>(Spot.nameComparator);
        Set<Spot> spots = this.model.getTrackModel().trackSpots(trackID);
        for (Spot s : spots) {
            int fs = s.getFeature("FRAME").intValue();
            if (frame != fs || s == spot) continue;
            ring.add(s);
        }
        if (!ring.isEmpty()) {
            Spot previousSibling = ring.floor(spot);
            if (null == previousSibling) {
                previousSibling = ring.last();
            }
            this.selectionModel.clearSelection();
            this.selectionModel.addSpotToSelection(previousSibling);
        }
    }

    public synchronized void previousInTime() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Set<Spot> predecessors = this.neighborIndex.predecessorsOf(spot);
        if (!predecessors.isEmpty()) {
            Spot next = predecessors.iterator().next();
            this.selectionModel.clearSelection();
            this.selectionModel.addSpotToSelection(next);
        }
    }

    public synchronized void nextInTime() {
        Spot spot = this.getASpot();
        if (null == spot) {
            return;
        }
        Set<Spot> successors = this.neighborIndex.successorsOf(spot);
        if (!successors.isEmpty()) {
            Spot next = successors.iterator().next();
            this.selectionModel.clearSelection();
            this.selectionModel.addSpotToSelection(next);
        }
    }

    private Spot getASpot() {
        Set<Spot> spotSelection = this.selectionModel.getSpotSelection();
        if (!spotSelection.isEmpty()) {
            Iterator<Spot> it = spotSelection.iterator();
            Spot spot = it.next();
            int minFrame = spot.getFeature("FRAME").intValue();
            while (it.hasNext()) {
                Spot s = it.next();
                int frame = s.getFeature("FRAME").intValue();
                if (frame >= minFrame) continue;
                minFrame = frame;
                spot = s;
            }
            return spot;
        }
        Set<DefaultWeightedEdge> edgeSelection = this.selectionModel.getEdgeSelection();
        if (!edgeSelection.isEmpty()) {
            Iterator<DefaultWeightedEdge> it = edgeSelection.iterator();
            DefaultWeightedEdge edge = it.next();
            Spot spot = this.model.getTrackModel().getEdgeSource(edge);
            int minFrame = spot.getFeature("FRAME").intValue();
            while (it.hasNext()) {
                DefaultWeightedEdge e = it.next();
                Spot s = this.model.getTrackModel().getEdgeSource(e);
                int frame = s.getFeature("FRAME").intValue();
                if (frame >= minFrame) continue;
                minFrame = frame;
                spot = s;
            }
            return spot;
        }
        return null;
    }
}

