/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdService;
import net.imglib2.RandomAccess;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Math", mnemonic=109), @Menu(label="NaN Background", weight=18.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class NanBackground
extends ContextCommand {
    @Parameter
    private ThresholdService threshSrv;
    @Parameter
    private ImageDisplayService dispSrv;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    private Dataset input;

    public void run() {
        if (this.inputBad()) {
            return;
        }
        this.assignPixels();
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    private boolean inputBad() {
        this.input = this.dispSrv.getActiveDataset(this.display);
        if (this.input == null) {
            this.cancel("Image display does not have an active dataset");
            return true;
        }
        if (this.input.isInteger()) {
            this.cancel("This plugin requires a floating point dataset");
            return true;
        }
        if (this.input.getImgPlus() == null) {
            this.cancel("Input ImgPlus is null");
            return true;
        }
        if (!this.threshSrv.hasThreshold(this.display)) {
            this.cancel("Input image is not thresholded");
            return true;
        }
        return false;
    }

    private void assignPixels() {
        ThresholdOverlay thresh = this.threshSrv.getThreshold(this.display);
        PointSet ps = thresh.getPointsOutside();
        PointSetIterator iter = ps.iterator();
        RandomAccess accessor = this.input.getImgPlus().randomAccess();
        while (iter.hasNext()) {
            long[] pos = (long[])iter.next();
            accessor.setPosition(pos);
            ((RealType)accessor.get()).setReal(Double.NaN);
        }
    }
}

