/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GroupRetained;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Locale;
import org.scijava.java3d.MasterControl;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.RestrictedAccessException;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.VirtualUniverse;

class BranchGroupRetained
extends GroupRetained {
    boolean isDirty = false;
    boolean isNew = false;
    boolean attachedToLocale = false;

    BranchGroupRetained() {
        this.nodeType = 19;
    }

    void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        this.dirtyBoundsCache();
        if (this.universe != null) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean isLive = this.source.isLive();
                if (isLive) {
                    this.notifySceneGraphChanged(true);
                }
                GroupRetained oldParent = (GroupRetained)this.parent;
                this.do_detach();
                this.universe.setLiveState.clear();
                if (isLive) {
                    if (oldParent == null) {
                        this.universe.notifyStructureChangeListeners(false, (Object)this.locale, (BranchGroup)this.source);
                    } else {
                        this.universe.notifyStructureChangeListeners(false, (Object)oldParent.source, (BranchGroup)this.source);
                    }
                }
            }
            this.universe.waitForMC();
        } else {
            this.do_detach();
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void do_detach() {
        if (this.attachedToLocale) {
            this.locale.doRemoveBranchGraph((BranchGroup)this.source, null, 0);
        } else if (this.parent != null) {
            GroupRetained g = (GroupRetained)this.parent;
            g.doRemoveChild(g.children.indexOf(this), null, 0);
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        s.parentBranchGroupPaths = this.branchGroupPaths;
        super.setNodeData(s);
        if (!this.inSharedGroup) {
            this.setAuxData(s, 0, 0);
        } else {
            for (int j = 0; j < s.keys.length; ++j) {
                int hkIndex = s.keys[j].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex >= 0) {
                    this.setAuxData(s, j, hkIndex);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        super.setAuxData(s, index, hkIndex);
        BranchGroupRetained[] path = s.branchGroupPaths.get(index);
        BranchGroupRetained[] clonePath = new BranchGroupRetained[path.length + 1];
        System.arraycopy(path, 0, clonePath, 0, path.length);
        clonePath[path.length] = this;
        s.branchGroupPaths.set(index, clonePath);
        this.branchGroupPaths.add(hkIndex, clonePath);
    }

    @Override
    void removeNodeData(SetLiveState s) {
        if (!this.inSharedGroup || s.keys.length == this.localToVworld.length) {
            this.branchGroupPaths = new ArrayList(1);
        } else {
            for (int i = s.keys.length - 1; i >= 0; --i) {
                int index = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (index < 0) continue;
                this.branchGroupPaths.remove(index);
            }
        }
        super.removeNodeData(s);
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        super.markAsLive();
    }

    void compile() {
        if (this.source.isCompiled() || VirtualUniverse.mc.disableCompile) {
            return;
        }
        if (J3dDebug.debug) {
            J3dDebug.doDebug(3, 3, "BranchGroupRetained.compile()....\n");
        }
        CompileState compState = new CompileState();
        this.isRoot = true;
        this.compile(compState);
        this.merge(compState);
        if (J3dDebug.debug) {
            if (J3dDebug.doDebug(3, 3)) {
                compState.printStats();
            }
            if (J3dDebug.doDebug(3, 5)) {
                this.traverse(false, 1);
                System.err.println();
            }
        }
    }

    @Override
    void compile(CompileState compState) {
        if (this.mergeFlag == 2) {
            compState.keepTG = true;
            return;
        }
        super.compile(compState);
        this.mergeFlag = 0;
    }

    SceneGraphPath[] pickAll(PickShape pickShape) {
        PickInfo[] pickInfoArr = this.pickAll(1, 1, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        SceneGraphPath[] sgpArr = new SceneGraphPath[pickInfoArr.length];
        for (int i = 0; i < sgpArr.length; ++i) {
            sgpArr[i] = pickInfoArr[i].getSceneGraphPath();
        }
        return sgpArr;
    }

    PickInfo[] pickAll(int mode, int flags, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geomAtoms = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        return PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 1);
    }

    SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        PickInfo[] pickInfoArr = this.pickAllSorted(1, 1, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        SceneGraphPath[] sgpArr = new SceneGraphPath[pickInfoArr.length];
        for (int i = 0; i < sgpArr.length; ++i) {
            sgpArr[i] = pickInfoArr[i].getSceneGraphPath();
        }
        return sgpArr;
    }

    PickInfo[] pickAllSorted(int mode, int flags, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geomAtoms = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        PickInfo[] pickInfoArr = null;
        if (geomAtoms == null || geomAtoms.length == 0) {
            return null;
        }
        if (mode == 2) {
            pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags |= 0x10, pickShape, 1);
            if (pickInfoArr != null) {
                PickInfo.sortPickInfoArray(pickInfoArr);
            }
        } else {
            PickInfo.sortGeomAtoms(geomAtoms, pickShape);
            pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 1);
        }
        return pickInfoArr;
    }

    SceneGraphPath pickClosest(PickShape pickShape) {
        PickInfo pickInfo = this.pickClosest(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    PickInfo pickClosest(int mode, int flags, PickShape pickShape) {
        PickInfo[] pickInfoArr = null;
        pickInfoArr = this.pickAllSorted(mode, flags, pickShape);
        if (pickInfoArr == null) {
            return null;
        }
        return pickInfoArr[0];
    }

    SceneGraphPath pickAny(PickShape pickShape) {
        PickInfo pickInfo = this.pickAny(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    PickInfo pickAny(int mode, int flags, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geomAtoms = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        PickInfo[] pickInfoArr = PickInfo.pick(this, geomAtoms, mode, flags, pickShape, 2);
        if (pickInfoArr == null) {
            return null;
        }
        return pickInfoArr[0];
    }
}

